/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api.conditions.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.core.registry.BlueprintLootConditions;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class RandomDifficultyChanceCondition
implements LootItemCondition {
    public static final MapCodec<RandomDifficultyChanceCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("default_chance").forGetter(condition -> Float.valueOf(condition.defaultChance)), (App)Codec.FLOAT.optionalFieldOf("peaceful", (Object)Float.valueOf(-1.0f)).forGetter(condition -> Float.valueOf(condition.peacefulChance)), (App)Codec.FLOAT.optionalFieldOf("easy", (Object)Float.valueOf(-1.0f)).forGetter(condition -> Float.valueOf(condition.peacefulChance)), (App)Codec.FLOAT.optionalFieldOf("normal", (Object)Float.valueOf(-1.0f)).forGetter(condition -> Float.valueOf(condition.peacefulChance)), (App)Codec.FLOAT.optionalFieldOf("hard", (Object)Float.valueOf(-1.0f)).forGetter(condition -> Float.valueOf(condition.peacefulChance))).apply((Applicative)instance, RandomDifficultyChanceCondition::new));
    private final float defaultChance;
    private final float peacefulChance;
    private final float easyChance;
    private final float normalChance;
    private final float hardChance;

    public RandomDifficultyChanceCondition(float defaultChance, float peacefulChance, float easyChance, float normalChance, float hardChance) {
        this.defaultChance = defaultChance;
        this.peacefulChance = peacefulChance;
        this.easyChance = easyChance;
        this.normalChance = normalChance;
        this.hardChance = hardChance;
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)BlueprintLootConditions.RANDOM_DIFFICULTY_CHANCE.get();
    }

    public boolean test(LootContext lootContext) {
        float chance = this.defaultChance;
        switch (lootContext.getLevel().getDifficulty()) {
            case PEACEFUL: {
                if (!(this.peacefulChance >= 0.0f)) break;
                chance = this.peacefulChance;
                break;
            }
            case EASY: {
                if (!(this.easyChance >= 0.0f)) break;
                chance = this.easyChance;
                break;
            }
            case NORMAL: {
                if (!(this.normalChance >= 0.0f)) break;
                chance = this.normalChance;
                break;
            }
            case HARD: {
                if (!(this.hardChance >= 0.0f)) break;
                chance = this.hardChance;
            }
        }
        return lootContext.getRandom().nextFloat() < chance;
    }
}

