/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.teamabnormals.blueprint.common.remolder.data.DataType;
import com.teamabnormals.blueprint.common.remolder.data.DataVisitor;
import com.teamabnormals.blueprint.common.remolder.data.DataVisitors;
import com.teamabnormals.blueprint.common.remolder.data.ElementType;
import com.teamabnormals.blueprint.common.remolder.data.Molding;
import com.teamabnormals.blueprint.common.remolder.data.VariableDataVisitor;
import javax.annotation.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public final class JsonMolding
extends Molding {
    public static final DataType<JsonElement> ELEMENT_DATA_TYPE = DataType.type(JsonElement.class);
    public static final DataType<JsonArray> ARRAY_DATA_TYPE = DataType.type(JsonArray.class);
    public static final DataType<JsonObject> OBJECT_DATA_TYPE = DataType.type(JsonObject.class);
    public static final DataType<JsonNull> NULL_DATA_TYPE = DataType.type(JsonNull.class);
    public static final DataType<JsonPrimitive> PRIMITIVE_DATA_TYPE = DataType.type(JsonPrimitive.class);

    public JsonMolding(MethodVisitor method, String fieldOwnerTypeName, VariableDataVisitor fieldOwnerVariable, int localVariableOffset) {
        super(method, fieldOwnerTypeName, fieldOwnerVariable, localVariableOffset);
    }

    @Override
    public DataType<?> getDataType() {
        return ELEMENT_DATA_TYPE;
    }

    @Override
    public DataType<?> getListType() {
        return ARRAY_DATA_TYPE;
    }

    @Override
    public DataType<?> getMapType() {
        return OBJECT_DATA_TYPE;
    }

    @Override
    public DataType<?> getNullType() {
        return NULL_DATA_TYPE;
    }

    @Override
    public DataType<?> getRepresentationType(DataType<?> type) {
        if (type.getClazz().isPrimitive() || type == DataType.BOOLEAN_WRAPPER || type == DataType.CHARACTER_WRAPPER || type == DataType.STRING || Number.class.isAssignableFrom(type.getClazz())) {
            return PRIMITIVE_DATA_TYPE;
        }
        if (ELEMENT_DATA_TYPE.getClazz().isAssignableFrom(type.getClazz())) {
            return type;
        }
        throw new UnsupportedOperationException("Can't represent type: " + String.valueOf(type));
    }

    @Override
    @Nullable
    public ElementType getElementType(DataType<?> type) {
        if (type == ARRAY_DATA_TYPE) {
            return ElementType.LIST;
        }
        if (type == OBJECT_DATA_TYPE) {
            return ElementType.MAP;
        }
        if (ELEMENT_DATA_TYPE.getClazz().isAssignableFrom(type.getClazz())) {
            return ElementType.ELEMENTAL;
        }
        return null;
    }

    @Override
    public void element(DataVisitor visitor) throws UnsupportedOperationException {
        DataType<?> dataType = visitor.getReturnType().getDataType(this);
        Class<?> clazz = dataType.getClazz();
        if (ELEMENT_DATA_TYPE.getClazz().isAssignableFrom(clazz)) {
            visitor.visit(this);
            this.visitMethodInsn(182, ELEMENT_DATA_TYPE.getInternalName(), "deepCopy", "()Lcom/google/gson/JsonElement;", false);
        } else if (dataType == DataType.STRING) {
            this.newPrimitive(visitor, "(Ljava/lang/String;)V", null);
        } else if (dataType == DataType.CHARACTER_WRAPPER) {
            this.newPrimitive(visitor, "(Ljava/lang/Character;)V", null);
        } else if (dataType == DataType.BOOLEAN_WRAPPER) {
            this.newPrimitive(visitor, "(Ljava/lang/Boolean;)V", null);
        } else if (DataType.NUMBER.getClazz().isAssignableFrom(clazz)) {
            this.newPrimitive(visitor, "(Ljava/lang/Number;)V", null);
        } else if (clazz.isPrimitive()) {
            this.newPrimitive(visitor, "(Ljava/lang/Number;)V", clazz);
        } else {
            throw new UnsupportedOperationException("Don't know to create element from parameter of type: " + String.valueOf(dataType));
        }
    }

    @Override
    public void convert(DataType<?> from, DataType<?> to) throws UnsupportedOperationException {
        Class<?> toClazz = to.getClazz();
        if (toClazz.isAssignableFrom(from.getClazz())) {
            return;
        }
        if (ELEMENT_DATA_TYPE == from) {
            this.visitTypeInsn(192, PRIMITIVE_DATA_TYPE.getInternalName());
        } else if (PRIMITIVE_DATA_TYPE != from) {
            throw new UnsupportedOperationException("Don't know to convert from " + String.valueOf(from));
        }
        if (to == DataType.STRING) {
            this.invokeVirtualPrimitive("getAsString", "()Ljava/lang/String;");
        } else if (to == DataType.BOOLEAN) {
            this.invokeVirtualPrimitive("getAsBoolean", "()Z");
        } else if (to == DataType.INT) {
            this.invokeVirtualPrimitive("getAsInt", "()I");
        } else if (to == DataType.LONG) {
            this.invokeVirtualPrimitive("getAsLong", "()J");
        } else if (to == DataType.FLOAT) {
            this.invokeVirtualPrimitive("getAsFloat", "()F");
        } else if (to == DataType.DOUBLE) {
            this.invokeVirtualPrimitive("getAsDouble", "()D");
        } else if (to == DataType.CHAR) {
            this.invokeVirtualPrimitive("getAsCharacter", "()C");
        } else if (to == DataType.BYTE) {
            this.invokeVirtualPrimitive("getAsByte", "()B");
        } else if (to == DataType.SHORT) {
            this.invokeVirtualPrimitive("getAsShort", "()S");
        } else if (Number.class.isAssignableFrom(toClazz)) {
            this.invokeVirtualPrimitive("getAsNumber", "()Ljava/lang/Number;");
            if (toClazz != Number.class) {
                this.visitTypeInsn(192, to.getInternalName());
            }
        } else {
            throw new UnsupportedOperationException("Don't know to convert to " + String.valueOf(to));
        }
    }

    @Override
    public void toString(DataType<?> type) throws UnsupportedOperationException {
        if (!ELEMENT_DATA_TYPE.getClazz().isAssignableFrom(type.getClazz())) {
            throw new UnsupportedOperationException("Conversion to string is only supported for elemental types");
        }
        this.visitMethodInsn(184, "java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;", false);
    }

    @Override
    public void testElementalList() {
        this.visitTypeInsn(193, ARRAY_DATA_TYPE.getInternalName());
    }

    @Override
    public void testElementalMap() {
        this.visitTypeInsn(193, OBJECT_DATA_TYPE.getInternalName());
    }

    @Override
    public void testStringElement() {
        this.testPrimitive("isString");
    }

    @Override
    public void testNumericalElement() {
        this.testPrimitive("isNumber");
    }

    @Override
    public void testBooleanElement() {
        this.testPrimitive("isBoolean");
    }

    @Override
    public void size(DataType<?> collectionType) {
        if (collectionType == ARRAY_DATA_TYPE) {
            this.invokeVirtualArray("size", "()I");
        } else if (collectionType == OBJECT_DATA_TYPE) {
            this.invokeVirtualObject("size", "()I");
        } else if (collectionType == ELEMENT_DATA_TYPE) {
            Label isJsonArrayLabel = new Label();
            Label endLabel = new Label();
            this.visitInsn(89);
            this.visitTypeInsn(193, ARRAY_DATA_TYPE.getInternalName());
            this.visitJumpInsn(154, isJsonArrayLabel);
            this.visitTypeInsn(192, OBJECT_DATA_TYPE.getInternalName());
            this.invokeVirtualObject("size", "()I");
            this.visitJumpInsn(167, endLabel);
            this.visitLabel(isJsonArrayLabel);
            this.invokeVirtualArray("size", "()I");
            this.visitLabel(endLabel);
        } else {
            throw new UnsupportedOperationException("Don't know how to get size from type " + String.valueOf(collectionType));
        }
    }

    @Override
    public void get(DataVisitor object, @Nullable DataVisitor key) throws UnsupportedOperationException {
        DataType<?> dataType = object.getReturnType().getDataType(this);
        Class<?> clazz = dataType.getClazz();
        this.assertElemental(dataType, clazz, "Cannot get child of non-elemental type: ");
        if (key == null) {
            this.prepareLastElementVisit(object, clazz);
            this.invokeVirtualArray("get", "(I)Lcom/google/gson/JsonElement;");
        } else {
            DataType<?> keyDataType = key.getReturnType().getDataType(this);
            if (keyDataType == DataType.INT) {
                this.prepareChildVisit(object, key, clazz, ARRAY_DATA_TYPE);
                this.invokeVirtualArray("get", "(I)Lcom/google/gson/JsonElement;");
            } else if (keyDataType == DataType.STRING) {
                this.prepareChildVisit(object, key, clazz, OBJECT_DATA_TYPE);
                this.invokeVirtualObject("get", "(Ljava/lang/String;)Lcom/google/gson/JsonElement;");
            } else {
                throw new UnsupportedOperationException("Unknown key type for child getting: " + String.valueOf(keyDataType));
            }
        }
    }

    @Override
    public void set(DataVisitor object, @Nullable DataVisitor key, DataVisitor value) throws UnsupportedOperationException {
        DataType<?> dataType = object.getReturnType().getDataType(this);
        Class<?> clazz = dataType.getClazz();
        this.assertElemental(dataType, clazz, "Cannot set child of non-elemental type: ");
        DataType<?> valueType = value.getReturnType().getDataType(this);
        this.assertElemental(valueType, valueType.getClazz(), "Cannot set child as non-elemental type: ");
        if (key == null) {
            this.prepareLastElementVisit(object, clazz);
            value.visit(this);
            this.invokeVirtualArray("set", "(ILcom/google/gson/JsonElement;)Lcom/google/gson/JsonElement;");
        } else {
            DataType<?> keyDataType = key.getReturnType().getDataType(this);
            if (keyDataType == DataType.INT) {
                this.prepareChildVisit(object, key, clazz, ARRAY_DATA_TYPE);
                value.visit(this);
                this.invokeVirtualArray("set", "(ILcom/google/gson/JsonElement;)Lcom/google/gson/JsonElement;");
            } else if (keyDataType == DataType.STRING) {
                object.visit(this);
                this.checkThenCast(clazz, OBJECT_DATA_TYPE);
                this.invokeVirtualObject("asMap", "()Ljava/util/Map;");
                key.visit(this);
                value.visit(this);
                this.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
                this.visitTypeInsn(192, ELEMENT_DATA_TYPE.getInternalName());
            } else {
                throw new UnsupportedOperationException("Unknown key type for setting child: " + String.valueOf(keyDataType));
            }
        }
    }

    @Override
    public void add(DataVisitor object, @Nullable DataVisitor key, DataVisitor value) throws UnsupportedOperationException {
        DataType<?> dataType = object.getReturnType().getDataType(this);
        Class<?> clazz = dataType.getClazz();
        this.assertElemental(dataType, clazz, "Cannot add child of non-elemental type: ");
        DataType<?> valueType = value.getReturnType().getDataType(this);
        this.assertElemental(valueType, valueType.getClazz(), "Cannot add child as non-elemental type: ");
        if (key == null) {
            object.visit(this);
            this.checkThenCast(clazz, ARRAY_DATA_TYPE);
            value.visit(this);
            this.invokeVirtualArray("add", "(Lcom/google/gson/JsonElement;)V");
        } else {
            DataType<?> keyDataType = key.getReturnType().getDataType(this);
            if (keyDataType == DataType.INT) {
                object.visit(this);
                this.checkThenCast(clazz, ARRAY_DATA_TYPE);
                this.invokeVirtualArray("asList", "()Ljava/util/List;");
                key.visit(this);
                value.visit(this);
                this.visitMethodInsn(185, "java/util/List", "add", "(ILjava/lang/Object;)V", true);
            } else if (keyDataType == DataType.STRING) {
                object.visit(this);
                this.checkThenCast(clazz, OBJECT_DATA_TYPE);
                this.visitInsn(89);
                key.visit(this);
                this.visitInsn(90);
                this.invokeVirtualObject("has", "(Ljava/lang/String;)Z");
                Label keyExistsLabel = new Label();
                this.visitJumpInsn(154, keyExistsLabel);
                value.visit(this);
                this.invokeVirtualObject("add", "(Ljava/lang/String;Lcom/google/gson/JsonElement;)V");
                Label endLabel = new Label();
                this.visitJumpInsn(167, endLabel);
                this.visitLabel(keyExistsLabel);
                this.visitInsn(88);
                this.visitLabel(endLabel);
            } else {
                throw new UnsupportedOperationException("Unknown key type for setting child: " + String.valueOf(keyDataType));
            }
        }
    }

    @Override
    public void remove(DataVisitor object, @Nullable DataVisitor key) throws UnsupportedOperationException {
        DataType<?> dataType = object.getReturnType().getDataType(this);
        Class<?> clazz = dataType.getClazz();
        this.assertElemental(dataType, clazz, "Cannot remove child of non-elemental type: ");
        if (key == null) {
            this.prepareLastElementVisit(object, clazz);
            this.invokeVirtualArray("remove", "(I)Lcom/google/gson/JsonElement;");
        } else {
            DataType<?> keyDataType = key.getReturnType().getDataType(this);
            if (keyDataType == DataType.INT) {
                this.prepareChildVisit(object, key, clazz, ARRAY_DATA_TYPE);
                this.invokeVirtualArray("remove", "(I)Lcom/google/gson/JsonElement;");
            } else if (keyDataType == DataType.STRING) {
                this.prepareChildVisit(object, key, clazz, OBJECT_DATA_TYPE);
                this.invokeVirtualObject("remove", "(Ljava/lang/String;)Lcom/google/gson/JsonElement;");
            } else {
                throw new UnsupportedOperationException("Unknown key type for removing child: " + String.valueOf(keyDataType));
            }
        }
    }

    @Override
    public void clear(DataType<?> type) throws UnsupportedOperationException {
        if (type == ARRAY_DATA_TYPE) {
            this.invokeVirtualArray("asList", "()Ljava/util/List;");
            this.visitMethodInsn(185, "java/util/List", "clear", "()V", true);
        } else if (type == OBJECT_DATA_TYPE) {
            this.invokeVirtualObject("asMap", "()Ljava/util/Map;");
            this.visitMethodInsn(185, "java/util/Map", "clear", "()V", true);
        } else {
            throw new UnsupportedOperationException("Cannot clear variable of type: " + String.valueOf(type));
        }
    }

    private void newPrimitive(DataVisitor visitor, String constructorDesc, @Nullable Class<?> primitiveClass) {
        this.visitTypeInsn(187, PRIMITIVE_DATA_TYPE.getInternalName());
        this.visitInsn(89);
        visitor.visit(this);
        if (primitiveClass != null) {
            DataVisitors.boxPrimitive(this, primitiveClass);
        }
        this.visitMethodInsn(183, PRIMITIVE_DATA_TYPE.getInternalName(), "<init>", constructorDesc, false);
    }

    private void invokeVirtualPrimitive(String method, String descriptor) {
        this.visitMethodInsn(182, PRIMITIVE_DATA_TYPE.getInternalName(), method, descriptor, false);
    }

    private void testPrimitive(String method) {
        Label falseLabel = new Label();
        Label endLabel = new Label();
        this.visitInsn(89);
        this.visitTypeInsn(193, PRIMITIVE_DATA_TYPE.getInternalName());
        this.visitJumpInsn(153, falseLabel);
        this.visitTypeInsn(192, PRIMITIVE_DATA_TYPE.getInternalName());
        this.invokeVirtualPrimitive(method, "()Z");
        this.visitJumpInsn(167, endLabel);
        this.visitLabel(falseLabel);
        this.visitInsn(87);
        this.visitInsn(3);
        this.visitLabel(endLabel);
    }

    private void invokeVirtualArray(String method, String descriptor) {
        this.visitMethodInsn(182, ARRAY_DATA_TYPE.getInternalName(), method, descriptor, false);
    }

    private void invokeVirtualObject(String method, String descriptor) {
        this.visitMethodInsn(182, OBJECT_DATA_TYPE.getInternalName(), method, descriptor, false);
    }

    private void assertElemental(DataType<?> type, Class<?> clazz, String message) {
        if (!ELEMENT_DATA_TYPE.getClazz().isAssignableFrom(clazz)) {
            throw new UnsupportedOperationException(message + String.valueOf(type));
        }
    }

    private void prepareLastElementVisit(DataVisitor object, Class<?> clazz) {
        object.visit(this);
        this.checkThenCast(clazz, ARRAY_DATA_TYPE);
        this.visitInsn(89);
        this.invokeVirtualArray("size", "()I");
        this.visitInsn(4);
        this.visitInsn(100);
    }
}

