/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.block;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.blueprint.common.entity.BlueprintFallingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlueprintFallingBlock
extends FallingBlock {
    private static final MapCodec<BlueprintFallingBlock> CODEC = BlueprintFallingBlock.simpleCodec(BlueprintFallingBlock::new);

    public BlueprintFallingBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (BlueprintFallingBlock.isFree((BlockState)level.getBlockState(pos.below())) && pos.getY() >= level.getMinBuildHeight()) {
            BlueprintFallingBlockEntity fallingblockentity = BlueprintFallingBlockEntity.fall((Level)level, pos, state);
            fallingblockentity.setDropsBlockLoot(this.dropsBlockLoot(fallingblockentity, state, pos));
            fallingblockentity.setAllowsPlacing(this.allowsPlacing(fallingblockentity, state, pos));
            this.falling(fallingblockentity);
        }
    }

    public boolean dropsBlockLoot(BlueprintFallingBlockEntity fallingBlockEntity, BlockState state, BlockPos pos) {
        return true;
    }

    public boolean allowsPlacing(BlueprintFallingBlockEntity fallingBlockEntity, BlockState state, BlockPos pos) {
        return true;
    }
}

