/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.ModelEvent;

@OnlyIn(value=Dist.CLIENT)
public class DynamicItemModel
implements BakedModel {
    private final BakedModel model;
    private final ItemOverrides overrideList;

    public DynamicItemModel(String folder, ModelResourceLocation defaultModel, ModelPredicate predicate, Map<ModelResourceLocation, BakedModel> modelManager) {
        this.model = modelManager.get(defaultModel);
        this.overrideList = new Overrides(modelManager, folder, defaultModel, predicate);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.model.getQuads(state, side, rand);
    }

    public boolean useAmbientOcclusion() {
        return this.model.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.model.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.model.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.model.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.model.getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        return this.overrideList;
    }

    public static FishBucketPredicate fishBucket() {
        return FishBucketPredicate.INSTANCE;
    }

    public static void register(ModelEvent.RegisterAdditional event, String folder) {
        for (ResourceLocation location : Minecraft.getInstance().getResourceManager().listResources("models/item/" + folder, s -> s.getPath().endsWith(".json")).keySet()) {
            event.register(ModelResourceLocation.standalone((ResourceLocation)location.withPath(location.getPath().substring("models/".length(), location.getPath().length() - ".json".length()))));
        }
    }

    public static void bake(ModelEvent.ModifyBakingResult event, ResourceLocation model, String folder, ModelResourceLocation defaultModel, ModelPredicate predicate) {
        event.getModels().put(ModelResourceLocation.inventory((ResourceLocation)model), new DynamicItemModel(folder, defaultModel, predicate, event.getModels()));
    }

    public static class Overrides
    extends ItemOverrides {
        private final Map<ModelResourceLocation, BakedModel> modelManager;
        private final BakedModel model;
        private final Map<String, ResourceLocation> locationCache;
        private final Map<ResourceLocation, ModelResourceLocation> modelLocations;
        private final ModelPredicate predicate;

        private Overrides(Map<ModelResourceLocation, BakedModel> modelManager, String folder, ModelResourceLocation defaultModel, ModelPredicate predicate) {
            this.predicate = predicate;
            this.modelManager = modelManager;
            this.model = modelManager.get(defaultModel);
            this.locationCache = new HashMap<String, ResourceLocation>();
            this.modelLocations = new HashMap<ResourceLocation, ModelResourceLocation>();
            for (ResourceLocation location : Minecraft.getInstance().getResourceManager().listResources("models/item/" + folder, s -> s.getPath().endsWith(".json")).keySet()) {
                this.modelLocations.put(location.withPath(location.getPath().substring(("models/item/" + folder + "/").length(), location.getPath().length() - ".json".length())), ModelResourceLocation.standalone((ResourceLocation)location.withPath(location.getPath().substring("models/".length(), location.getPath().length() - ".json".length()))));
            }
        }

        @Nullable
        public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity entity, int i) {
            ResourceLocation variant;
            Optional<String> str;
            ClientLevel level = clientLevel;
            if (level == null) {
                level = Minecraft.getInstance().level;
            }
            if ((str = this.predicate.test(stack, level, entity)).isPresent() && this.modelLocations.containsKey(variant = this.locationCache.computeIfAbsent(str.get(), ResourceLocation::parse))) {
                return this.modelManager.get(this.modelLocations.get(variant));
            }
            return this.model;
        }
    }

    public static interface ModelPredicate {
        public Optional<String> test(ItemStack var1, @Nullable ClientLevel var2, @Nullable LivingEntity var3);
    }

    public static class FishBucketPredicate
    implements ModelPredicate {
        private static final FishBucketPredicate INSTANCE = new FishBucketPredicate();

        private FishBucketPredicate() {
        }

        @Override
        public Optional<String> test(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity) {
            CompoundTag tag;
            CustomData data = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
            if (!data.isEmpty() && level != null && (tag = data.copyTag()).contains("BucketVariantTag", 8)) {
                return Optional.of(tag.getString("BucketVariantTag"));
            }
            return Optional.empty();
        }
    }
}

