/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.natives.Agc;
import de.maxhenkel.voicechat.natives.Denoiser;
import de.maxhenkel.voicechat.natives.RNNoiseManager;
import de.maxhenkel.voicechat.natives.SpeexManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.VolumeManager;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public abstract class MicrophoneProcessor {
    public static final float AGC_PROBABILITY = 0.95f;
    private final MicActivator micActivator = new MicActivator(this::getDeactivationDelay);
    private final MicActivator whisperMicActivator = new MicActivator(VoicechatClient.CLIENT_CONFIG.pttDeactivationDelay::get);
    private final VolumeManager volumeManager = new VolumeManager();
    private boolean whispering;
    private boolean activating;
    protected float speechProbability;
    @Nullable
    private Denoiser denoiser = RNNoiseManager.createDenoiser();
    @Nullable
    private Agc agc;

    public MicrophoneProcessor() {
        if (this.denoiser == null) {
            Voicechat.LOGGER.warn("Denoiser not available", new Object[0]);
        }
        this.agc = SpeexManager.createAgc();
        if (this.agc == null) {
            Voicechat.LOGGER.warn("AGC not available", new Object[0]);
        }
    }

    public abstract int getDeactivationDelay();

    protected void preprocess(short[] audio) {
        Denoiser denoiser = this.getDenoiser();
        this.speechProbability = denoiser != null ? (this.useDenoiser() ? denoiser.denoiseInPlace(audio) : denoiser.getSpeechProbability(audio)) : 1.0f;
        Agc agc = this.getAgc();
        if (this.useAgc() && agc != null) {
            if (this.speechProbability >= 0.95f && this.shouldAdjustGain()) {
                agc.setIncrement(12);
            } else {
                agc.setIncrement(0);
            }
            agc.agc(audio);
        } else {
            this.volumeManager.adjustVolume(audio, VoicechatClient.CLIENT_CONFIG.microphoneGain.get());
        }
    }

    public void process(short[] audio, boolean testing) {
        boolean w = this.isWhisperButtonDown();
        this.preprocess(audio);
        boolean a = this.processInternal(audio, testing);
        this.activating = this.micActivator.shouldStillSend(a);
        if (a) {
            this.whispering = w;
            this.whisperMicActivator.reset();
        } else {
            this.whispering = !this.isMuted() && this.whisperMicActivator.shouldStillSend(w);
        }
    }

    protected abstract boolean processInternal(short[] var1, boolean var2);

    protected abstract boolean shouldAdjustGain();

    public abstract MicrophoneActivationType getActivationType();

    public float getSpeechProbability() {
        return this.speechProbability;
    }

    public boolean isWhispering() {
        return this.whispering;
    }

    public boolean shouldTransmitAudio() {
        return this.activating || this.whispering;
    }

    public void reset() {
        this.micActivator.reset();
        this.whisperMicActivator.reset();
        this.whispering = false;
        this.activating = false;
    }

    public void close() {
        if (this.denoiser != null) {
            this.denoiser.close();
        }
        if (this.agc != null) {
            this.agc.close();
        }
    }

    public boolean isMuted() {
        return ClientManager.getPlayerStateManager().isMuted();
    }

    public boolean isAnyTalkButtonDown() {
        return ClientManager.getPttKeyHandler().isAnyDown();
    }

    public boolean isPttButtonDown() {
        return ClientManager.getPttKeyHandler().isPTTDown();
    }

    public boolean isWhisperButtonDown() {
        return ClientManager.getPttKeyHandler().isWhisperDown();
    }

    public boolean useAgc() {
        return VoicechatClient.CLIENT_CONFIG.agc.get();
    }

    public boolean useDenoiser() {
        return VoicechatClient.CLIENT_CONFIG.denoiser.get();
    }

    public boolean agcAvailable() {
        return this.agc != null;
    }

    public boolean denoiserAvailable() {
        return this.denoiser != null;
    }

    @Nullable
    protected Denoiser getDenoiser() {
        if (this.denoiser != null && this.denoiser.isClosed()) {
            this.denoiser = RNNoiseManager.createDenoiser();
        }
        return this.denoiser;
    }

    @Nullable
    protected Agc getAgc() {
        if (this.agc != null && this.agc.isClosed()) {
            this.agc = SpeexManager.createAgc();
        }
        return this.agc;
    }

    protected static class MicActivator {
        private final Supplier<Integer> delay;
        private int deactivationDelay;

        public MicActivator(Supplier<Integer> delay) {
            this.delay = delay;
        }

        public boolean shouldStillSend(boolean activating) {
            if (activating) {
                this.deactivationDelay = this.delay.get();
                return true;
            }
            if (this.deactivationDelay > 0) {
                --this.deactivationDelay;
                return true;
            }
            return false;
        }

        public void reset() {
            this.deactivationDelay = 0;
        }
    }
}

