/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import immersive_aircraft.entity.VehicleEntity;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    @Final
    private Camera mainCamera;

    @Inject(method={"bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at={@At(value="HEAD")}, cancellable=false)
    public void immersiveAircraft$renderWorld(PoseStack poseStack, float partialTicks, CallbackInfo ci) {
        Entity entity;
        Entity entity2 = this.mainCamera.getEntity();
        if (entity2 != null && !this.mainCamera.isDetached() && (entity = entity2.getRootVehicle()) instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            if (vehicle.adaptPlayerRotation) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(vehicle.getRoll(partialTicks)));
                poseStack.mulPose(Axis.XP.rotationDegrees(vehicle.getViewXRot(partialTicks)));
            }
            float eye = entity2.getEyeHeight();
            Vector3f offset = new Vector3f(0.0f, -eye, 0.0f);
            Quaternionf quaternion = Axis.XP.rotationDegrees(0.0f);
            quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(-vehicle.getViewYRot(partialTicks)));
            quaternion.mul((Quaternionfc)Axis.XP.rotationDegrees(vehicle.getViewXRot(partialTicks)));
            quaternion.mul((Quaternionfc)Axis.ZP.rotationDegrees(vehicle.getRoll(partialTicks)));
            offset.rotate((Quaternionfc)quaternion);
            poseStack.mulPose(Axis.XP.rotationDegrees(this.mainCamera.getXRot()));
            poseStack.mulPose(Axis.YP.rotationDegrees(this.mainCamera.getYRot() + 180.0f));
            poseStack.translate(offset.x(), offset.y() + eye, offset.z());
            poseStack.mulPose(Axis.YP.rotationDegrees(-this.mainCamera.getYRot() - 180.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(-this.mainCamera.getXRot()));
        }
    }
}

