/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import com.google.common.collect.Lists;
import com.mojang.math.Axis;
import earth.terrarium.adastra.api.systems.GravityApi;
import immersive_aircraft.CompatUtil;
import immersive_aircraft.Main;
import immersive_aircraft.Sounds;
import immersive_aircraft.client.KeyBindings;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.data.VehicleDataLoader;
import immersive_aircraft.entity.misc.BoundingBoxDescriptor;
import immersive_aircraft.entity.misc.PositionDescriptor;
import immersive_aircraft.entity.misc.VehicleData;
import immersive_aircraft.network.c2s.CollisionMessage;
import immersive_aircraft.network.c2s.CommandMessage;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.util.InterpolatedFloat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class VehicleEntity
extends Entity {
    public final ResourceLocation identifier;
    private static final EntityDataAccessor<Float> DATA_HEALTH = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Integer> DAMAGE_WOBBLE_TICKS = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> DAMAGE_WOBBLE_SIDE = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Float> DAMAGE_WOBBLE_STRENGTH = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected final boolean canExplodeOnCrash;
    protected static final EntityDataAccessor<Integer> BOOST = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected int interpolationSteps;
    protected int lastTriedToExit;
    protected double x;
    protected double y;
    protected double z;
    protected double serverYRot;
    protected double serverXRot;
    protected float movementX;
    protected float movementY;
    protected float movementZ;
    public final InterpolatedFloat pressingInterpolatedX;
    public final InterpolatedFloat pressingInterpolatedY;
    public final InterpolatedFloat pressingInterpolatedZ;
    public float roll;
    public float prevRoll;
    public double lastX;
    public double lastY;
    public double lastZ;
    public double secondLastX;
    public double secondLastY;
    public double secondLastZ;
    public boolean adaptPlayerRotation = true;
    private int drowning;
    protected static final Vector4f ZERO_VEC4 = new Vector4f();

    public float getRoll() {
        return this.roll;
    }

    public float getRoll(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.prevRoll, (float)this.getRoll());
    }

    public void setXRot(float pitch) {
        float loops = (float)(Math.floor((pitch + 180.0f) / 360.0f) * 360.0);
        this.xRotO -= loops;
        super.setXRot(pitch -= loops);
    }

    public void setZRot(float rot) {
        this.roll = rot;
    }

    public void boost() {
        this.boost(100);
    }

    public void boost(int ticks) {
        this.entityData.set(BOOST, (Object)ticks);
    }

    protected void applyBoost() {
    }

    public boolean canBoost() {
        return false;
    }

    public int getBoost() {
        return (Integer)this.entityData.get(BOOST);
    }

    public VehicleData getVehicleData() {
        return VehicleDataLoader.get(this.identifier);
    }

    public int getPassengerSpace() {
        return this.getVehicleData().getPassengerPositions().size();
    }

    public VehicleEntity(EntityType<? extends VehicleEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world);
        this.canExplodeOnCrash = canExplodeOnCrash;
        this.blocksBuilding = true;
        this.pressingInterpolatedX = new InterpolatedFloat(this.getInputInterpolationSteps());
        this.pressingInterpolatedY = new InterpolatedFloat(this.getInputInterpolationSteps());
        this.pressingInterpolatedZ = new InterpolatedFloat(this.getInputInterpolationSteps());
        this.identifier = BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType());
    }

    public float maxUpStep() {
        return 0.55f;
    }

    protected float getInputInterpolationSteps() {
        return 10.0f;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder entityData) {
        entityData.define(DAMAGE_WOBBLE_TICKS, (Object)0);
        entityData.define(DAMAGE_WOBBLE_SIDE, (Object)1);
        entityData.define(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(0.0f));
        entityData.define(DATA_HEALTH, (Object)Float.valueOf(1.0f));
        entityData.define(BOOST, (Object)0);
    }

    public boolean canCollideWith(@NotNull Entity other) {
        return VehicleEntity.canCollide(this, other);
    }

    public static boolean canCollide(Entity entity, Entity other) {
        return (other.canBeCollidedWith() || other.isPushable()) && !entity.isPassengerOfSameVehicle(other);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public Vec3 getRelativePortalPosition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Direction.Axis portalAxis, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockUtil.FoundRectangle portalRect) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition((Vec3)super.getRelativePortalPosition(portalAxis, portalRect));
    }

    public boolean skipAttackInteraction(@NotNull Entity attacker) {
        return this.hasPassenger(attacker) || super.skipAttackInteraction(attacker);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (this.level().isClientSide || this.isRemoved()) {
            return true;
        }
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().instabuild) {
                this.dropInventory();
                this.discard();
                return true;
            }
        }
        if (amount > 0.0f && source.getEntity() instanceof Player && this.getPassengers().isEmpty() && source.isDirect()) {
            amount = Math.max(5.0f, amount);
        }
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength((float)((double)this.getDamageWobbleStrength() + Math.sqrt(amount) * 5.0 / (double)(1.0f + this.getDamageWobbleStrength() * 0.05f)));
        this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
        boolean force = !(source.getDirectEntity() instanceof Player);
        this.applyDamage(amount / this.getDurability() / (float)Config.getInstance().damagePerHealthPoint, force);
        return true;
    }

    private void applyDamage(float amount, boolean force) {
        if (this.isRemoved()) {
            return;
        }
        float health = this.getHealth() - amount;
        if (health <= 0.0f) {
            this.setHealth(0.0f);
            double x = this.getX();
            double y = this.getY();
            double z = this.getZ();
            this.discard();
            if (force && this.canExplodeOnCrash && Config.getInstance().enableCrashExplosion) {
                this.level().explode((Entity)this, x, y, z, Config.getInstance().crashExplosionRadius, Config.getInstance().enableCrashFire, Config.getInstance().enableCrashBlockDestruction ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE);
            }
            if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) && Config.getInstance().enableDropsForNonPlayer) {
                this.dropInventory();
                this.drop();
            }
        } else {
            this.setHealth(health);
        }
    }

    private void repair(float amount) {
        float health = Math.min(1.0f, this.getHealth() + amount);
        this.setHealth(health);
    }

    public float getDurability() {
        return 1.0f;
    }

    protected void drop() {
        if (Config.getInstance().dropAircraft) {
            ItemStack stack = new ItemStack((ItemLike)this.asItem());
            this.addItemTag(stack);
            this.spawnAtLocation(stack);
        }
    }

    protected void dropInventory() {
    }

    public void onAboveBubbleCol(boolean drag) {
        this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() + (double)this.random.nextFloat(), this.getY() + 0.7, this.getZ() + (double)this.random.nextFloat(), 0.0, 0.0, 0.0);
        if (this.random.nextInt(20) == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), this.getSwimSplashSound(), this.getSoundSource(), 1.0f, 0.8f + 0.4f * this.random.nextFloat(), false);
        }
        this.gameEvent((Holder)GameEvent.SPLASH, (Entity)this.getControllingPassenger());
    }

    public Item asItem() {
        return Items.STICK;
    }

    public void animateHurt(float yaw) {
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() * 11.0f);
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int steps) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    private static float getMovementMultiplier(boolean positive, boolean negative) {
        if (positive == negative) {
            return 0.0f;
        }
        return positive ? 1.0f : -1.0f;
    }

    protected boolean useAirplaneControls() {
        return false;
    }

    public void tick() {
        int t;
        if (this.tickCount % 10 == 0) {
            this.secondLastX = this.lastX;
            this.secondLastY = this.lastY;
            this.secondLastZ = this.lastZ;
            this.lastX = this.getX();
            this.lastY = this.getY();
            this.lastZ = this.getZ();
            if (this.secondLastX == 0.0 && this.secondLastY == 0.0 && this.secondLastZ == 0.0) {
                this.secondLastX = this.lastX;
                this.secondLastY = this.lastY;
                this.secondLastZ = this.lastZ;
            }
        }
        if (!this.getPassengers().isEmpty()) {
            this.tickPilot();
        }
        if (this.getDamageWobbleTicks() > 0) {
            this.setDamageWobbleTicks(this.getDamageWobbleTicks() - 1);
        }
        if (this.getDamageWobbleStrength() > 0.0f) {
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() - 1.0f);
        }
        super.tick();
        this.handleClientSync();
        int boost = this.getBoost();
        if (boost > 0) {
            this.entityData.set(BOOST, (Object)(boost - 1));
        }
        if (this.isControlledByLocalInstance()) {
            this.updateVelocity();
            if (boost > 0) {
                this.applyBoost();
            }
            this.updateController();
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
        this.checkInsideBlocks();
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.pushableBy((Entity)this));
        if (!list.isEmpty()) {
            boolean bl = !this.level().isClientSide && !(this.getControllingPassenger() instanceof Player);
            for (Entity entity : list) {
                if (entity.hasPassenger((Entity)this) || !bl || this.getPassengers().size() >= this.getPassengerSpace() - 1 || entity.isPassenger() || !(entity.getBbWidth() < this.getBbWidth()) || !(entity instanceof LivingEntity) || entity instanceof WaterAnimal || entity instanceof Player) continue;
                entity.startRiding((Entity)this);
            }
        }
        if (this.isControlledByLocalInstance()) {
            this.pressingInterpolatedX.update(this.movementX);
            this.pressingInterpolatedY.update(this.movementY);
            this.pressingInterpolatedZ.update(this.movementZ);
        }
        this.tickDamageParticles();
        if (!this.level().isClientSide && (t = Config.getInstance().regenerateHealthEveryNTicks) > 0 && this.level().getGameTime() % (long)t == 0L) {
            this.repair(0.05f / this.getDurability());
        }
    }

    private void tickDamageParticles() {
        double z;
        double y;
        double x;
        Vec3 center;
        if (this.level().isClientSide && this.random.nextFloat() > this.getHealth()) {
            List<AABB> shapes = this.getShapes();
            AABB shape = shapes.get(this.random.nextInt(shapes.size()));
            center = shape.getCenter();
            x = center.x + shape.getXsize() * (this.random.nextDouble() - 0.5) * 1.5;
            y = center.y + shape.getYsize() * (this.random.nextDouble() - 0.5) * 1.5;
            z = center.z + shape.getZsize() * (this.random.nextDouble() - 0.5) * 1.5;
            Vec3 speed = this.getSpeedVector();
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, speed.x, speed.y, speed.z);
            if ((double)this.getHealth() < 0.5) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, x, y, z, speed.x, speed.y, speed.z);
            }
        }
        if (this.isUnderWater() && this.drowning < 200) {
            ++this.drowning;
            for (AABB shape : this.getShapes()) {
                center = shape.getCenter();
                x = center.x + shape.getXsize() * (this.random.nextDouble() - 0.5) * 1.5;
                y = center.y + shape.getYsize() * (this.random.nextDouble() - 0.5) * 1.5;
                z = center.z + shape.getZsize() * (this.random.nextDouble() - 0.5) * 1.5;
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void tickPilot() {
        Player player;
        for (Entity entity : this.getPassengers()) {
            Player player2;
            if (!(entity instanceof Player) || !(player2 = (Player)entity).isLocalPlayer()) continue;
            if (KeyBindings.down.isDown() && this.onGround() && this.getDeltaMovement().length() < 0.01) {
                player2.displayClientMessage((Component)Component.translatable((String)"mount.onboard", (Object[])new Object[]{KeyBindings.dismount.getTranslatedKeyMessage()}), true);
            }
            if (Main.debouncingGetter.is(Main.Key.DISMOUNT)) {
                if (this.onGround() || this.tickCount - this.lastTriedToExit < 20) {
                    NetworkHandler.sendToServer(new CommandMessage(CommandMessage.Key.DISMOUNT, this.getDeltaMovement()));
                    player2.setJumping(false);
                } else {
                    this.lastTriedToExit = this.tickCount;
                    player2.displayClientMessage((Component)Component.translatable((String)"immersive_aircraft.tried_dismount"), true);
                }
            }
            if (!Main.debouncingGetter.is(Main.Key.BOOST) || !this.canBoost()) continue;
            NetworkHandler.sendToServer(new CommandMessage(CommandMessage.Key.BOOST, this.getDeltaMovement()));
            Vec3 p = this.position();
            this.level().playLocalSound(p.x(), p.y(), p.z(), SoundEvents.FIREWORK_ROCKET_LAUNCH, SoundSource.NEUTRAL, 1.0f, 1.0f, true);
        }
        Entity pilot = (Entity)this.getPassengers().get(0);
        if (pilot instanceof Player && (player = (Player)pilot).isLocalPlayer()) {
            this.setInputs(VehicleEntity.getMovementMultiplier(KeyBindings.left.isDown(), KeyBindings.right.isDown()), VehicleEntity.getMovementMultiplier(KeyBindings.up.isDown(), KeyBindings.down.isDown()), VehicleEntity.getMovementMultiplier(this.useAirplaneControls() ? KeyBindings.push.isDown() : KeyBindings.forward.isDown(), this.useAirplaneControls() ? KeyBindings.pull.isDown() : KeyBindings.backward.isDown()));
        } else {
            this.setInputs(0.0f, 0.0f, 0.0f);
        }
    }

    private void handleClientSync() {
        if (this.isControlledByLocalInstance()) {
            this.interpolationSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedX = this.getX() + (this.x - this.getX()) / (double)this.interpolationSteps;
        double interpolatedY = this.getY() + (this.y - this.getY()) / (double)this.interpolationSteps;
        double interpolatedZ = this.getZ() + (this.z - this.getZ()) / (double)this.interpolationSteps;
        double interpolatedYaw = Mth.wrapDegrees((double)(this.serverYRot - (double)this.getYRot()));
        this.setYRot(this.getYRot() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.setXRot(this.getXRot() + (float)(this.serverXRot - (double)this.getXRot()) / (float)this.interpolationSteps);
        this.setPos(interpolatedX, interpolatedY, interpolatedZ);
        this.setRot(this.getYRot(), this.getXRot());
        --this.interpolationSteps;
    }

    protected abstract void updateVelocity();

    protected double getDefaultGravity() {
        return 0.04f * (CompatUtil.isModLoaded("ad_astra") ? GravityApi.API.getGravity(this.level(), BlockPos.containing((Position)this.getEyePosition())) : 1.0f);
    }

    protected abstract void updateController();

    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction positionUpdater) {
        int i;
        List<List<PositionDescriptor>> positions;
        if (!this.hasPassenger(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform();
        int size = this.getPassengers().size() - 1;
        if (size < (positions = this.getVehicleData().getPassengerPositions()).size() && (i = this.getPassengers().indexOf(passenger)) >= 0 && i < positions.get(size).size()) {
            PositionDescriptor positionDescriptor = positions.get(size).get(i);
            float x = positionDescriptor.x();
            float y = positionDescriptor.y();
            float z = positionDescriptor.z();
            Vec3 attachmentPoint = passenger.getVehicleAttachmentPoint((Entity)this);
            Vector4f worldPosition = this.transformPosition(transform, x -= (float)attachmentPoint.x, y -= (float)attachmentPoint.y, z -= (float)attachmentPoint.z);
            passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            if (this.adaptPlayerRotation) {
                passenger.setYRot(passenger.getYRot() + (this.getYRot() - this.yRotO));
                passenger.setYHeadRot(passenger.getYHeadRot() + (this.getYRot() - this.yRotO));
            }
            positionUpdater.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            this.copyEntityData(passenger);
            if (passenger instanceof Animal) {
                Animal animal = (Animal)passenger;
                if (size > 1) {
                    int angle = passenger.getId() % 2 == 0 ? 90 : 270;
                    passenger.setYBodyRot(animal.yBodyRot + (float)angle);
                    passenger.setYHeadRot(passenger.getYHeadRot() + (float)angle);
                }
            }
        }
    }

    protected Vec3 getDismountOffset(double vehicleWidth, double passengerWidth) {
        double offset = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float yaw = this.getYRot() + this.getDismountRotation();
        float x = -Mth.sin((float)(yaw * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(yaw * ((float)Math.PI / 180)));
        float n = Math.max(Math.abs(x), Math.abs(z));
        return new Vec3((double)x * offset / (double)n, 0.0, (double)z * offset / (double)n);
    }

    protected float getDismountRotation() {
        return 90.0f;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Vec3 vec3d = this.getDismountOffset(this.getBbWidth() * Mth.SQRT_OF_TWO, passenger.getBbWidth() * Mth.SQRT_OF_TWO);
        double ox = this.getX() + vec3d.x;
        double oz = this.getZ() + vec3d.z;
        BlockPos exitPos = new BlockPos((int)ox, (int)this.getY(), (int)oz);
        BlockPos floorPos = exitPos.below();
        if (!this.level().isWaterAt(floorPos)) {
            double floorHeight;
            ArrayList list = Lists.newArrayList();
            double exitHeight = this.level().getBlockFloorHeight(exitPos);
            if (DismountHelper.isBlockFloorValid((double)exitHeight)) {
                list.add(new Vec3(ox, (double)exitPos.getY() + exitHeight, oz));
            }
            if (DismountHelper.isBlockFloorValid((double)(floorHeight = this.level().getBlockFloorHeight(floorPos)))) {
                list.add(new Vec3(ox, (double)floorPos.getY() + floorHeight, oz));
            }
            for (Pose entityPose : passenger.getDismountPoses()) {
                for (Vec3 vec3d2 : list) {
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (Vec3)vec3d2, (LivingEntity)passenger, (Pose)entityPose)) continue;
                    passenger.setPose(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.getDismountLocationForPassenger(passenger);
    }

    public void copyEntityData(Entity entity) {
        entity.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
        float g = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        entity.yRotO += g - f;
        entity.setYRot(entity.getYRot() + g - f);
        entity.setYHeadRot(entity.getYRot());
    }

    public void onPassengerTurned(@NotNull Entity passenger) {
        this.copyEntityData(passenger);
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
        tag.putFloat("VehicleHealth", this.getHealth());
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
        if (tag.contains("VehicleHealth")) {
            this.setHealth(tag.getFloat("VehicleHealth"));
        }
    }

    public void addItemTag(ItemStack stack) {
        if (this.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
    }

    public void readItemTag(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            this.setCustomName((Component)stack.get(DataComponents.CUSTOM_NAME));
        }
    }

    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.getHealth() < 1.0f && (player.isShiftKeyDown() || !Config.getInstance().requireShiftForRepair) && !this.hasPassenger((Entity)player)) {
            if (!this.level().isClientSide) {
                player.causeFoodExhaustion(Config.getInstance().repairExhaustion);
                this.repair(Config.getInstance().repairSpeed);
                MutableComponent component = Component.translatable((String)"immersive_aircraft.repair", (Object[])new Object[]{(int)(this.getHealth() * 100.0f)});
                if ((double)this.getHealth() < 0.33) {
                    component.withStyle(ChatFormatting.RED);
                } else if ((double)this.getHealth() < 0.66) {
                    component.withStyle(ChatFormatting.GOLD);
                } else {
                    component.withStyle(ChatFormatting.GREEN);
                }
                player.displayClientMessage((Component)component, true);
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), Sounds.REPAIR.get(), SoundSource.NEUTRAL, 1.0f, 0.7f + this.random.nextFloat() * 0.2f);
            } else {
                for (AABB shape : this.getAdditionalShapes()) {
                    for (int i = 0; i < 5; ++i) {
                        Vec3 center = shape.getCenter();
                        double x = center.x + shape.getXsize() * (this.random.nextDouble() - 0.5) * 1.5;
                        double y = center.y + shape.getYsize() * (this.random.nextDouble() - 0.5) * 1.5;
                        double z = center.z + shape.getZsize() * (this.random.nextDouble() - 0.5) * 1.5;
                        this.level().addParticle((ParticleOptions)ParticleTypes.COMPOSTER, x, y, z, 0.0, this.random.nextDouble(), 0.0);
                    }
                }
            }
            return InteractionResult.CONSUME;
        }
        if (!this.isValidDimension()) {
            player.displayClientMessage((Component)Component.translatable((String)"immersive_aircraft.invalid_dimension"), true);
            return InteractionResult.FAIL;
        }
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide) {
            return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.hasPassenger((Entity)player)) {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public void move(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        Vec3 prediction = this.position().add(movement);
        super.move(movementType, movement);
        if ((this.verticalCollision || this.horizontalCollision) && this.level().isClientSide && Config.getInstance().collisionDamage) {
            float repeat;
            float collision;
            double maxPossibleError = movement.length();
            double error = prediction.distanceTo(this.position());
            if (error <= maxPossibleError && (collision = (float)(error - (this.verticalCollision ? Math.abs(this.getGravity()) : 0.0)) - 0.05f) > 0.0f && (repeat = 1.0f - (float)(this.getDamageWobbleTicks() + 1) / 10.0f) > 1.0E-4f) {
                float damage = collision * Config.getInstance().collisionDamageMultiplier * repeat * repeat;
                NetworkHandler.sendToServer(new CollisionMessage(damage));
            }
        }
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, @NotNull BlockState landedState, @NotNull BlockPos landedPosition) {
    }

    public void setDamageWobbleStrength(float wobbleStrength) {
        this.entityData.set(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(wobbleStrength));
    }

    public float getDamageWobbleStrength() {
        return ((Float)this.entityData.get(DAMAGE_WOBBLE_STRENGTH)).floatValue();
    }

    public void setDamageWobbleTicks(int wobbleTicks) {
        this.entityData.set(DAMAGE_WOBBLE_TICKS, (Object)wobbleTicks);
    }

    public int getDamageWobbleTicks() {
        return (Integer)this.entityData.get(DAMAGE_WOBBLE_TICKS);
    }

    public void setDamageWobbleSide(int side) {
        this.entityData.set(DAMAGE_WOBBLE_SIDE, (Object)side);
    }

    public int getDamageWobbleSide() {
        return (Integer)this.entityData.get(DAMAGE_WOBBLE_SIDE);
    }

    public float getHealth() {
        return ((Float)this.entityData.get(DATA_HEALTH)).floatValue();
    }

    public void setHealth(float damage) {
        this.entityData.set(DATA_HEALTH, (Object)Float.valueOf(damage));
    }

    protected boolean canAddPassenger(@NotNull Entity passenger) {
        return this.getPassengers().size() < this.getPassengerSpace() && !this.isEyeInFluid(FluidTags.WATER);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            return le;
        }
        return super.getControllingPassenger();
    }

    @Nullable
    public Entity getGunner(int offset) {
        List passengers = this.getPassengers();
        return passengers.isEmpty() ? null : (Entity)passengers.get(Math.max(0, passengers.size() - 1 - offset));
    }

    public void setInputs(float x, float y, float z) {
        this.movementX = x;
        this.movementY = y;
        this.movementZ = z;
    }

    public boolean canTurnOnEngine(Entity pilot) {
        return pilot instanceof Player;
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.asItem());
    }

    public boolean isWithinParticleRange() {
        return Main.cameraGetter.getPosition().distanceToSqr(this.position()) < 1024.0;
    }

    protected Vector4f transformPosition(Matrix4f transform, float x, float y, float z) {
        return transform.transform(new Vector4f(x, y, z, 1.0f));
    }

    protected Vector3f transformVector(float x, float y, float z) {
        return this.transformVector(this.getVehicleNormalTransform(), x, y, z);
    }

    protected Vector3f transformVectorQuantized(float x, float y, float z) {
        return this.transformVector(this.getVehicleNormalTransformQuantized(), x, y, z);
    }

    protected Vector3f transformVector(Matrix3f transform, float x, float y, float z) {
        return transform.transform(new Vector3f(x, y, z));
    }

    public Matrix4f getVehicleTransform() {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)this.getX(), (float)this.getY(), (float)this.getZ());
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-this.getYRot()));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees(this.getXRot()));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(this.getRoll()));
        return transform;
    }

    private float quantize(float value) {
        int floor = Mth.floor((float)(value * 256.0f / 360.0f));
        return (float)(floor * 360) / 256.0f;
    }

    public Matrix3f getVehicleNormalTransformQuantized() {
        Matrix3f transform = new Matrix3f();
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-this.quantize(this.getYRot())));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees(this.quantize(this.getXRot())));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(this.quantize(this.getRoll())));
        return transform;
    }

    public Matrix3f getVehicleNormalTransform() {
        Matrix3f transform = new Matrix3f();
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-this.getYRot()));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees(this.getXRot()));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(this.getRoll()));
        return transform;
    }

    public Vector3f getForwardDirection() {
        return this.transformVector(0.0f, 0.0f, 1.0f);
    }

    public Vector3f getRightDirection() {
        Vector3f f = this.transformVector(1.0f, 0.0f, 0.0f);
        return new Vector3f(f.x(), f.y(), f.z());
    }

    public Vector3f getTopDirection() {
        return this.transformVector(0.0f, 1.0f, 0.0f);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d = (double)Config.getInstance().renderDistance * VehicleEntity.getViewScale();
        return distance < d * d;
    }

    public void chill() {
    }

    public Vec3 toVec3d(Vector3f v) {
        return new Vec3((double)v.x, (double)v.y, (double)v.z);
    }

    public boolean isValidDimension() {
        return Config.getInstance().validDimensions.getOrDefault(this.level().dimension().location().toString(), true);
    }

    protected AABB getOffsetBoundingBox(BoundingBoxDescriptor descriptor) {
        Vector3f center = this.transformVectorQuantized(descriptor.x(), descriptor.y(), descriptor.z());
        return new AABB((double)center.x() - (double)descriptor.width() / 2.0 + this.getX(), (double)center.y() - (double)descriptor.height() / 2.0 + this.getY(), (double)center.z() - (double)descriptor.width() / 2.0 + this.getZ(), (double)center.x() + (double)descriptor.width() / 2.0 + this.getX(), (double)center.y() + (double)descriptor.height() / 2.0 + this.getY(), (double)center.z() + (double)descriptor.width() / 2.0 + this.getZ());
    }

    public List<AABB> getAdditionalShapes() {
        return this.getVehicleData().getBoundingBoxes().stream().map(this::getOffsetBoundingBox).toList();
    }

    public List<AABB> getShapes() {
        ArrayList<AABB> shapes = new ArrayList<AABB>(this.getAdditionalShapes());
        shapes.add(this.getBoundingBox());
        return shapes;
    }

    public Vec3 getSpeedVector() {
        return new Vec3((this.lastX - this.secondLastX) / 10.0, (this.lastY - this.secondLastY) / 10.0, (this.lastZ - this.secondLastZ) / 10.0);
    }

    public boolean isPilotCreative() {
        Player player;
        LivingEntity livingEntity = this.getControllingPassenger();
        return livingEntity instanceof Player && (player = (Player)livingEntity).isCreative();
    }

    public double getZoom() {
        return 0.0;
    }

    public AABB getBoundingBoxForCulling() {
        AABB box = super.getBoundingBoxForCulling();
        for (AABB additionalShape : this.getAdditionalShapes()) {
            box = box.minmax(additionalShape);
        }
        return box;
    }

    public void setAnimationVariables(float tickDelta) {
        BBAnimationVariables.set("pressing_interpolated_x", this.pressingInterpolatedX.getSmooth(tickDelta));
        BBAnimationVariables.set("pressing_interpolated_y", this.pressingInterpolatedY.getSmooth(tickDelta));
        BBAnimationVariables.set("pressing_interpolated_z", this.pressingInterpolatedZ.getSmooth(tickDelta));
        Vec3 speed = this.getSpeedVector();
        BBAnimationVariables.set("velocity_x", (float)speed.x);
        BBAnimationVariables.set("velocity_y", (float)speed.y);
        BBAnimationVariables.set("velocity_z", (float)speed.z);
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }
}

