/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import immersive_aircraft.client.render.entity.renderer.utils.ModelPartRenderHandler;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.resources.bbmodel.BBAnimation;
import immersive_aircraft.resources.bbmodel.BBAnimator;
import immersive_aircraft.resources.bbmodel.BBBone;
import immersive_aircraft.resources.bbmodel.BBFace;
import immersive_aircraft.resources.bbmodel.BBFaceContainer;
import immersive_aircraft.resources.bbmodel.BBMesh;
import immersive_aircraft.resources.bbmodel.BBModel;
import immersive_aircraft.resources.bbmodel.BBObject;
import immersive_aircraft.util.Utils;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BBModelRenderer {
    public static final VertexConsumerProvider DEFAULT_VERTEX_CONSUMER_PROVIDER = (source, container, face) -> source.getBuffer(container.enableCulling() ? RenderType.entityCutout((ResourceLocation)face.texture.location) : RenderType.entityCutoutNoCull((ResourceLocation)face.texture.location));

    public static <T extends VehicleEntity> void renderModel(BBModel model, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float time, T entity, ModelPartRenderHandler<T> modelPartRenderer, float red, float green, float blue, float alpha) {
        model.root.forEach(object -> BBModelRenderer.renderObject(model, object, matrixStack, vertexConsumerProvider, light, time, entity, modelPartRenderer, red, green, blue, alpha));
    }

    public static <T extends VehicleEntity> void renderObject(BBModel model, BBObject object, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float time, T entity, ModelPartRenderHandler<T> modelPartRenderer, float red, float green, float blue, float alpha) {
        BBAnimation animation;
        matrixStack.pushPose();
        matrixStack.translate(object.origin.x(), object.origin.y(), object.origin.z());
        if (!model.animations.isEmpty() && (animation = model.animations.get(0)).hasAnimator(object.uuid)) {
            Vector3f position = animation.sample(object.uuid, BBAnimator.Channel.POSITION, time);
            position.mul(0.0625f);
            matrixStack.translate(position.x(), position.y(), position.z());
            Vector3f rotation = animation.sample(object.uuid, BBAnimator.Channel.ROTATION, time);
            rotation.mul(0.017453294f);
            matrixStack.mulPose(Utils.fromXYZ(rotation));
            Vector3f scale = animation.sample(object.uuid, BBAnimator.Channel.SCALE, time);
            matrixStack.scale(scale.x(), scale.y(), scale.z());
        }
        matrixStack.mulPose(Utils.fromXYZ(object.rotation));
        if (object instanceof BBBone) {
            BBBone bone = (BBBone)object;
            if (modelPartRenderer != null) {
                modelPartRenderer.animate(bone.name, entity, matrixStack, time);
            }
        }
        if (object instanceof BBBone) {
            matrixStack.translate(-object.origin.x(), -object.origin.y(), -object.origin.z());
        }
        if (modelPartRenderer == null || !modelPartRenderer.render(object.name, model, object, vertexConsumerProvider, entity, matrixStack, light, time, modelPartRenderer)) {
            BBModelRenderer.renderObjectInner(model, object, matrixStack, vertexConsumerProvider, light, time, entity, modelPartRenderer, red, green, blue, alpha);
        }
        matrixStack.popPose();
    }

    public static <T extends VehicleEntity> void renderObjectInner(BBModel model, BBObject object, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float time, T entity, ModelPartRenderHandler<T> modelPartRenderer, float red, float green, float blue, float alpha) {
        if (object instanceof BBFaceContainer) {
            BBFaceContainer cube = (BBFaceContainer)((Object)object);
            BBModelRenderer.renderFaces(cube, matrixStack, vertexConsumerProvider, light, red, green, blue, alpha, modelPartRenderer == null ? DEFAULT_VERTEX_CONSUMER_PROVIDER : modelPartRenderer.getVertexConsumerProvider());
        } else if (object instanceof BBBone) {
            BBBone bone = (BBBone)object;
            boolean shouldRender = bone.visibility;
            if (bone.name.equals("lod0")) {
                shouldRender = entity.isWithinParticleRange();
            } else if (bone.name.equals("lod1")) {
                boolean bl = shouldRender = !entity.isWithinParticleRange();
            }
            if (shouldRender) {
                bone.children.forEach(child -> BBModelRenderer.renderObject(model, child, matrixStack, vertexConsumerProvider, light, time, entity, modelPartRenderer, red, green, blue, alpha));
            }
        }
    }

    public static void renderFaces(BBFaceContainer cube, PoseStack matrixStack, MultiBufferSource source, int light, float red, float green, float blue, float alpha, VertexConsumerProvider provider) {
        PoseStack.Pose last = matrixStack.last();
        Matrix4f positionMatrix = last.pose();
        Matrix3f normalMatrix = last.normal();
        for (BBFace face : cube.getFaces()) {
            VertexConsumer vertexConsumer = provider.getBuffer(source, cube, face);
            for (int i = 0; i < 4; ++i) {
                BBFace.BBVertex v = face.vertices[i];
                Vector3f p = positionMatrix.transformPosition(v.x, v.y, v.z, new Vector3f());
                Vector3f n = normalMatrix.transform(v.nx, v.ny, v.nz, new Vector3f());
                int color = FastColor.ARGB32.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue);
                vertexConsumer.addVertex(p.x, p.y, p.z, color, v.u, v.v, OverlayTexture.NO_OVERLAY, light, n.x, n.y, n.z);
            }
        }
    }

    public static void renderBanner(BBFaceContainer cube, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light, boolean isBanner, DyeColor baseColor, List<BannerPatternLayers.Layer> patterns) {
        matrixStack.pushPose();
        if (cube instanceof BBObject) {
            BBObject object = (BBObject)((Object)cube);
            matrixStack.translate(object.origin.x(), object.origin.y(), object.origin.z());
        }
        Material baseMaterial = isBanner ? Sheets.BANNER_BASE : Sheets.SHIELD_BASE;
        BBModelRenderer.renderBannerMaterial(cube, matrixStack, vertexConsumers, light, baseColor, baseMaterial);
        for (BannerPatternLayers.Layer pattern : patterns) {
            Material material = isBanner ? Sheets.getBannerMaterial((Holder)pattern.pattern()) : Sheets.getShieldMaterial((Holder)pattern.pattern());
            BBModelRenderer.renderBannerMaterial(cube, matrixStack, vertexConsumers, light, pattern.color(), material);
        }
        matrixStack.popPose();
    }

    private static void renderBannerMaterial(BBFaceContainer cube, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light, DyeColor color, Material material) {
        int fs = color.getTextureDiffuseColor();
        float r = (float)(fs >> 16 & 0xFF) / 255.0f;
        float g = (float)(fs >> 8 & 0xFF) / 255.0f;
        float b = (float)(fs & 0xFF) / 255.0f;
        BBModelRenderer.renderFaces(cube, matrixStack, vertexConsumers, light, r, g, b, 1.0f, (source, container, face) -> material.buffer(vertexConsumers, RenderType::entityNoOutline));
    }

    public static void renderSailObject(BBMesh cube, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float time, float red, float green, float blue, float alpha) {
        BBModelRenderer.renderSailObject(cube, matrixStack, vertexConsumerProvider, light, time, red, green, blue, alpha, 0.025f, 0.0f);
    }

    public static void renderSailObject(BBMesh cube, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float time, float red, float green, float blue, float alpha, float distanceScale, float baseScale) {
        PoseStack.Pose last = matrixStack.last();
        Matrix4f positionMatrix = last.pose();
        Matrix3f normalMatrix = last.normal();
        for (BBFace face : cube.getFaces()) {
            VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)face.texture.location));
            for (int i = 0; i < 4; ++i) {
                BBFace.BBVertex v = face.vertices[i];
                float distance = Math.max(Math.max(Math.abs(v.x), Math.abs(v.y)), Math.abs(v.z));
                double angle = ((double)(v.x + v.z) + (double)v.y * 0.25) * 4.0 + (double)(time * 4.0f);
                double scale = distanceScale * distance + baseScale;
                float x = (float)((Math.cos(angle) + Math.cos(angle * 1.7)) * scale);
                float z = (float)((Math.sin(angle) + Math.sin(angle * 1.7)) * scale);
                Vector3f n = normalMatrix.transform(v.nx, v.ny, v.nz, new Vector3f());
                vertexConsumer.addVertex(positionMatrix, v.x + x, v.y, v.z + z).setColor(red, green, blue, alpha).setUv(v.u, v.v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(n.x, n.y, n.z);
            }
        }
    }

    public static interface VertexConsumerProvider {
        public VertexConsumer getBuffer(MultiBufferSource var1, BBFaceContainer var2, BBFace var3);
    }
}

