/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.items;

import com.github.talrey.createdeco.blocks.CatwalkBlock;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class CatwalkBlockItem
extends BlockItem {
    private final int placementHelperID = PlacementHelpers.register((IPlacementHelper)new CatwalkHelper());

    public CatwalkBlockItem(CatwalkBlock block, Item.Properties props) {
        super((Block)block, props);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        Direction face = ctx.getClickedFace();
        Level world = ctx.getLevel();
        Player player = ctx.getPlayer();
        BlockState state = world.getBlockState(pos);
        IPlacementHelper helper = PlacementHelpers.get((int)this.placementHelperID);
        BlockHitResult ray = new BlockHitResult(ctx.getClickLocation(), face, pos, true);
        if (helper.matchesState(state) && player != null) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)this, player, ctx.getHand(), ray).result();
        }
        return super.useOn(ctx);
    }

    @MethodsReturnNonnullByDefault
    public static class CatwalkHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return CatwalkBlock::isCatwalk;
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> CatwalkBlock.isCatwalk(state.getBlock());
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction face = ray.getDirection();
            if (face.getAxis() != Direction.Axis.Y) {
                return PlacementOffset.success((Vec3i)pos.offset(face.getNormal()), offsetState -> offsetState);
            }
            List dirs = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)Direction.Axis.Y);
            for (Direction dir : dirs) {
                BlockPos newPos = pos.relative(dir);
                if (!CatwalkBlock.canPlaceCatwalk(world, newPos)) continue;
                return PlacementOffset.success((Vec3i)newPos, offsetState -> offsetState);
            }
            return PlacementOffset.fail();
        }
    }
}

