/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.register.helpers.list_providers;

import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.lopyluna.dndecor.register.helpers.list_providers.MaterialTypeProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class StoneTypeBlockList<T extends Block>
implements Iterable<BlockEntry<T>> {
    private final BlockEntry<?>[] values;

    public StoneTypeBlockList(BiFunction<NonNullSupplier<Block>, String, BlockEntry<? extends T>> filler) {
        MaterialTypeProvider.checkStoneTypeList();
        this.values = new BlockEntry[MaterialTypeProvider.stoneTypes.size()];
        for (NonNullSupplier<Block> type : MaterialTypeProvider.stoneTypes) {
            int index = MaterialTypeProvider.stoneTypes.indexOf(type);
            String id = MaterialTypeProvider.stoneTypesRegister.get(type);
            if (index < 0) continue;
            this.values[index] = filler.apply(type, id);
        }
    }

    public BlockEntry<T> get(Block block) {
        NonNullSupplier type = () -> block;
        int index = MaterialTypeProvider.stoneTypes.indexOf(type);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public BlockEntry<T> get(NonNullSupplier<Block> type) {
        int index = MaterialTypeProvider.stoneTypes.indexOf(type);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public boolean contains(Block block) {
        for (BlockEntry<?> entry : this.values) {
            if (!entry.is((Object)block)) continue;
            return true;
        }
        return false;
    }

    public BlockEntry<T>[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    @NotNull
    public Iterator<BlockEntry<T>> iterator() {
        return new Iterator<BlockEntry<T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < StoneTypeBlockList.this.values.length;
            }

            @Override
            public BlockEntry<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StoneTypeBlockList.this.values[this.index++];
            }
        };
    }
}

