/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.datagen;

import com.mrbysco.structurecompass.registry.StructureItems;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CompassDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new CompassRecipeProvider(packOutput, lookupProvider));
            CompassBlockTagProvider blockTags = new CompassBlockTagProvider(packOutput, lookupProvider, helper);
            generator.addProvider(event.includeServer(), (DataProvider)blockTags);
            generator.addProvider(event.includeServer(), (DataProvider)new CompassItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)blockTags, helper));
        }
    }

    public static class CompassRecipeProvider
    extends RecipeProvider {
        public CompassRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, lookupProvider);
        }

        protected void buildRecipes(RecipeOutput recipeOutput) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)StructureItems.STRUCTURE_COMPASS.get())).pattern("WTS").pattern("O#D").pattern("MCP").define(Character.valueOf('#'), (ItemLike)Items.COMPASS).define(Character.valueOf('W'), (ItemLike)Blocks.SNOW_BLOCK).define(Character.valueOf('T'), (ItemLike)Blocks.TERRACOTTA).define(Character.valueOf('S'), (ItemLike)Blocks.SANDSTONE).define(Character.valueOf('O'), (ItemLike)Blocks.OAK_LOG).define(Character.valueOf('D'), (ItemLike)Blocks.DARK_OAK_LOG).define(Character.valueOf('M'), (ItemLike)Blocks.MOSSY_COBBLESTONE).define(Character.valueOf('C'), (ItemLike)Blocks.COBBLESTONE).define(Character.valueOf('P'), (ItemLike)Blocks.CARVED_PUMPKIN).unlockedBy("has_compass", CompassRecipeProvider.has((ItemLike)Items.COMPASS)).save(recipeOutput);
        }
    }

    public static class CompassBlockTagProvider
    extends BlockTagsProvider {
        public CompassBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "structurecompass", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
        }
    }

    public static class CompassItemTagProvider
    extends ItemTagsProvider {
        public CompassItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, TagsProvider<Block> blockTagProvider, ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, blockTagProvider.contentsGetter(), "structurecompass", existingFileHelper);
        }

        public void addTags(HolderLookup.Provider lookupProvider) {
            this.tag(ItemTags.COMPASSES).add((Object)((Item)StructureItems.STRUCTURE_COMPASS.get()));
        }
    }
}

