/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.util.texture;

import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.SpriteTicker;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class SpriteTexture
extends AbstractTexture
implements Tickable {
    private final ResourceLocation resourceLocation;
    private SpriteContents sprite;
    private SpriteTicker ticker;

    public SpriteTexture(OutOfJarResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public void load(ResourceManager resourceManager) throws IOException {
        this.close();
        if (!OutOfJarResourceLocation.fileExists(this.resourceLocation, resourceManager)) {
            throw new FileNotFoundException(this.resourceLocation.toString());
        }
        Resource resource = OutOfJarResourceLocation.getResourceHandle(this.resourceLocation, resourceManager);
        this.sprite = SpriteResourceLoader.create((Collection)SpriteLoader.DEFAULT_METADATA_SECTIONS).loadSprite(this.resourceLocation, resource);
        this.ticker = this.sprite.createTicker();
        TextureUtil.prepareImage((int)this.getId(), (int)0, (int)this.sprite.width(), (int)this.sprite.height());
        this.sprite.uploadFirstFrame(0, 0);
    }

    public void tick() {
        if (this.ticker != null) {
            this.bind();
            this.ticker.tickAndUpload(0, 0);
        }
    }

    public void close() {
        if (this.sprite != null) {
            this.sprite.close();
        }
        if (this.ticker != null) {
            this.ticker.close();
        }
    }
}

