/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.InputHandler;
import com.ldtteam.blockui.util.cursor.Cursor;
import com.ldtteam.blockui.views.View;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class TextField
extends Pane {
    protected InputHandler handler;
    private static final int RECT_COLOR = -3092272;
    private static final int DEFAULT_MAX_TEXT_LENGTH = 32;
    protected int maxTextLength = 32;
    protected int textColor = 0xE0E0E0;
    protected int textColorDisabled = 0x707070;
    protected boolean shadow = true;
    @Nullable
    protected String tabNextPaneID = null;
    protected String text = "";
    protected Filter filter;
    protected int cursorPosition = 0;
    protected int scrollOffset = 0;
    protected int selectionEnd = 0;
    protected int cursorBlinkCounter = 0;

    public TextField() {
        this.cursor = Cursor.TEXT_CURSOR;
    }

    public TextField(PaneParams params) {
        super(params);
        this.maxTextLength = params.getInteger("maxlength", this.maxTextLength);
        this.textColor = params.getColor("color", this.textColor);
        this.textColorDisabled = params.getColor("colordisabled", this.textColorDisabled);
        this.shadow = params.getBoolean("shadow", this.shadow);
        this.text = params.getString("textContent", this.text);
        this.tabNextPaneID = params.getString("tab");
        this.cursor = this.cursor == Cursor.DEFAULT ? Cursor.TEXT_CURSOR : this.cursor;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter f) {
        this.filter = f;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String s) {
        this.text = s.length() <= this.maxTextLength ? s : s.substring(0, this.maxTextLength);
        this.setCursorPosition(this.text.length());
    }

    public void setTextIgnoreLength(String s) {
        this.text = s;
        this.setCursorPosition(this.text.length());
    }

    public int getInternalWidth() {
        return this.getWidth();
    }

    public int getMaxTextLength() {
        return this.maxTextLength;
    }

    public void setMaxTextLength(int m) {
        this.maxTextLength = m;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int c) {
        this.textColor = c;
    }

    public int getTextColorDisabled() {
        return this.textColorDisabled;
    }

    public void setTextColorDisabled(int c) {
        this.textColorDisabled = c;
    }

    @Nullable
    public String getTabNextPaneID() {
        return this.tabNextPaneID;
    }

    public void setTabNextPaneID(String nextID) {
        this.tabNextPaneID = nextID;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = Mth.clamp((int)pos, (int)0, (int)this.text.length());
        this.setSelectionEnd(this.cursorPosition);
    }

    public void moveCursorBy(int offset) {
        this.setCursorPosition(this.selectionEnd + offset);
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public void setSelectionEnd(int pos) {
        this.selectionEnd = Mth.clamp((int)pos, (int)0, (int)this.text.length());
        int internalWidth = this.getInternalWidth();
        if (internalWidth > 0) {
            if (this.scrollOffset > this.text.length()) {
                this.scrollOffset = this.text.length();
            }
            String visibleString = this.mc.font.plainSubstrByWidth(this.text.substring(this.scrollOffset), internalWidth);
            int rightmostVisibleChar = visibleString.length() + this.scrollOffset;
            if (this.selectionEnd == this.scrollOffset) {
                this.scrollOffset -= this.mc.font.plainSubstrByWidth(this.text, internalWidth, true).length();
            }
            if (this.selectionEnd > rightmostVisibleChar) {
                this.scrollOffset += this.selectionEnd - rightmostVisibleChar;
            } else if (this.selectionEnd <= this.scrollOffset) {
                this.scrollOffset -= this.scrollOffset - this.selectionEnd;
            }
            this.scrollOffset = Mth.clamp((int)this.scrollOffset, (int)0, (int)this.text.length());
        }
    }

    public String getSelectedText() {
        int start = Math.min(this.cursorPosition, this.selectionEnd);
        int end = Math.max(this.cursorPosition, this.selectionEnd);
        return this.text.substring(start, end);
    }

    private boolean handleKey(char c, int key) {
        switch (key) {
            case 259: 
            case 261: {
                return this.handleDelete(key);
            }
            case 268: 
            case 269: {
                return this.handleHomeEnd(key);
            }
            case 262: 
            case 263: {
                return this.handleArrowKeys(key);
            }
            case 258: {
                return this.handleTab();
            }
            case 256: {
                if (this.selectionEnd == this.cursorPosition) break;
                this.setSelectionEnd(this.cursorPosition);
                return true;
            }
        }
        return this.handleChar(c);
    }

    private boolean handleChar(char c) {
        if (this.filter.isAllowedCharacter(c)) {
            this.writeText(Character.toString(c));
            return true;
        }
        return false;
    }

    private boolean handleTab() {
        Pane next;
        if (this.tabNextPaneID != null && (next = this.getWindow().findPaneByID(this.tabNextPaneID)) != null) {
            next.setFocus();
        }
        return true;
    }

    private boolean handleArrowKeys(int key) {
        int direction;
        int n = direction = key == 263 ? -1 : 1;
        if (Screen.hasShiftDown()) {
            if (Screen.hasControlDown()) {
                this.setSelectionEnd(this.getNthWordFromPos(direction, this.getSelectionEnd()));
            } else {
                this.setSelectionEnd(this.getSelectionEnd() + direction);
            }
        } else if (Screen.hasControlDown()) {
            this.setCursorPosition(this.getNthWordFromCursor(direction));
        } else {
            this.moveCursorBy(direction);
        }
        return true;
    }

    private boolean handleHomeEnd(int key) {
        int position;
        int n = position = key == 268 ? 0 : this.text.length();
        if (Screen.hasShiftDown()) {
            this.setSelectionEnd(position);
        } else {
            this.setCursorPosition(position);
        }
        return true;
    }

    private boolean handleDelete(int key) {
        int direction;
        int n = direction = key == 259 ? -1 : 1;
        if (Screen.hasControlDown()) {
            this.deleteWords(direction);
        } else {
            this.deleteFromCursor(direction);
        }
        return true;
    }

    @Override
    public void onFocus() {
        this.setCursorPosition(this.text.length());
        this.cursorBlinkCounter = 0;
    }

    @Override
    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        boolean cursorBeforeEnd;
        int color = this.isEnabled() ? this.textColor : this.textColorDisabled;
        int drawWidth = this.getInternalWidth();
        int drawX = this.x;
        int drawY = this.y;
        String visibleString = this.mc.font.plainSubstrByWidth(this.text.substring(this.scrollOffset), drawWidth);
        int relativeCursorPosition = this.cursorPosition - this.scrollOffset;
        int relativeSelectionEnd = this.selectionEnd - this.scrollOffset;
        boolean cursorVisible = relativeCursorPosition >= 0 && relativeCursorPosition <= visibleString.length();
        boolean bl = cursorBeforeEnd = this.cursorPosition < this.text.length() || this.text.length() >= this.maxTextLength;
        if (relativeSelectionEnd > visibleString.length()) {
            relativeSelectionEnd = visibleString.length();
        }
        int textX = drawX;
        if (visibleString.length() > 0) {
            String s1 = cursorVisible ? visibleString.substring(0, relativeCursorPosition) : visibleString;
            textX = target.drawString(s1, textX, drawY, color, this.shadow);
        }
        int cursorX = textX--;
        if (!cursorVisible) {
            cursorX = relativeCursorPosition > 0 ? drawX + this.width : drawX;
        } else if (cursorBeforeEnd && this.shadow) {
            --cursorX;
        }
        if (visibleString.length() > 0 && cursorVisible && relativeCursorPosition < visibleString.length()) {
            target.drawString(visibleString.substring(relativeCursorPosition), textX, drawY, color, this.shadow);
        }
        if (this.isFocus() && cursorVisible && this.cursorBlinkCounter / 6 % 2 == 0) {
            if (cursorBeforeEnd) {
                PoseStack poseStack = target.pose();
                Objects.requireNonNull(this.mc.font);
                TextField.fill(poseStack, cursorX, drawY - 1, 1, 1 + 9, -3092272);
            } else {
                target.drawString("_", cursorX, drawY, color, this.shadow);
            }
        }
        if (relativeSelectionEnd != relativeCursorPosition) {
            int selectedDrawX = drawX + this.mc.font.width(visibleString.substring(0, relativeSelectionEnd));
            int selectionStartX = Math.min(cursorX, selectedDrawX - 1);
            int selectionEndX = Math.max(cursorX, selectedDrawX - 1);
            if (selectionStartX > this.x + this.width) {
                selectionStartX = this.x + this.width;
            }
            if (selectionEndX > this.x + this.width) {
                selectionEndX = this.x + this.width;
            }
            Matrix4f m = target.pose().last().pose();
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableColorLogicOp();
            RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
            RenderSystem.setShader(GameRenderer::getPositionShader);
            BufferBuilder vertexBuffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
            vertexBuffer.addVertex(m, (float)selectionStartX, (float)(drawY - 1), 0.0f);
            float f = selectionStartX;
            Objects.requireNonNull(this.mc.font);
            vertexBuffer.addVertex(m, f, (float)(drawY + 1 + 9), 0.0f);
            float f2 = selectionEndX;
            Objects.requireNonNull(this.mc.font);
            vertexBuffer.addVertex(m, f2, (float)(drawY + 1 + 9), 0.0f);
            vertexBuffer.addVertex(m, (float)selectionEndX, (float)(drawY - 1), 0.0f);
            BufferUploader.drawWithShader((MeshData)vertexBuffer.build());
            RenderSystem.disableColorLogicOp();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void putInside(View view) {
        super.putInside(view);
        this.setSelectionEnd(this.selectionEnd);
    }

    @Override
    public boolean handleClick(double mx, double my) {
        if (mx < 0.0) {
            return false;
        }
        String visibleString = this.mc.font.plainSubstrByWidth(this.text.substring(this.scrollOffset), this.getInternalWidth());
        String trimmedString = this.mc.font.plainSubstrByWidth(visibleString, (int)mx);
        int oldScrollOffset = this.scrollOffset;
        this.setFocus();
        this.scrollOffset = oldScrollOffset;
        this.setCursorPosition(trimmedString.length() + this.scrollOffset);
        return true;
    }

    @Override
    public boolean onKeyTyped(char c, int key) {
        if (Screen.isCopy((int)key)) {
            this.mc.keyboardHandler.setClipboard(this.getSelectedText());
            return true;
        }
        if (Screen.isCut((int)key)) {
            this.mc.keyboardHandler.setClipboard(this.getSelectedText());
            this.writeText("");
            return true;
        }
        if (Screen.isSelectAll((int)key)) {
            this.setCursorPosition(this.text.length());
            this.setSelectionEnd(0);
            return true;
        }
        if (Screen.isPaste((int)key)) {
            this.writeText(this.mc.keyboardHandler.getClipboard());
            return true;
        }
        return this.handleKey(c, key);
    }

    @Override
    public void onUpdate() {
        ++this.cursorBlinkCounter;
    }

    public void writeText(String str) {
        int insertedLength;
        String filteredStr = this.filter.filter(str);
        int insertAt = Math.min(this.cursorPosition, this.selectionEnd);
        int insertEnd = Math.max(this.cursorPosition, this.selectionEnd);
        int availableChars = this.maxTextLength - this.text.length() + (insertEnd - insertAt);
        if (availableChars < 0) {
            return;
        }
        StringBuilder resultBuffer = new StringBuilder();
        if (this.text.length() > 0 && insertAt > 0) {
            resultBuffer.append(this.text.substring(0, insertAt));
        }
        if (availableChars < filteredStr.length()) {
            resultBuffer.append(filteredStr.substring(0, availableChars));
            insertedLength = availableChars;
        } else {
            resultBuffer.append(filteredStr);
            insertedLength = filteredStr.length();
        }
        if (this.text.length() > 0 && insertEnd < this.text.length()) {
            resultBuffer.append(this.text.substring(insertEnd));
        }
        this.text = resultBuffer.toString();
        this.moveCursorBy(insertAt - this.selectionEnd + insertedLength);
        this.triggerHandler();
    }

    private void triggerHandler() {
        InputHandler delegatedHandler = this.handler;
        if (delegatedHandler == null && this.getWindow() instanceof InputHandler) {
            delegatedHandler = (InputHandler)((Object)this.getWindow());
        }
        if (delegatedHandler != null) {
            delegatedHandler.onInput(this);
        }
    }

    public void deleteWords(int count) {
        if (this.text.length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(count) - this.cursorPosition);
            }
        }
    }

    public void setHandler(InputHandler h) {
        this.handler = h;
    }

    public void deleteFromCursor(int count) {
        if (this.text.length() == 0) {
            return;
        }
        if (this.selectionEnd != this.cursorPosition) {
            this.writeText("");
        } else {
            boolean backwards = count < 0;
            int start = backwards ? this.cursorPosition + count : this.cursorPosition;
            int end = backwards ? this.cursorPosition : this.cursorPosition + count;
            Object result = "";
            if (start > 0) {
                result = this.text.substring(0, start);
            }
            if (end < this.text.length()) {
                result = (String)result + this.text.substring(end);
            }
            this.text = result;
            if (backwards) {
                this.moveCursorBy(count);
            }
        }
        this.triggerHandler();
    }

    public int getNthWordFromPos(int count, int pos) {
        boolean reverse = count < 0;
        int position = pos;
        for (int i1 = 0; i1 < Math.abs(count); ++i1) {
            if (reverse) {
                while (position > 0 && this.text.charAt(position - 1) == ' ') {
                    --position;
                }
                while (position > 0 && this.text.charAt(position - 1) != ' ') {
                    --position;
                }
                continue;
            }
            if ((position = this.text.indexOf(32, position)) == -1) {
                position = this.text.length();
                continue;
            }
            while (position < this.text.length() && this.text.charAt(position) == ' ') {
                ++position;
            }
        }
        return position;
    }

    public int getNthWordFromCursor(int count) {
        return this.getNthWordFromPos(count, this.cursorPosition);
    }

    public static interface Filter {
        public String filter(String var1);

        public boolean isAllowedCharacter(char var1);
    }
}

