/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees.manager;

import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import bl4ckscor3.mod.snowundertrees.manager.SnowManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class VanillaManager
implements SnowManager {
    @Override
    public boolean placeSnow(WorldGenLevel level, BlockPos pos) {
        int accumulationHeight;
        if (level instanceof Level) {
            Level l = (Level)level;
            v0 = l.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT);
        } else {
            v0 = accumulationHeight = 1;
        }
        if (accumulationHeight > 0 && SnowUnderTrees.canSnow(level, pos)) {
            BlockState state = level.getBlockState(pos);
            if (state.is(Blocks.SNOW)) {
                int currentLayers = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
                if (currentLayers < Math.min(accumulationHeight, 8)) {
                    BlockState snowLayers = (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(currentLayers + 1));
                    Block.pushEntitiesUp((BlockState)state, (BlockState)snowLayers, (LevelAccessor)level, (BlockPos)pos);
                    level.setBlock(pos, snowLayers, 2);
                    return true;
                }
            } else {
                if (state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
                    level.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 2);
                }
                level.setBlock(pos, Blocks.SNOW.defaultBlockState(), 2);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSnow(WorldGenLevel level, BlockPos pos) {
        return level.getBlockState(pos).getBlock() == Blocks.SNOW;
    }

    @Override
    public BlockState getStateAfterMelting(BlockState stateNow, WorldGenLevel level, BlockPos pos) {
        return Blocks.AIR.defaultBlockState();
    }
}

