/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.data.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import mod.chiselsandbits.registrars.ModRecipeSerializers;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="chiselsandbits", bus=EventBusSubscriber.Bus.MOD)
public class SpecialCraftingRecipeGenerator
implements DataProvider {
    private final PackOutput generator;

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().addProvider(true, (DataProvider)new SpecialCraftingRecipeGenerator(event.getGenerator().getPackOutput()));
    }

    private SpecialCraftingRecipeGenerator(PackOutput generator) {
        this.generator = generator;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        this.saveRecipe(cache, ModRecipeSerializers.BAG_DYEING.getId());
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    private void saveRecipe(CachedOutput cache, ResourceLocation location) {
        JsonObject object = new JsonObject();
        object.addProperty("type", location.toString());
        Path recipeFolder = this.generator.getOutputFolder().resolve("data/chiselsandbits/recipes/");
        Path recipePath = recipeFolder.resolve(location.getPath() + ".json");
        DataProvider.saveStable((CachedOutput)cache, (JsonElement)object, (Path)recipePath);
    }

    @NotNull
    public String getName() {
        return "Special crafting recipe generator";
    }
}

