/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.data.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import mod.chiselsandbits.forge.data.recipe.AbstractRecipeGenerator;
import mod.chiselsandbits.forge.utils.CollectorUtils;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.registrars.ModTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="chiselsandbits", bus=EventBusSubscriber.Bus.MOD)
public class SimpleItemsRecipeGenerator
extends AbstractRecipeGenerator {
    private final boolean shapeless;
    private final List<String> pattern;
    private final Map<Character, TagKey<Item>> tagMap;
    private final Map<Character, ItemLike> itemMap;

    public SimpleItemsRecipeGenerator(PackOutput generator, ItemLike itemProvider, String pattern, Map<Character, TagKey<Item>> tagMap, Map<Character, ItemLike> itemMap, CompletableFuture<HolderLookup.Provider> registries) {
        super(generator, itemProvider, registries);
        this.shapeless = false;
        this.pattern = Arrays.asList(pattern.split(";"));
        this.tagMap = tagMap;
        this.itemMap = itemMap;
    }

    public SimpleItemsRecipeGenerator(PackOutput generator, ItemLike itemProvider, List<TagKey<Item>> tagMap, List<ItemLike> itemMap, CompletableFuture<HolderLookup.Provider> registries) {
        super(generator, itemProvider, registries);
        this.shapeless = true;
        this.pattern = ImmutableList.of((Object)"   ", (Object)"   ", (Object)"   ");
        this.tagMap = tagMap.stream().collect(CollectorUtils.toEnumeratedCharacterKeyedMap());
        this.itemMap = itemMap.stream().collect(CollectorUtils.toEnumeratedCharacterKeyedMap());
    }

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().addProvider(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator().getPackOutput(), (ItemLike)ModItems.ITEM_BIT_BAG_DEFAULT.get(), "www;wbw;www", (Map<Character, TagKey<Item>>)ImmutableMap.of((Object)Character.valueOf('w'), (Object)ItemTags.WOOL), (Map<Character, ItemLike>)ImmutableMap.of((Object)Character.valueOf('b'), (Object)((ItemLike)ModItems.ITEM_BLOCK_BIT.get())), event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator().getPackOutput(), (ItemLike)ModItems.MAGNIFYING_GLASS.get(), "cg ;s  ;   ", (Map<Character, TagKey<Item>>)ImmutableMap.of((Object)Character.valueOf('c'), (Object)ModTags.Items.CHISEL, (Object)Character.valueOf('g'), (Object)Tags.Items.GLASS_BLOCKS, (Object)Character.valueOf('s'), (Object)Tags.Items.RODS_WOODEN), (Map<Character, ItemLike>)ImmutableMap.of(), event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator().getPackOutput(), (ItemLike)ModItems.MEASURING_TAPE.get(), "  s;isy;ii ", (Map<Character, TagKey<Item>>)ImmutableMap.of((Object)Character.valueOf('i'), (Object)Tags.Items.INGOTS_IRON, (Object)Character.valueOf('s'), (Object)Tags.Items.STRINGS, (Object)Character.valueOf('y'), (Object)Tags.Items.DYES_YELLOW), (Map<Character, ItemLike>)ImmutableMap.of(), event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator().getPackOutput(), (ItemLike)ModItems.QUILL.get(), (List<TagKey<Item>>)ImmutableList.of((Object)Tags.Items.FEATHERS, (Object)Tags.Items.DYES_BLACK, (Object)Tags.Items.DYES_YELLOW), (List<ItemLike>)ImmutableList.of(), event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator().getPackOutput(), (ItemLike)ModItems.SEALANT_ITEM.get(), (List<TagKey<Item>>)ImmutableList.of((Object)Tags.Items.SLIMEBALLS), (List<ItemLike>)ImmutableList.of((Object)Items.HONEY_BOTTLE), event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator().getPackOutput(), (ItemLike)ModItems.WRENCH.get(), " pb; pp;p  ", (Map<Character, TagKey<Item>>)ImmutableMap.of((Object)Character.valueOf('p'), (Object)ItemTags.PLANKS), (Map<Character, ItemLike>)ImmutableMap.of((Object)Character.valueOf('b'), (Object)((ItemLike)ModItems.ITEM_BLOCK_BIT.get())), event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new SimpleItemsRecipeGenerator(event.getGenerator().getPackOutput(), (ItemLike)ModItems.UNSEAL_ITEM.get(), (List<TagKey<Item>>)ImmutableList.of(), (List<ItemLike>)ImmutableList.of((Object)Blocks.WET_SPONGE), event.getLookupProvider()));
    }

    protected void buildRecipes(@NotNull RecipeOutput writer) {
        if (this.shapeless) {
            ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)this.getItemProvider());
            this.tagMap.forEach((ingredientKey, tag) -> {
                builder.requires(tag);
                builder.unlockedBy("has_tag_" + ingredientKey, SimpleItemsRecipeGenerator.has((TagKey)tag));
            });
            this.itemMap.forEach((ingredientKey, item) -> {
                builder.requires(item);
                builder.unlockedBy("has_item_" + ingredientKey, SimpleItemsRecipeGenerator.has((ItemLike)item));
            });
            builder.save(writer);
        } else {
            ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)this.getItemProvider());
            this.pattern.forEach(arg_0 -> ((ShapedRecipeBuilder)builder).pattern(arg_0));
            this.tagMap.forEach((ingredientKey, tag) -> {
                builder.define(ingredientKey, tag);
                builder.unlockedBy("has_" + ingredientKey, SimpleItemsRecipeGenerator.has((TagKey)tag));
            });
            this.itemMap.forEach((ingredientKey, item) -> {
                builder.define(ingredientKey, item);
                builder.unlockedBy("has_" + ingredientKey, SimpleItemsRecipeGenerator.has((ItemLike)item));
            });
            builder.save(writer);
        }
    }
}

