/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.data.lang;

import com.communi.suggestu.scena.forge.platform.configuration.ForgeConfigurationManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="chiselsandbits", bus=EventBusSubscriber.Bus.MOD)
public class ConfigLangGenerator
implements DataProvider {
    private final PackOutput packOutput;

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().addProvider(true, (DataProvider)new ConfigLangGenerator(event.getGenerator().getPackOutput()));
    }

    public ConfigLangGenerator(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        ArrayList<String> langKeys = new ArrayList<String>(ForgeConfigurationManager.getInstance().getAvailableKeys());
        langKeys.sort(Comparator.comparing(s -> s.replace(".comment", "")));
        JsonObject returnValue = new JsonObject();
        for (String langKey : langKeys) {
            returnValue.addProperty(langKey, "");
        }
        Path configLangFolder = this.packOutput.getOutputFolder().resolve("assets/chiselsandbits/lang/config/");
        Path langPath = configLangFolder.resolve("config.json");
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)returnValue, (Path)langPath);
    }

    @NotNull
    public String getName() {
        return "Chiseled config lang generator";
    }
}

