/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.dummmmmmy.common.TargetDummyEntity;
import net.mehvahdjukaar.dummmmmmy.configs.ClientConfigs;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class TargetDummyModel<T extends TargetDummyEntity>
extends HumanoidModel<T> {
    public final ModelPart standPlate;
    private float bodyWobble = 0.0f;
    private float headSideWobble = 0.0f;
    private float rechargingAnim = 0.0f;

    public TargetDummyModel(ModelPart modelPart) {
        super(modelPart);
        this.standPlate = modelPart.getChild("stand");
    }

    public static LayerDefinition createMesh(float size, int textHeight) {
        CubeDeformation deformation = new CubeDeformation(size);
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)deformation, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("stand", CubeListBuilder.create().texOffs(0, 32).addBox(-6.0f, 12.0f, -6.0f, 12.0f, 1.0f, 12.0f, deformation), PartPose.offset((float)0.0f, (float)11.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, 1.0f, -2.0f, 4.0f, 8.0f, 4.0f, deformation.extend(0.01f)), PartPose.offset((float)-2.5f, (float)2.0f, (float)-0.005f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, 1.0f, -2.0f, 4.0f, 8.0f, 4.0f, deformation.extend(0.01f)), PartPose.offset((float)2.5f, (float)2.0f, (float)-0.005f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.extend(size != 0.0f ? -0.01f : 0.0f)), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)textHeight);
    }

    public void rotateModelX(ModelPart model, float pivotX, float pivotY, float pivotZ, float angle) {
        Vec3 oldRot = new Vec3((double)model.x, (double)model.y, (double)model.z);
        Vec3 actualRot = new Vec3((double)pivotX, (double)pivotY, (double)pivotZ);
        Vec3 newRot = actualRot.add(oldRot.subtract(actualRot).xRot(-angle));
        model.setPos((float)newRot.x(), (float)newRot.y(), (float)newRot.z());
        model.xRot = angle;
    }

    public void rotateModelY(ModelPart model, float pivotX, float pivotY, float pivotZ, float angle, int mult) {
        Vec3 oldRot = new Vec3((double)model.x, (double)model.y, (double)model.z);
        Vec3 actualRot = new Vec3((double)pivotX, (double)pivotY, (double)pivotZ);
        Vec3 newRot = actualRot.add(oldRot.subtract(actualRot).xRot(-angle));
        model.setPos((float)newRot.x(), (float)newRot.y(), (float)newRot.z());
        model.yRot = angle * (float)mult;
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int overlayIn, int color) {
        int overlay = OverlayTexture.NO_OVERLAY;
        matrixStackIn.pushPose();
        this.standPlate.render(matrixStackIn, bufferIn, packedLightIn, overlay, color);
        this.head.render(matrixStackIn, bufferIn, packedLightIn, overlay, color);
        this.rightArm.render(matrixStackIn, bufferIn, packedLightIn, overlay, color);
        this.leftArm.render(matrixStackIn, bufferIn, packedLightIn, overlay, color);
        this.body.render(matrixStackIn, bufferIn, packedLightIn, overlay, color);
        this.leftLeg.render(matrixStackIn, bufferIn, packedLightIn, overlay, color);
        this.hat.render(matrixStackIn, bufferIn, packedLightIn, overlay, color);
        matrixStackIn.popPose();
    }

    public ModelPart getBody() {
        return this.leftLeg;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        float phase = ((TargetDummyEntity)((Object)entity)).getShake(partialTick);
        float unscaledSwingAmount = ((TargetDummyEntity)((Object)entity)).getAnimationPosition(partialTick);
        float swingAmount = Math.min((float)((double)unscaledSwingAmount * ClientConfigs.ANIMATION_INTENSITY.get()), 40.0f);
        if (swingAmount > 0.0f) {
            this.bodyWobble = (float)(-((double)Mth.sin((float)phase) * Math.PI / 100.0 * (double)swingAmount));
            this.headSideWobble = (float)((double)Mth.sin((float)phase) * Math.PI / 20.0 * (double)Math.min(swingAmount, 1.0f));
        } else {
            this.bodyWobble = 0.0f;
            this.headSideWobble = 0.0f;
        }
        this.standPlate.xRot = 0.0f;
        this.standPlate.yRot = (float)Math.PI / 180 * -Mth.rotLerp((float)partialTick, (float)((TargetDummyEntity)((Object)entity)).yBodyRotO, (float)((TargetDummyEntity)((Object)entity)).yBodyRot);
        this.standPlate.zRot = 0.0f;
        float recharge = ((TargetDummyEntity)((Object)entity)).getRechargingAnimation(partialTick);
        this.rechargingAnim = this.smoothRamp(recharge, 0.1);
    }

    private float smoothRamp(float number, double cutoff) {
        return (float)((double)number < cutoff ? (double)number / cutoff : 1.0);
    }

    public void setupAnim(TargetDummyEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float n = 1.5f;
        float yOffsetIn = -1.0f;
        float xangle = this.bodyWobble / 2.0f;
        this.leftLeg.setPos(0.0f, 12.0f + yOffsetIn, 0.0f);
        this.rotateModelX(this.leftLeg, 0.0f, 24.0f + yOffsetIn, 0.0f, xangle);
        this.rightLeg.setPos(0.0f, 12.0f + yOffsetIn, 0.0f);
        this.rotateModelX(this.rightLeg, 0.01f, 24.0f + yOffsetIn + 0.01f, 0.01f, xangle);
        this.body.setPos(0.0f, 0.0f + yOffsetIn, 0.0f);
        this.rotateModelX(this.body, 0.0f, 24.0f + yOffsetIn, 0.0f, xangle);
        this.rightArm.setPos(-2.5f, 2.0f + yOffsetIn, -0.005f);
        this.rotateModelY(this.rightArm, 0.0f, 24.0f + yOffsetIn, 0.0f, xangle, -1);
        this.leftArm.setPos(2.5f, 2.0f + yOffsetIn, -0.005f);
        this.rotateModelY(this.leftArm, 0.0f, 24.0f + yOffsetIn, 0.0f, xangle, 1);
        this.head.setPos(0.0f, 0.0f + yOffsetIn, 0.0f);
        this.rotateModelX(this.head, 0.0f, 24.0f + yOffsetIn, 0.0f, xangle);
        this.head.xRot = -this.bodyWobble + this.rechargingAnim * 0.8f;
        this.head.zRot = this.headSideWobble;
        this.hat.copyFrom(this.head);
        this.rightArm.zRot = 1.5707964f;
        this.leftArm.zRot = -1.5707964f;
        this.rightArm.xRot = this.bodyWobble * n;
        this.leftArm.xRot = this.bodyWobble * n;
        this.leftArm.zRot += this.rechargingAnim * 0.25f;
        this.rightArm.zRot += this.rechargingAnim * -0.25f;
    }
}

