/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.register;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.lopyluna.dndesires.DnDesires;
import dev.lopyluna.dndesires.register.DesiresSoundTypes;
import dev.lopyluna.dndesires.register.DesiresTags;
import dev.lopyluna.dndesires.register.helpers.wood_types.BlockPattern;
import dev.lopyluna.dndesires.register.helpers.wood_types.VariantEntry;
import java.util.function.Function;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;

public enum DesiresStoneTypes {
    BRECCIA(BlockPattern.STANDARD_RANGE, r -> r.paletteStoneBlock("breccia", () -> Blocks.TUFF, true, true).properties(p -> p.destroyTime(1.25f).sound(DesiresSoundTypes.CRACKLE_STONE).mapColor(MapColor.COLOR_ORANGE)).register());

    private final Function<CreateRegistrate, NonNullSupplier<Block>> factory;
    private VariantEntry variants;
    public NonNullSupplier<Block> baseBlock;
    public final BlockPattern[] variantTypes;
    public TagKey<Item> materialTag;

    private DesiresStoneTypes(BlockPattern[] variantTypes, Function<CreateRegistrate, NonNullSupplier<Block>> factory) {
        this.factory = factory;
        this.variantTypes = variantTypes;
    }

    public NonNullSupplier<Block> getBaseBlock() {
        return this.baseBlock;
    }

    public VariantEntry getVariants() {
        return this.variants;
    }

    public static void register(CreateRegistrate registrate) {
        for (DesiresStoneTypes paletteStoneVariants : DesiresStoneTypes.values()) {
            paletteStoneVariants.baseBlock = paletteStoneVariants.factory.apply(registrate);
            String id = Lang.asId((String)paletteStoneVariants.name());
            paletteStoneVariants.materialTag = DesiresTags.optionalTag(BuiltInRegistries.ITEM, DnDesires.loc("stone_types/" + id));
            paletteStoneVariants.variants = new VariantEntry(id, paletteStoneVariants);
        }
    }
}

