/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.items.gatling_breaker;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.dndesires.DnDesires;
import dev.lopyluna.dndesires.content.items.gatling_breaker.GatlingBreakerItem;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class GatlingBreakerRenderer
extends CustomRenderedItemModelRenderer {
    protected static final PartialModel CORE = PartialModel.of((ResourceLocation)DnDesires.loc("item/gatling_breaker/core"));
    protected static final PartialModel CORE_GLOW = PartialModel.of((ResourceLocation)DnDesires.loc("item/gatling_breaker/core_glow"));
    protected static final PartialModel GEAR = PartialModel.of((ResourceLocation)DnDesires.loc("item/gatling_breaker/gear"));

    protected void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        GatlingBreakerItem item;
        LocalPlayer player;
        block5: {
            block4: {
                player = Minecraft.getInstance().player;
                Item item2 = stack.getItem();
                if (!(item2 instanceof GatlingBreakerItem)) break block4;
                item = (GatlingBreakerItem)item2;
                if (player != null) break block5;
            }
            return;
        }
        float worldTime = AnimationTickHolder.getRenderTime() / 20.0f;
        renderer.renderSolid(model.getOriginalModel(), light);
        boolean mainHand = player.getMainHandItem() == stack;
        boolean offHand = player.getOffhandItem() == stack;
        float animation = 1.1f - (float)item.shotSpeed / 20.0f;
        float multiplier = mainHand || offHand ? animation : Mth.sin((float)(worldTime * 5.0f));
        int lightIntensity = (int)(15.0f * Mth.clamp((float)multiplier, (float)0.0f, (float)1.0f));
        int glowLight = LightTexture.pack((int)lightIntensity, (int)Math.max(lightIntensity, 4));
        renderer.renderSolidGlowing(CORE.get(), glowLight);
        renderer.renderGlowing(CORE_GLOW.get(), glowLight);
        float angle = worldTime * -25.0f;
        if (mainHand || offHand) {
            angle += 360.0f;
        }
        float offset = -0.1875f;
        ms.translate(0.0f, offset, 0.0f);
        ms.mulPose(Axis.ZP.rotationDegrees(angle %= 360.0f));
        ms.translate(0.0f, -offset, 0.0f);
        renderer.render(GEAR.get(), light);
    }
}

