/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.omni_speed_controller;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.lopyluna.dndesires.content.blocks.kinetics.omni_speed_controller.OmniSpeedControllerBlock;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class OmniSpeedControllerBE
extends SplitShaftBlockEntity {
    public static final int DEFAULT_SPEED = 16;
    public ScrollValueBehaviour targetSpeed;

    public OmniSpeedControllerBE(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        Integer max = (Integer)AllConfigs.server().kinetics.maxRotationSpeed.get();
        this.targetSpeed = new KineticScrollValueBehaviour((Component)CreateLang.translateDirect((String)"kinetics.speed_controller.rotation_speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new ControllerValueBoxTransform());
        this.targetSpeed.between(-max.intValue(), max.intValue());
        this.targetSpeed.value = 16;
        this.targetSpeed.withCallback(i -> this.updateTargetRotation());
        behaviours.add((BlockEntityBehaviour)this.targetSpeed);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.SPEED_CONTROLLER});
    }

    private void updateTargetRotation() {
        assert (this.level != null);
        if (this.hasNetwork()) {
            this.getOrCreateNetwork().remove((KineticBlockEntity)this);
        }
        RotationPropagator.handleRemoved((Level)this.level, (BlockPos)this.worldPosition, (KineticBlockEntity)this);
        this.removeSource();
        this.attachKinetics();
        if (this.hasSource() && this.getSpeed() != 0.0f) {
            this.award(AllAdvancements.SPEED_CONTROLLER);
        }
    }

    public float getRotationSpeedModifier(Direction face) {
        return this.hasSource() ? (face != this.getSourceFacing() ? (float)this.targetSpeed.value / this.getSpeed() : 1.0f) : 1.0f;
    }

    private static class ControllerValueBoxTransform
    extends ValueBoxTransform.Sided {
        private ControllerValueBoxTransform() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)15.5);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return state.getValue((Property)OmniSpeedControllerBlock.AXIS) != direction.getAxis();
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            Player player = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 5.0, false);
            Direction side = this.getSide();
            boolean vertical = side.getAxis().isVertical();
            Direction angle = vertical ? (player != null ? player.getDirection() : side) : side;
            float yRot = AngleHelper.horizontalAngle((Direction)angle) + (float)(vertical && player != null ? 0 : 180);
            float xRot = this.getSide() == Direction.UP ? 90.0f : (this.getSide() == Direction.DOWN ? 270.0f : 0.0f);
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(yRot)).rotateXDegrees(xRot);
        }
    }
}

