/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.omni_gearbox;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.dndesires.content.blocks.kinetics.omni_gearbox.OmniGearboxBE;
import dev.lopyluna.dndesires.content.blocks.kinetics.omni_gearbox.OmniGearboxBlock;
import dev.lopyluna.dndesires.register.client.DesiresPartialModels;
import java.util.HashMap;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class OmniGearboxRenderer
extends KineticBlockEntityRenderer<OmniGearboxBE> {
    public OmniGearboxRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(OmniGearboxBE be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        Level level = be.getLevel();
        if (level == null) {
            return;
        }
        BlockPos pos = be.getBlockPos();
        BlockState state = be.getBlockState();
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)level);
        HashMap<Direction, PartialModel> panels = new HashMap<Direction, PartialModel>();
        panels.put(Direction.UP, DesiresPartialModels.TOP_PANEL);
        panels.put(Direction.DOWN, DesiresPartialModels.BOTTOM_PANEL);
        panels.put(Direction.NORTH, DesiresPartialModels.NORTH_PANEL);
        panels.put(Direction.EAST, DesiresPartialModels.EAST_PANEL);
        panels.put(Direction.SOUTH, DesiresPartialModels.SOUTH_PANEL);
        panels.put(Direction.WEST, DesiresPartialModels.WEST_PANEL);
        HashMap<Direction, Boolean> shafts = new HashMap<Direction, Boolean>();
        shafts.put(Direction.UP, (Boolean)state.getValue((Property)OmniGearboxBlock.UP_SHAFT));
        shafts.put(Direction.DOWN, (Boolean)state.getValue((Property)OmniGearboxBlock.DOWN_SHAFT));
        shafts.put(Direction.NORTH, (Boolean)state.getValue((Property)OmniGearboxBlock.NORTH_SHAFT));
        shafts.put(Direction.EAST, (Boolean)state.getValue((Property)OmniGearboxBlock.EAST_SHAFT));
        shafts.put(Direction.SOUTH, (Boolean)state.getValue((Property)OmniGearboxBlock.SOUTH_SHAFT));
        shafts.put(Direction.WEST, (Boolean)state.getValue((Property)OmniGearboxBlock.WEST_SHAFT));
        for (Direction direction : Iterate.directions) {
            if (((Boolean)shafts.get(direction)).booleanValue()) {
                Direction.Axis axis = direction.getAxis();
                SuperByteBuffer shaft = CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state, (Direction)direction);
                float speed = be.getSpeed();
                float offset = OmniGearboxRenderer.getRotationOffsetForPosition((KineticBlockEntity)be, (BlockPos)pos, (Direction.Axis)axis);
                float angle = time * speed * 3.0f / 10.0f % 360.0f;
                angle += offset;
                angle = angle / 180.0f * (float)Math.PI;
                OmniGearboxRenderer.kineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)be, (Direction.Axis)axis, (float)angle, (int)light);
                shaft.renderInto(ms, buffer.getBuffer(RenderType.solid()));
                continue;
            }
            CachedBuffers.partial((PartialModel)((PartialModel)panels.get(direction)), (BlockState)state).light(LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos)).renderInto(ms, buffer.getBuffer(RenderType.solid()));
        }
    }
}

