/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.multimeter;

import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.gauge.GaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.GaugeShaper;
import com.simibubi.create.foundation.block.IBE;
import dev.lopyluna.dndesires.content.blocks.kinetics.multimeter.MultiMeterBE;
import dev.lopyluna.dndesires.mixins.GaugeShaperAccessor;
import dev.lopyluna.dndesires.register.DesiresBETypes;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.levelWrappers.WrappedLevel;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class MultiMeterBlock
extends DirectionalAxisKineticBlock
implements IBE<MultiMeterBE> {
    public static final GaugeShaper GAUGE = GaugeShaperAccessor.make();

    public MultiMeterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        IRotate rotate;
        Level level = context.getLevel();
        Direction face = context.getClickedFace();
        BlockPos placedOnPos = context.getClickedPos().relative(context.getClickedFace().getOpposite());
        BlockState placedOnState = level.getBlockState(placedOnPos);
        Block block = placedOnState.getBlock();
        if (block instanceof IRotate && (rotate = (IRotate)block).hasShaftTowards((LevelReader)level, placedOnPos, placedOnState, face)) {
            BlockState toPlace = this.defaultBlockState();
            Direction horizontalFacing = context.getHorizontalDirection();
            Direction nearestLookingDirection = context.getNearestLookingDirection();
            boolean lookPositive = nearestLookingDirection.getAxisDirection() == Direction.AxisDirection.POSITIVE;
            return switch (face.getAxis()) {
                case Direction.Axis.X -> (BlockState)((BlockState)toPlace.setValue((Property)FACING, (Comparable)(lookPositive ? Direction.NORTH : Direction.SOUTH))).setValue((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(true));
                case Direction.Axis.Y -> (BlockState)((BlockState)toPlace.setValue((Property)FACING, (Comparable)horizontalFacing.getOpposite())).setValue((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(horizontalFacing.getAxis() == Direction.Axis.X));
                default -> (BlockState)((BlockState)toPlace.setValue((Property)FACING, (Comparable)(lookPositive ? Direction.WEST : Direction.EAST))).setValue((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(false));
            };
        }
        return super.getStateForPlacement(context);
    }

    protected Direction getFacingForPlacement(BlockPlaceContext context) {
        return context.getClickedFace();
    }

    protected boolean getAxisAlignmentForPlacement(BlockPlaceContext context) {
        return context.getHorizontalDirection().getAxis() != Direction.Axis.X;
    }

    public boolean shouldntRenderHeadOnFace(Level level, BlockPos pos, BlockState state, Direction face) {
        if (face.getAxis().isVertical() || face == ((Direction)state.getValue((Property)FACING)).getOpposite() || face.getAxis() == this.getRotationAxis(state)) {
            return true;
        }
        if (this.getRotationAxis(state) == Direction.Axis.Y && face != state.getValue((Property)FACING)) {
            return true;
        }
        return !Block.shouldRenderFace((BlockState)state, (BlockGetter)level, (BlockPos)pos, (Direction)face, (BlockPos)pos.relative(face)) && !(level instanceof WrappedLevel);
    }

    public void animateTick(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof GaugeBlockEntity)) {
            return;
        }
        GaugeBlockEntity be = (GaugeBlockEntity)blockEntity;
        if (be.dialTarget == 0.0f) {
            return;
        }
        int color = be.color;
        for (Direction face : Iterate.directions) {
            int count;
            if (this.shouldntRenderHeadOnFace(level, pos, state, face)) continue;
            Vector3f rgb = new Color(color).asVectorF();
            Vec3 faceVec = Vec3.atLowerCornerOf((Vec3i)face.getNormal());
            Direction pFacing = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)face.getAxis());
            Vec3 pFaceVec = Vec3.atLowerCornerOf((Vec3i)pFacing.getNormal());
            int n = count = be.dialTarget > 1.0f ? 4 : 1;
            if (count == 1 && random.nextFloat() > 0.25f) continue;
            for (int i = 0; i < count; ++i) {
                Vec3 mul = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)random, (float)0.25f).multiply(new Vec3(1.0, 1.0, 1.0).subtract(pFaceVec)).normalize().scale((double)0.3f);
                Vec3 offset = VecHelper.getCenterOf((Vec3i)pos).add(faceVec.scale(0.55)).add(mul);
                level.addParticle((ParticleOptions)new DustParticleOptions(rgb, 1.0f), offset.x, offset.y, offset.z, mul.x, mul.y, mul.z);
            }
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return GAUGE.get((Direction)state.getValue((Property)FACING), ((Boolean)state.getValue((Property)AXIS_ALONG_FIRST_COORDINATE)).booleanValue());
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState state, Level level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GaugeBlockEntity) {
            GaugeBlockEntity be = (GaugeBlockEntity)blockEntity;
            return Mth.ceil((float)Mth.clamp((float)(be.dialTarget * 14.0f), (float)0.0f, (float)15.0f));
        }
        return 0;
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        return false;
    }

    public Class<MultiMeterBE> getBlockEntityClass() {
        return MultiMeterBE.class;
    }

    public BlockEntityType<? extends MultiMeterBE> getBlockEntityType() {
        return (BlockEntityType)DesiresBETypes.MULTIMETER.get();
    }
}

