/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.compat.recipeviewers.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageFromStorageRecipe;

public class AssembleRecipesMaker {
    private AssembleRecipesMaker() {
    }

    public static <T extends PropertyBasedSubtypeInterpreter> List<RecipeHolder<CraftingRecipe>> getShapelessCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter) {
        return AssembleRecipesMaker.getShapelessCraftingRecipes(getSubtypeInterpreter, RecipeHolder::new);
    }

    public static <R, T extends PropertyBasedSubtypeInterpreter> List<R> getShapelessCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter, BiFunction<ResourceLocation, CraftingRecipe, R> transformRecipe) {
        RecipeConstructor<MovingStorageFromStorageRecipe> constructRecipe = (originalRecipe, ingredients, result) -> new ShapelessRecipe("", CraftingBookCategory.MISC, result, ingredients);
        return AssembleRecipesMaker.getCraftingRecipes(constructRecipe, MovingStorageFromStorageRecipe.class, getSubtypeInterpreter, transformRecipe);
    }

    private static <R, T extends CraftingRecipe, U extends PropertyBasedSubtypeInterpreter> List<R> getCraftingRecipes(RecipeConstructor<T> constructRecipe, Class<T> originalRecipeClass, Function<ItemStack, Optional<U>> getSubtypeInterpreter, BiFunction<ResourceLocation, CraftingRecipe, R> transformRecipe) {
        return ClientRecipeHelper.transformAllRecipesOfTypeIntoMultiple((RecipeType)RecipeType.CRAFTING, originalRecipeClass, recipe -> {
            ArrayList itemGroupRecipes = new ArrayList();
            int storageIngredientIndex = -1;
            NonNullList ingredients = recipe.getIngredients();
            TransientCraftingContainer craftinginventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

                public ItemStack quickMoveStack(Player player, int index) {
                    return ItemStack.EMPTY;
                }

                public boolean stillValid(Player playerIn) {
                    return false;
                }
            }, 3, 3);
            NonNullList ingredientsTemplate = NonNullList.createWithCapacity((int)ingredients.size());
            List<Object> storageItems = new ArrayList();
            int i = 0;
            for (Ingredient ingredient : ingredients) {
                Ingredient.ItemValue itemValue;
                Ingredient.Value patt0$temp;
                if (ingredient.getValues().length > 0 && (patt0$temp = ingredient.getValues()[0]) instanceof Ingredient.ItemValue && (itemValue = (Ingredient.ItemValue)patt0$temp).item().getItem() instanceof StorageBlockItem) {
                    storageItems = AssembleRecipesMaker.expandStorageItems(ingredient.getItems());
                    storageIngredientIndex = i;
                    ingredientsTemplate.add(i, (Object)Ingredient.EMPTY);
                } else {
                    ingredientsTemplate.add(i, (Object)ingredient);
                    if (!ingredient.isEmpty()) {
                        ItemStack[] ingredientItems = ingredient.getItems();
                        craftinginventory.setItem(i, ingredientItems[0]);
                    }
                }
                ++i;
            }
            for (ItemStack storageItem : storageItems) {
                NonNullList ingredientsCopy = NonNullList.createWithCapacity((int)ingredientsTemplate.size());
                ingredientsCopy.addAll((Collection)ingredientsTemplate);
                ingredientsCopy.set(storageIngredientIndex, (Object)Ingredient.of((ItemStack[])new ItemStack[]{storageItem}));
                craftinginventory.setItem(storageIngredientIndex, storageItem.copy());
                ItemStack result = ClientRecipeHelper.assemble((Recipe)recipe, (RecipeInput)craftinginventory.asCraftInput());
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedstorageinmotion", (String)("assemble_moving_storage_" + ((Optional)getSubtypeInterpreter.apply(result)).map(intepreter -> intepreter.getRegistrySanitizedItemString(result)).orElse("")));
                itemGroupRecipes.add(transformRecipe.apply(id, constructRecipe.construct(recipe, (NonNullList<Ingredient>)ingredientsCopy, result)));
            }
            return itemGroupRecipes;
        });
    }

    private static List<ItemStack> expandStorageItems(ItemStack[] items) {
        ArrayList<ItemStack> storageItems = new ArrayList<ItemStack>();
        HashSet<Item> alreadyExpanded = new HashSet<Item>();
        for (ItemStack item : items) {
            Item item2;
            if (!alreadyExpanded.add(item.getItem()) || !((item2 = item.getItem()) instanceof StorageBlockItem)) continue;
            StorageBlockItem storageBlockItem = (StorageBlockItem)item2;
            storageBlockItem.addCreativeTabItems(storageItems::add);
        }
        return storageItems;
    }

    private static interface RecipeConstructor<T extends Recipe<?>> {
        public CraftingRecipe construct(T var1, NonNullList<Ingredient> var2, ItemStack var3);
    }
}

