/*
 * Decompiled with CFR 0.152.
 */
package fr.shoqapik.beautifulcampfires;

import fr.shoqapik.beautifulcampfires.CampfireBlocks;
import fr.shoqapik.beautifulcampfires.mixin.BlockEntityTypeMixin;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

@Mod(value="beautifulcampfires")
public class BeautifulCampfires {
    public static final String MODID = "beautifulcampfires";
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"beautifulcampfires");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MOD_TAB = CREATIVE_MODE_TABS.register("example_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).title((Component)Component.literal((String)"Beautiful Campfires")).icon(() -> Blocks.CAMPFIRE.asItem().getDefaultInstance()).displayItems((parameters, output) -> {
        for (Item item : CampfireBlocks.itemsList) {
            output.accept(item.getDefaultInstance());
        }
    }).build());

    public BeautifulCampfires(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::remapEvent);
        CampfireBlocks.registerBlocks();
        CampfireBlocks.BLOCKS.register(modEventBus);
        CampfireBlocks.ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        for (Block block : CampfireBlocks.blockList) {
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.cutout());
        }
    }

    private void remapEvent(@NotNull RegisterEvent event) {
        if (!event.getRegistryKey().equals(Registries.BLOCK_ENTITY_TYPE)) {
            return;
        }
        BlockEntityType be = BlockEntityType.CAMPFIRE;
        Set<Block> currentBlocks = ((BlockEntityTypeMixin)be).getBlocks();
        ArrayList<Object> newValidBlocks = new ArrayList<Object>();
        newValidBlocks.addAll(currentBlocks);
        newValidBlocks.addAll(CampfireBlocks.blockList);
        ((BlockEntityTypeMixin)be).setBlocks(newValidBlocks.stream().collect(Collectors.toSet()));
    }
}

