/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.impl.item.CopyComponentsShapedRecipe;
import fuzs.puzzleslib.impl.item.CopyComponentsShapelessRecipe;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public interface CopyComponentsRecipe {
    public static final String SHAPED_RECIPE_SERIALIZER_ID = "copy_components_shaped_recipe";
    public static final String SHAPELESS_RECIPE_SERIALIZER_ID = "copy_components_shapeless_recipe";

    public static RecipeSerializer<?> getModSerializer(String modId, String recipeSerializerId) {
        RecipeSerializer recipeSerializer = (RecipeSerializer)BuiltInRegistries.RECIPE_SERIALIZER.get(ResourceLocationHelper.fromNamespaceAndPath(modId, recipeSerializerId));
        if (recipeSerializer == null) {
            ContentRegistrationFlags.throwForFlag(ContentRegistrationFlags.COPY_RECIPES);
        }
        return recipeSerializer;
    }

    public static void registerSerializers(BiConsumer<String, Supplier<RecipeSerializer<?>>> registrar) {
        registrar.accept(SHAPED_RECIPE_SERIALIZER_ID, () -> new Serializer<ShapedRecipe, CopyComponentsShapedRecipe>((RecipeSerializer<ShapedRecipe>)new ShapedRecipe.Serializer(), CopyComponentsShapedRecipe::new));
        registrar.accept(SHAPELESS_RECIPE_SERIALIZER_ID, () -> new Serializer<ShapelessRecipe, CopyComponentsShapelessRecipe>((RecipeSerializer<ShapelessRecipe>)new ShapelessRecipe.Serializer(), CopyComponentsShapelessRecipe::new));
    }

    public Ingredient getComponentsSource();

    default public void copyComponentsToResult(ItemStack result, CraftingInput craftingInput) {
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemStack = craftingInput.getItem(i);
            if (!this.getComponentsSource().test(itemStack)) continue;
            result.applyComponents(itemStack.getComponents());
            return;
        }
    }

    public record Serializer<R1 extends CraftingRecipe, R2 extends CraftingRecipe & CopyComponentsRecipe>(RecipeSerializer<R1> serializer, Factory<R1, R2> factory) implements RecipeSerializer<R2>
    {
        public MapCodec<R2> codec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)this.serializer.codec().forGetter(arg -> arg), (App)Ingredient.CODEC.fieldOf("copy_from").forGetter(rec$ -> ((CopyComponentsRecipe)rec$).getComponentsSource())).apply((Applicative)instance, (craftingRecipe, ingredient) -> this.factory.apply(this, (R1)craftingRecipe, (Ingredient)ingredient)));
        }

        public StreamCodec<RegistryFriendlyByteBuf, R2> streamCodec() {
            return StreamCodec.of((x$0, x$1) -> this.toNetwork((RegistryFriendlyByteBuf)x$0, (Object)((CraftingRecipe)x$1)), this::fromNetwork);
        }

        private R2 fromNetwork(RegistryFriendlyByteBuf buffer) {
            CraftingRecipe recipe = (CraftingRecipe)this.serializer.streamCodec().decode((Object)buffer);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            return this.factory.apply(this, recipe, ingredient);
        }

        private void toNetwork(RegistryFriendlyByteBuf buffer, R2 recipe) {
            this.serializer.streamCodec().encode((Object)buffer, recipe);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((CopyComponentsRecipe)recipe).getComponentsSource());
        }
    }

    @FunctionalInterface
    public static interface Factory<T extends CraftingRecipe, S extends CraftingRecipe & CopyComponentsRecipe> {
        public S apply(RecipeSerializer<?> var1, T var2, Ingredient var3);
    }
}

