/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin.neoforge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.texture.QuadTintingHelper;
import com.supermartijn642.fusion.texture.types.base.BaseTextureSprite;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.lighting.QuadLighter;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={QuadLighter.class})
public class QuadLighterMixin {
    @Shadow(remap=false)
    private BlockAndTintGetter level;
    @Shadow(remap=false)
    private BlockPos pos;
    @Shadow(remap=false)
    private BlockState state;
    @Final
    @Shadow(remap=false)
    private float[] cachedTintColor;

    @ModifyVariable(method={"process"}, at=@At(value="STORE"), ordinal=0, remap=false)
    private float[] tintQuad(float[] color, VertexConsumer consumer, PoseStack.Pose pose, BakedQuad quad, int overlay) {
        BaseTextureData.QuadTinting tinting;
        TextureAtlasSprite sprite;
        if (quad.tintIndex == 39216 && (sprite = quad.getSprite()) instanceof BaseTextureSprite && (tinting = ((BaseTextureSprite)sprite).data().getTinting()) != null) {
            int packedColor = QuadTintingHelper.getColor(tinting, this.state, this.level, this.pos);
            this.cachedTintColor[0] = (float)(packedColor >> 16 & 0xFF) / 255.0f;
            this.cachedTintColor[1] = (float)(packedColor >> 8 & 0xFF) / 255.0f;
            this.cachedTintColor[2] = (float)(packedColor & 0xFF) / 255.0f;
            return this.cachedTintColor;
        }
        return color;
    }
}

