/*
 * Decompiled with CFR 0.152.
 */
package auroras.mixin.client;

import auroras.ClientEventHandler;
import auroras.util.AHelpers;
import auroras.util.AuroraData;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=10)
public abstract class LevelRendererMixin {
    @Shadow
    private ClientLevel level;
    @Shadow
    private Minecraft minecraft;

    @Inject(method={"renderSky"}, at={@At(value="TAIL")}, cancellable=true)
    private void inject$renderSky(Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTicks, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        if (!AHelpers.areShadersEnabled() && this.level != null) {
            PoseStack poseStack = new PoseStack();
            poseStack.mulPose(frustumMatrix);
            for (AuroraData data : AuroraData.getDataList((Level)this.level)) {
                if (data == null) continue;
                for (String dimension : data.allowedDimensions) {
                    if (!dimension.equals(this.level.dimension().location().toString())) continue;
                    ClientEventHandler.AURORA.render(data, this.minecraft, (Level)this.level, poseStack, projectionMatrix, partialTicks);
                }
            }
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="TAIL")}, cancellable=true)
    private void inject$renderLevel(DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (AHelpers.areShadersEnabled() && this.level != null) {
            float partialTicks = deltaTracker.getGameTimeDeltaPartialTick(false);
            PoseStack poseStack = new PoseStack();
            poseStack.mulPose(frustumMatrix);
            for (AuroraData data : AuroraData.getDataList((Level)this.level)) {
                if (data == null) continue;
                for (String dimension : data.allowedDimensions) {
                    if (!dimension.equals(this.level.dimension().location().toString())) continue;
                    ClientEventHandler.AURORA.render(data, this.minecraft, (Level)this.level, poseStack, projectionMatrix, partialTicks);
                }
            }
        }
    }
}

