/*
 * Decompiled with CFR 0.152.
 */
package auroras.config;

import java.util.function.Function;
import net.neoforged.neoforge.common.ModConfigSpec;

public class AurorasConfig {
    public final ModConfigSpec.BooleanValue globalDetailOverride;
    public final ModConfigSpec.BooleanValue globalVisibilityOctavesOverride;
    public final ModConfigSpec.BooleanValue globalShouldAutoUpdate;
    public final ModConfigSpec.IntValue auroraVisibilityOctaves;
    public final ModConfigSpec.DoubleValue auroraRenderDistance;
    public final ModConfigSpec.IntValue auroraDetail;

    AurorasConfig(ModConfigSpec.Builder innerBuilder) {
        Function<String, ModConfigSpec.Builder> builder = name -> innerBuilder.translation("auroras.config.common." + name);
        innerBuilder.push("General");
        this.globalDetailOverride = builder.apply("globalDetailOverride").comment("Global toggle for controlling aurora detail.").define("globalDetailOverride", false);
        this.globalVisibilityOctavesOverride = builder.apply("globalVisibilityOctavesOverride").comment("Global toggle for controlling aurora appearance frequency.").define("globalVisibilityOctavesOverride", false);
        this.globalShouldAutoUpdate = builder.apply("globalShouldAutoUpdate").comment("If set to true, then the configs will update every mod update. Set to false if you want to manage config changes yourself.").define("globalShouldAutoUpdate", true);
        this.auroraDetail = builder.apply("auroraDetail").comment("How high of a resolution should the aurora render in? Lower value = lower resolution and quality but more FPS.").defineInRange("auroraDetail", 150, 0, Integer.MAX_VALUE);
        this.auroraVisibilityOctaves = builder.apply("auroraVisibilityOctaves").comment("How frequent the aurora should be visible. Under normal circumstances there can be many continuous days without auroras and vice versa. Lower value = more variable. If -1, then it's visible every night.").defineInRange("auroraVisibilityOctaves", 1, -1, Integer.MAX_VALUE);
        this.auroraRenderDistance = builder.apply("auroraRenderDistance").comment("Aurora render distance.").defineInRange("auroraRenderDistance", 500.0, -1.7976931348623157E308, Double.MAX_VALUE);
        innerBuilder.pop();
    }
}

