/*
 * Decompiled with CFR 0.152.
 */
package net.glad0s.bobberdetector.register;

import net.glad0s.bobberdetector.register.BDLang;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class BDTags {
    public static TagKey<EntityType<?>> BOBBER_TAG = BDTags.commonEntityTag("bobber");

    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> commonTag(Registry<T> registry, String path) {
        return BDTags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static TagKey<EntityType<?>> commonEntityTag(String path) {
        return BDTags.commonTag(BuiltInRegistries.ENTITY_TYPE, path);
    }

    public static TagKey<Block> commonBlockTag(String path) {
        return BDTags.commonTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> commonItemTag(String path) {
        return BDTags.commonTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> commonFluidTag(String path) {
        return BDTags.commonTag(BuiltInRegistries.FLUID, path);
    }

    public static enum Entities {
        BOBBER(NameSpace.COMMON);

        public final TagKey<EntityType<?>> tag;
        public final boolean alwaysDatagen;

        private Entities() {
            this(NameSpace.MOD);
        }

        private Entities(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private Entities(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private Entities(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private Entities(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? BDLang.asId(this.name()) : path));
            this.tag = optional ? BDTags.optionalTag(BuiltInRegistries.ENTITY_TYPE, id) : TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(EntityType<?> entityType) {
            return entityType.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("bobberdetector", false, true),
        COMMON("c", false, true);

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

