/*
 * Decompiled with CFR 0.152.
 */
package net.glad0s.bobberdetector.register;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.lang.LangNumberFormat;
import net.createmod.catnip.utility.lang.Components;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class BDLang {
    public static MutableComponent translateDirect(String key, Object ... args) {
        return Components.translatable((String)("bobberdetector." + key), (Object[])BDLang.resolveBuilders(args));
    }

    public static String asId(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public static String nonPluralId(String name) {
        String asId = BDLang.asId(name);
        return asId.endsWith("s") ? asId.substring(0, asId.length() - 1) : asId;
    }

    public static List<Component> translatedOptions(String prefix, String ... keys) {
        ArrayList<Component> result = new ArrayList<Component>(keys.length);
        for (String key : keys) {
            result.add((Component)BDLang.translate((String)(prefix != null ? prefix + "." : "") + key, new Object[0]).component());
        }
        return result;
    }

    public static LangBuilder builder() {
        return new LangBuilder("bobberdetector");
    }

    public static LangBuilder builder(String namespace) {
        return new LangBuilder(namespace);
    }

    public static LangBuilder blockName(BlockState state) {
        return BDLang.builder().add(state.getBlock().getName());
    }

    public static LangBuilder itemName(ItemStack stack) {
        return BDLang.builder().add(stack.getHoverName().copy());
    }

    public static LangBuilder number(double d) {
        return BDLang.builder().text(LangNumberFormat.format((double)d));
    }

    public static LangBuilder translate(String langKey, Object ... args) {
        return BDLang.builder().translate(langKey, args);
    }

    public static LangBuilder text(String text) {
        return BDLang.builder().text(text);
    }

    public static Object[] resolveBuilders(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (!(object instanceof LangBuilder)) continue;
            LangBuilder cb = (LangBuilder)object;
            args[i] = cb.component();
        }
        return args;
    }
}

