/*
 * Decompiled with CFR 0.152.
 */
package net.glad0s.bobberdetector.content.entity;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.outliner.AABBOutline;
import net.glad0s.bobberdetector.content.BobberDetectorBlock;
import net.glad0s.bobberdetector.register.BDTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BobberDetectorBlockEntity
extends SmartBlockEntity {
    private int RANGE_UP = 5;
    private int RANGE_SIDE = 5;
    private int RANGE_FRONT = 5;
    private int catchTimer = 0;
    final int CATCHCOOLDOWN = 20;
    private int redstoneTimer = 0;
    private final int REDSTONE_DURATION = 10;
    private int litRefreshTimer = 0;
    private final int LIT_RESET_TIME = 5;
    private final int FIRST_DETECTION_COOLDOWN = 20;
    boolean isBiting = false;
    private boolean powered;
    private boolean lit;
    private AABBOutline outline;

    public BobberDetectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void tick() {
        this.bobberScan();
    }

    private void updatePower(boolean powered) {
        BlockState blockstate = this.getBlockState();
        Block block = blockstate.getBlock();
        if (block instanceof BobberDetectorBlock) {
            this.powered = powered;
            BobberDetectorBlock.setPowered(blockstate, this.level, this.worldPosition, powered);
        }
    }

    private void updateLit(boolean lit) {
        BlockState blockstate = this.getBlockState();
        Block block = blockstate.getBlock();
        if (block instanceof BobberDetectorBlock) {
            this.lit = lit;
            BobberDetectorBlock.setLit(blockstate, this.level, this.worldPosition, lit);
        }
    }

    public AABB getAffectedArea() {
        BlockState blockstate = this.getBlockState();
        Direction facing = BobberDetectorBlock.getFacingDirection(blockstate);
        BlockPos topCorner = this.worldPosition.relative(facing).relative(facing.getClockWise(), this.RANGE_SIDE / 2).offset(0, this.RANGE_UP / 2, 0);
        BlockPos bottomCorner = this.worldPosition.relative(facing, this.RANGE_FRONT).relative(facing.getClockWise().getClockWise().getClockWise(), this.RANGE_SIDE / 2).offset(0, -this.RANGE_UP / 2, 0);
        AABB box = new AABB(bottomCorner).minmax(new AABB(topCorner));
        return box;
    }

    private void bobberScan() {
        if (!this.level.isClientSide && this.catchTimer == 0) {
            BlockState blockstate = this.getBlockState();
            Direction facing = BobberDetectorBlock.getFacingDirection(blockstate);
            BlockPos topCorner = this.worldPosition.relative(facing).relative(facing.getClockWise(), this.RANGE_SIDE / 2).offset(0, this.RANGE_UP / 2, 0);
            BlockPos bottomCorner = this.worldPosition.relative(facing, this.RANGE_FRONT).relative(facing.getClockWise().getClockWise().getClockWise(), this.RANGE_SIDE / 2).offset(0, -this.RANGE_UP / 2, 0);
            AABB box = new AABB(bottomCorner).minmax(new AABB(topCorner));
            List entities = this.level.getEntities(null, box);
            for (Entity target : entities) {
                boolean isInTag = target.getType().is(BDTags.BOBBER_TAG);
                if (!isInTag) continue;
                if (target instanceof FishingHook) {
                    FishingHook fishingHook = (FishingHook)target;
                    this.isBiting = fishingHook.biting;
                }
                double belowBobber = target.getY() - 0.2;
                belowBobber = (double)Math.round(belowBobber * 100.0) / 100.0;
                BlockPos fluidCheck = new BlockPos((int)target.getX(), (int)belowBobber, (int)target.getZ());
                boolean isInFluid = !this.level.getFluidState(fluidCheck).isEmpty();
                if (!isInFluid) continue;
                if (this.litRefreshTimer == 0) {
                    this.updateLit(true);
                }
                this.litRefreshTimer = 5;
                double x = (double)Math.round(target.getDeltaMovement().x * 100.0 * 10.0) / 10.0;
                double y = target.getDeltaMovement().y;
                double z = (double)Math.round(target.getDeltaMovement().z * 100.0 * 10.0) / 10.0;
                if (!(!(target instanceof FishingHook) && y < -0.075 && x == 0.0 && z == 0.0) && (!(target instanceof FishingHook) || !this.isBiting)) continue;
                this.catchTimer = 20;
                this.redstoneTimer = 10;
                this.updatePower(true);
                this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
            }
        }
        if (this.redstoneTimer > 0) {
            --this.redstoneTimer;
            if (this.redstoneTimer == 0) {
                this.updatePower(false);
            }
        }
        if (this.catchTimer > 0) {
            --this.catchTimer;
        }
        if (this.litRefreshTimer > 0) {
            --this.litRefreshTimer;
            if (this.litRefreshTimer == 0) {
                this.updateLit(false);
            }
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }
}

