/*
 * Decompiled with CFR 0.152.
 */
package com.kleiders.kleidersplayerrenderer;

import com.kleiders.kleidersplayerrenderer.KleidersIgnoreCancel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5EarsLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ParrotOnShoulderLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InternalPlayerRenderer
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>
implements KleidersIgnoreCancel {
    private final ResourceLocation PLAYER_SKIN;

    public InternalPlayerRenderer(EntityRendererProvider.Context context, ResourceLocation skin) {
        this(context, false, skin);
    }

    public InternalPlayerRenderer(EntityRendererProvider.Context context, boolean useSmallArms, ResourceLocation skin) {
        super(context, (EntityModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), useSmallArms), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(useSmallArms ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(useSmallArms ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
        this.addLayer((RenderLayer)new PlayerItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
        this.addLayer((RenderLayer)new Deadmau5EarsLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer)new CapeLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer((RenderLayer)new ParrotOnShoulderLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer((RenderLayer)new SpinAttackEffectLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
        this.PLAYER_SKIN = skin;
    }

    public void render(AbstractClientPlayer entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.setModelProperties(entityIn);
        super.render((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public Vec3 getRenderOffset(AbstractClientPlayer entityIn, float partialTicks) {
        return entityIn.isCrouching() ? new Vec3(0.0, -0.125, 0.0) : super.getRenderOffset((Entity)entityIn, partialTicks);
    }

    private void setModelProperties(AbstractClientPlayer clientPlayer) {
        PlayerModel playermodel = (PlayerModel)this.getModel();
        if (clientPlayer.isSpectator()) {
            playermodel.setAllVisible(false);
            playermodel.head.visible = true;
            playermodel.hat.visible = true;
        } else {
            playermodel.setAllVisible(true);
            playermodel.head.visible = true;
            playermodel.body.visible = true;
            playermodel.leftLeg.visible = true;
            playermodel.rightLeg.visible = true;
            playermodel.leftArm.visible = true;
            playermodel.rightArm.visible = true;
            playermodel.hat.visible = false;
            playermodel.jacket.visible = false;
            playermodel.leftPants.visible = false;
            playermodel.rightPants.visible = false;
            playermodel.leftSleeve.visible = false;
            playermodel.rightSleeve.visible = false;
            playermodel.crouching = clientPlayer.isCrouching();
            HumanoidModel.ArmPose bipedmodel$armpose = InternalPlayerRenderer.getArmPose(clientPlayer, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose bipedmodel$armpose1 = InternalPlayerRenderer.getArmPose(clientPlayer, InteractionHand.OFF_HAND);
            if (bipedmodel$armpose.isTwoHanded()) {
                HumanoidModel.ArmPose armPose = bipedmodel$armpose1 = clientPlayer.getOffhandItem().isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (clientPlayer.getMainArm() == HumanoidArm.RIGHT) {
                playermodel.rightArmPose = bipedmodel$armpose;
                playermodel.leftArmPose = bipedmodel$armpose1;
            } else {
                playermodel.rightArmPose = bipedmodel$armpose1;
                playermodel.leftArmPose = bipedmodel$armpose;
            }
        }
    }

    private static HumanoidModel.ArmPose getArmPose(AbstractClientPlayer p_241741_0_, InteractionHand p_241741_1_) {
        ItemStack itemstack = p_241741_0_.getItemInHand(p_241741_1_);
        if (itemstack.isEmpty()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (p_241741_0_.getUsedItemHand() == p_241741_1_ && p_241741_0_.getUseItemRemainingTicks() > 0) {
            UseAnim useaction = itemstack.getUseAnimation();
            if (useaction == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useaction == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useaction == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useaction == UseAnim.CROSSBOW && p_241741_1_ == p_241741_0_.getUsedItemHand()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!p_241741_0_.swinging && itemstack.getItem() == Items.CROSSBOW && CrossbowItem.isCharged((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public ResourceLocation getTextureLocation(AbstractClientPlayer entity) {
        return this.PLAYER_SKIN;
    }

    protected void scale(AbstractClientPlayer entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        float f = 0.9375f;
        matrixStackIn.scale(0.9375f, 0.9375f, 0.9375f);
    }

    public void renderRightHand(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, AbstractClientPlayer playerIn) {
        this.renderHand(matrixStackIn, bufferIn, combinedLightIn, playerIn, ((PlayerModel)this.model).rightArm, ((PlayerModel)this.model).rightSleeve);
    }

    public void renderLeftHand(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, AbstractClientPlayer playerIn) {
        this.renderHand(matrixStackIn, bufferIn, combinedLightIn, playerIn, ((PlayerModel)this.model).leftArm, ((PlayerModel)this.model).leftSleeve);
    }

    private void renderHand(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, AbstractClientPlayer playerIn, ModelPart rendererArmIn, ModelPart rendererArmwearIn) {
        PlayerModel playermodel = (PlayerModel)this.getModel();
        this.setModelProperties(playerIn);
        playermodel.attackTime = 0.0f;
        playermodel.crouching = false;
        playermodel.swimAmount = 0.0f;
        playermodel.setupAnim((LivingEntity)playerIn, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        rendererArmIn.xRot = 0.0f;
        rendererArmIn.render(matrixStackIn, bufferIn.getBuffer(RenderType.entitySolid((ResourceLocation)playerIn.getSkin().texture())), combinedLightIn, OverlayTexture.NO_OVERLAY);
        rendererArmwearIn.xRot = 0.0f;
        rendererArmwearIn.render(matrixStackIn, bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)playerIn.getSkin().texture())), combinedLightIn, OverlayTexture.NO_OVERLAY);
    }

    protected void setupRotations(AbstractClientPlayer p_117802_, PoseStack p_117803_, float p_117804_, float p_117805_, float p_117806_, float p_320048_) {
        float f = p_117802_.getSwimAmount(p_117806_);
        float f1 = p_117802_.getViewXRot(p_117806_);
        if (p_117802_.isFallFlying()) {
            super.setupRotations((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_, p_320048_);
            float f2 = (float)p_117802_.getFallFlyingTicks() + p_117806_;
            float f3 = Mth.clamp((float)(f2 * f2 / 100.0f), (float)0.0f, (float)1.0f);
            if (!p_117802_.isAutoSpinAttack()) {
                p_117803_.mulPose(Axis.XP.rotationDegrees(f3 * (-90.0f - f1)));
            }
            Vec3 vec3 = p_117802_.getViewVector(p_117806_);
            Vec3 vec31 = p_117802_.getDeltaMovementLerped(p_117806_);
            double d0 = vec31.horizontalDistanceSqr();
            double d1 = vec3.horizontalDistanceSqr();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec31.x * vec3.x + vec31.z * vec3.z) / Math.sqrt(d0 * d1);
                double d3 = vec31.x * vec3.z - vec31.z * vec3.x;
                p_117803_.mulPose(Axis.YP.rotation((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.setupRotations((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_, p_320048_);
            float f4 = p_117802_.isInWater() || p_117802_.isInFluidType((fluidType, height) -> p_117802_.canSwimInFluidType(fluidType)) ? -90.0f - p_117802_.getXRot() : -90.0f;
            float f5 = Mth.lerp((float)f, (float)0.0f, (float)f4);
            p_117803_.mulPose(Axis.XP.rotationDegrees(f5));
            if (p_117802_.isVisuallySwimming()) {
                p_117803_.translate(0.0f, -1.0f, 0.3f);
            }
        } else {
            super.setupRotations((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_, p_320048_);
        }
    }
}

