/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import mekanism.api.Action;
import mekanism.api.IConfigCardAccess;
import mekanism.api.IContentsListener;
import mekanism.api.MekanismItemAbilities;
import mekanism.api.Upgrade;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.MathUtils;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.attachments.FilterAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.chemical.AttachedChemicals;
import mekanism.common.attachments.containers.energy.AttachedEnergy;
import mekanism.common.attachments.containers.fluid.AttachedFluids;
import mekanism.common.attachments.containers.heat.AttachedHeat;
import mekanism.common.attachments.containers.heat.HeatCapacitorData;
import mekanism.common.attachments.containers.item.AttachedItems;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeHasBounding;
import mekanism.common.block.attribute.AttributeSound;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.AttributeUpgradeable;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.resolver.manager.ChemicalHandlerManager;
import mekanism.common.capabilities.resolver.manager.EnergyHandlerManager;
import mekanism.common.capabilities.resolver.manager.FluidHandlerManager;
import mekanism.common.capabilities.resolver.manager.HeatHandlerManager;
import mekanism.common.capabilities.resolver.manager.ItemHandlerManager;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.integration.computer.BoundMethodHolder;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.FactoryRegistry;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.MethodRestriction;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.ITrackableContainer;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.container.sync.chemical.SyncableChemicalStack;
import mekanism.common.inventory.container.sync.dynamic.SyncMapper;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.item.ItemConfigurationCard;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.LastEnergyTracker;
import mekanism.common.lib.chunkloading.IChunkLoader;
import mekanism.common.lib.frequency.IFrequencyHandler;
import mekanism.common.lib.frequency.TileComponentFrequency;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.lib.security.BlockSecurityUtils;
import mekanism.common.lib.security.ISecurityTile;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.tile.base.WrenchResult;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.interfaces.IComparatorSupport;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.interfaces.ITierUpgradable;
import mekanism.common.tile.interfaces.ITileActive;
import mekanism.common.tile.interfaces.ITileDirectional;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.interfaces.ITileRadioactive;
import mekanism.common.tile.interfaces.ITileRedstone;
import mekanism.common.tile.interfaces.ITileSound;
import mekanism.common.tile.interfaces.ITileUpgradable;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.RegistryUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityMekanism
extends CapabilityTileEntity
implements IFrequencyHandler,
ITileDirectional,
IConfigCardAccess,
ITileActive,
ITileSound,
ITileRedstone,
ISecurityTile,
IMekanismInventory,
ITileUpgradable,
ITierUpgradable,
IComparatorSupport,
ITrackableContainer,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
ITileHeatHandler,
IMekanismChemicalHandler,
IComputerTile,
ITileRadioactive,
Nameable {
    public final Set<Player> playersUsing = new HashSet<Player>();
    public int ticker;
    private final List<ITileComponent> components = new ArrayList<ITileComponent>();
    private final Holder<Block> blockProvider;
    private boolean supportsComparator;
    private boolean supportsComputers;
    private boolean supportsUpgrades;
    private boolean supportsRedstone;
    private boolean canBeUpgraded;
    private boolean isDirectional;
    private boolean isActivatable;
    private AttributeStateActive activeAttribute;
    private boolean hasBounding;
    private boolean hasSecurity;
    private boolean hasSound;
    private boolean hasGui;
    private boolean hasChunkloader;
    private boolean nameable;
    @Nullable
    private Component customName;
    @Nullable
    private String containerDescription;
    private boolean syncMasterToBounding;
    @Nullable
    private Direction cachedDirection;
    public final Supplier<Direction> facingSupplier = this::getDirection;
    protected boolean redstone = false;
    private boolean redstoneLastTick = false;
    private IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    private int currentRedstoneLevel;
    private boolean updateComparators;
    protected TileComponentUpgrade upgradeComponent;
    protected final TileComponentFrequency frequencyComponent;
    @Nullable
    protected final ItemHandlerManager itemHandlerManager;
    @Nullable
    protected final ChemicalHandlerManager chemicalHandlerManager;
    private float radiationScale;
    @Nullable
    protected final FluidHandlerManager fluidHandlerManager;
    @Nullable
    protected final EnergyHandlerManager energyHandlerManager;
    private final LastEnergyTracker lastEnergyTracker = new LastEnergyTracker();
    protected final Map<Direction, BlockCapabilityCache<IHeatHandler, @Nullable Direction>> adjacentHeatCaps;
    protected final CachedAmbientTemperature ambientTemperature;
    @Nullable
    protected final HeatHandlerManager heatHandlerManager;
    private TileComponentSecurity securityComponent;
    private boolean currentActive;
    private int updateDelay;
    protected IntSupplier delaySupplier;
    @Nullable
    protected final Supplier<SoundEvent> soundEvent;
    @Nullable
    protected SoundEvent lastSoundEvent;
    private SoundInstance activeSound;
    private int playSoundCooldown;

    public TileEntityMekanism(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(((IHasTileEntity)blockProvider.value()).getTileType(), pos, state);
        this.delaySupplier = MekanismConfig.general.blockDeactivationDelay;
        this.playSoundCooldown = 0;
        this.blockProvider = blockProvider;
        this.setSupportedTypes(this.blockProvider);
        this.presetVariables();
        IContentsListener saveOnlyListener = this::markForSave;
        ArrayList capabilityHandlerManagers = new ArrayList();
        IChemicalTankHolder initialChemicalTanks = this.getInitialChemicalTanks(this.getListener(ContainerType.CHEMICAL, saveOnlyListener));
        if (initialChemicalTanks != null) {
            this.chemicalHandlerManager = new ChemicalHandlerManager(initialChemicalTanks, this);
            capabilityHandlerManagers.add(this.chemicalHandlerManager);
        } else {
            this.chemicalHandlerManager = null;
        }
        IFluidTankHolder initialFluidTanks = this.getInitialFluidTanks(this.getListener(ContainerType.FLUID, saveOnlyListener));
        if (initialFluidTanks != null) {
            this.fluidHandlerManager = new FluidHandlerManager(initialFluidTanks, this);
            capabilityHandlerManagers.add(this.fluidHandlerManager);
        } else {
            this.fluidHandlerManager = null;
        }
        IEnergyContainerHolder initialEnergyContainers = this.getInitialEnergyContainers(this.getListener(ContainerType.ENERGY, saveOnlyListener));
        if (initialEnergyContainers != null) {
            this.energyHandlerManager = new EnergyHandlerManager(initialEnergyContainers, this);
            capabilityHandlerManagers.add(this.energyHandlerManager);
        } else {
            this.energyHandlerManager = null;
        }
        IInventorySlotHolder initialInventory = this.getInitialInventory(this.getListener(ContainerType.ITEM, saveOnlyListener));
        if (initialInventory != null) {
            this.itemHandlerManager = new ItemHandlerManager(initialInventory, this);
            capabilityHandlerManagers.add(this.itemHandlerManager);
        } else {
            this.itemHandlerManager = null;
        }
        CachedAmbientTemperature ambientTemperature = new CachedAmbientTemperature(() -> ((TileEntityMekanism)this).getLevel(), () -> ((TileEntityMekanism)this).getBlockPos());
        IHeatCapacitorHolder initialHeatCapacitors = this.getInitialHeatCapacitors(this.getListener(ContainerType.HEAT, saveOnlyListener), ambientTemperature);
        if (initialHeatCapacitors != null) {
            this.heatHandlerManager = new HeatHandlerManager(initialHeatCapacitors, this);
            capabilityHandlerManagers.add(this.heatHandlerManager);
        } else {
            this.heatHandlerManager = null;
        }
        if (this.canHandleHeat()) {
            this.adjacentHeatCaps = new EnumMap<Direction, BlockCapabilityCache<IHeatHandler, Direction>>(Direction.class);
            this.ambientTemperature = ambientTemperature;
        } else {
            this.adjacentHeatCaps = Collections.emptyMap();
            this.ambientTemperature = null;
        }
        this.addCapabilityResolvers(capabilityHandlerManagers);
        this.frequencyComponent = new TileComponentFrequency(this);
        if (this.supportsUpgrades()) {
            this.upgradeComponent = new TileComponentUpgrade(this);
        }
        if (this.hasSecurity()) {
            this.securityComponent = new TileComponentSecurity(this);
        }
        this.soundEvent = this.hasSound() ? Attribute.getOrThrow(this.blockProvider, AttributeSound.class).getSound() : null;
    }

    private void setSupportedTypes(Holder<Block> block) {
        this.supportsUpgrades = Attribute.has(block, AttributeUpgradeSupport.class);
        this.canBeUpgraded = Attribute.has(block, AttributeUpgradeable.class);
        this.isDirectional = Attribute.has(block, AttributeStateFacing.class);
        this.supportsRedstone = Attribute.has(block, Attributes.AttributeRedstone.class);
        this.hasSound = Attribute.has(block, AttributeSound.class);
        this.hasGui = Attribute.has(block, AttributeGui.class);
        this.hasBounding = Attribute.has(block, AttributeHasBounding.class);
        this.hasSecurity = Attribute.has(block, Attributes.AttributeSecurity.class);
        this.activeAttribute = Attribute.get(block, AttributeStateActive.class);
        this.isActivatable = this.hasSound || this.activeAttribute != null;
        this.supportsComparator = Attribute.has(block, Attributes.AttributeComparator.class);
        this.supportsComputers = Mekanism.hooks.computerCompatEnabled() && Attribute.has(block, Attributes.AttributeComputerIntegration.class);
        this.hasChunkloader = this instanceof IChunkLoader;
        this.nameable = this.hasGui() && !Attribute.getOrThrow(this.getBlockHolder(), AttributeGui.class).hasCustomName();
    }

    protected void presetVariables() {
    }

    public final Holder<Block> getBlockHolder() {
        return this.blockProvider;
    }

    public boolean persists(ContainerType<?, ?, ?> type) {
        return type.canHandle(this);
    }

    public boolean persistsToItem(ContainerType<?, ?, ?> type) {
        return this.persists(type);
    }

    public boolean syncs(ContainerType<?, ?, ?> type) {
        return this.persists(type);
    }

    @Override
    public final boolean supportsUpgrades() {
        return this.supportsUpgrades;
    }

    @Override
    public final boolean supportsComparator() {
        return this.supportsComparator;
    }

    @Override
    public final boolean canBeUpgraded() {
        return this.canBeUpgraded;
    }

    @Override
    public final boolean isDirectional() {
        return this.isDirectional;
    }

    @Override
    public final boolean supportsRedstone() {
        return this.supportsRedstone;
    }

    @Override
    public final boolean hasSound() {
        return this.hasSound;
    }

    public final boolean hasGui() {
        return this.hasGui;
    }

    @Override
    public final boolean hasSecurity() {
        return this.hasSecurity;
    }

    @Override
    public final boolean isActivatable() {
        return this.isActivatable;
    }

    @Override
    public final boolean hasComputerSupport() {
        return this.supportsComputers;
    }

    @Override
    public final boolean hasInventory() {
        return this.itemHandlerManager != null && this.itemHandlerManager.canHandle();
    }

    @Override
    public boolean canHandleChemicals() {
        return this.chemicalHandlerManager != null && this.chemicalHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleFluid() {
        return this.fluidHandlerManager != null && this.fluidHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleEnergy() {
        return this.energyHandlerManager != null && this.energyHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleHeat() {
        return this.heatHandlerManager != null && this.heatHandlerManager.canHandle();
    }

    public void addComponent(ITileComponent component) {
        this.components.add(component);
        if (component instanceof TileComponentConfig) {
            TileComponentConfig config = (TileComponentConfig)component;
            this.addConfigComponent(config);
        }
    }

    public List<ITileComponent> getComponents() {
        return this.components;
    }

    @NotNull
    public Component getName() {
        return this.hasCustomName() ? this.getCustomName() : TextComponentUtil.build(this.getBlockHolder());
    }

    @NotNull
    public Component getDisplayName() {
        if (this.isNameable()) {
            return this.hasCustomName() ? this.getCustomName() : TextComponentUtil.translate(this.getContainerDescription());
        }
        return TextComponentUtil.build(this.getBlockHolder());
    }

    private String getContainerDescription() {
        if (this.containerDescription == null) {
            this.containerDescription = Util.makeDescriptionId((String)"container", (ResourceLocation)RegistryUtils.getName(this.getBlockHolder()));
        }
        return this.containerDescription;
    }

    @Nullable
    public Component getCustomName() {
        return this.isNameable() ? this.customName : null;
    }

    public void setCustomName(@Nullable Component name) {
        if (this.isNameable()) {
            this.customName = name;
        }
    }

    public boolean isNameable() {
        return this.nameable;
    }

    @Override
    public void markDirtyComparator() {
        if (this.supportsComparator()) {
            this.updateComparators = true;
        }
    }

    protected void notifyComparatorChange() {
        this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
    }

    protected WrenchResult tryWrenchDismantle(BlockState state, Player player, ItemStack stack) {
        if (player.isShiftKeyDown()) {
            if (RadiationManager.isGlobalRadiationEnabled() && this.getRadiationScale() > 0.0f) {
                return WrenchResult.RADIOACTIVE;
            }
            WorldUtils.dismantleBlock(state, this.getLevel(), this.worldPosition, this, (Entity)player, stack);
            return WrenchResult.DISMANTLED;
        }
        return WrenchResult.PASS;
    }

    protected WrenchResult tryWrenchRotate(BlockState state, Player player, ItemStack stack) {
        AttributeStateFacing attribute;
        if (this.isDirectional() && (attribute = Attribute.getOrThrow(this.getBlockHolder(), AttributeStateFacing.class)).canRotate()) {
            this.setFacing(MekanismUtils.rotate(this.getDirection(), attribute.getFacingProperty() == BlockStateProperties.FACING));
            return WrenchResult.SUCCESS;
        }
        return WrenchResult.PASS;
    }

    public WrenchResult tryWrench(BlockState state, Player player, ItemStack stack) {
        if (stack.isEmpty()) {
            return WrenchResult.PASS;
        }
        WrenchResult result = WrenchResult.PASS;
        boolean canRotate = stack.canPerformAction(MekanismItemAbilities.WRENCH_ROTATE);
        boolean canDismantle = stack.canPerformAction(MekanismItemAbilities.WRENCH_DISMANTLE);
        if (!canRotate && !canDismantle) {
            if (stack.canPerformAction(MekanismItemAbilities.WRENCH_EMPTY) || stack.canPerformAction(MekanismItemAbilities.WRENCH_CONFIGURE)) {
                return result;
            }
            canRotate = canDismantle = stack.is(MekanismTags.Items.CONFIGURATORS);
        }
        if (canRotate || canDismantle) {
            if (this.hasSecurity() && !IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, this.getWorldNN(), this.worldPosition, this)) {
                return WrenchResult.NO_SECURITY;
            }
            if (canDismantle) {
                result = this.tryWrenchDismantle(state, player, stack);
            }
            if (result == WrenchResult.PASS && canRotate) {
                result = this.tryWrenchRotate(state, player, stack);
            }
        }
        return result;
    }

    public InteractionResult openGui(Player player) {
        if (this.hasGui() && !this.isRemote() && !player.isShiftKeyDown()) {
            ItemConfigurator configurator;
            Item item;
            if (this.hasSecurity() && !IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, player.level(), this.worldPosition, this)) {
                return InteractionResult.FAIL;
            }
            ItemStack stack = player.getMainHandItem();
            if (this.isDirectional() && !stack.isEmpty() && (item = stack.getItem()) instanceof ItemConfigurator && (configurator = (ItemConfigurator)item).getMode(stack) == ItemConfigurator.ConfiguratorMode.ROTATE) {
                return InteractionResult.PASS;
            }
            if (!stack.isEmpty() && stack.getItem() instanceof ItemConfigurationCard && WorldUtils.getCapability(this.level, Capabilities.CONFIG_CARD, this.worldPosition, null, this, null) != null) {
                return InteractionResult.PASS;
            }
            player.openMenu(Attribute.getOrThrow(this.getBlockHolder(), AttributeGui.class).getProvider(this, true), buffer -> {
                buffer.writeBlockPos(this.worldPosition);
                this.encodeExtraContainerData((RegistryFriendlyByteBuf)buffer);
            });
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void encodeExtraContainerData(RegistryFriendlyByteBuf buffer) {
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, TileEntityMekanism tile) {
        if (tile.hasSound()) {
            tile.updateSound();
        }
        tile.onUpdateClient();
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, TileEntityMekanism tile) {
        if (tile.hasBounding && tile.syncMasterToBounding) {
            tile.syncMasterToBounding = false;
            AttributeHasBounding hasBounding = Attribute.get(state, AttributeHasBounding.class);
            if (hasBounding != null) {
                hasBounding.syncMasterPosition(level, pos, state);
            }
        }
        tile.frequencyComponent.tickServer(level, pos);
        if (tile.supportsUpgrades()) {
            tile.upgradeComponent.tickServer();
        }
        if (tile.hasChunkloader) {
            ((IChunkLoader)((Object)tile)).getChunkLoader().tickServer();
        }
        if (tile.isActivatable() && tile.updateDelay > 0) {
            --tile.updateDelay;
            if (tile.updateDelay == 0 && tile.getClientActive() != tile.currentActive) {
                level.setBlockAndUpdate(pos, tile.activeAttribute.setActive(state, tile.currentActive));
            }
        }
        boolean sendUpdatePacket = tile.onUpdateServer();
        if (tile.updateRadiationScale()) {
            sendUpdatePacket = true;
        }
        if (tile.canHandleHeat()) {
            tile.updateHeatCapacitors(null);
        }
        tile.lastEnergyTracker.received(level.getGameTime(), 0L);
        if (tile.supportsComparator() && tile.updateComparators && !state.isAir()) {
            int newRedstoneLevel = tile.getRedstoneLevel();
            if (newRedstoneLevel != tile.currentRedstoneLevel) {
                tile.currentRedstoneLevel = newRedstoneLevel;
                tile.notifyComparatorChange();
            }
            tile.updateComparators = false;
        }
        ++tile.ticker;
        if (tile.supportsRedstone()) {
            tile.redstoneLastTick = tile.redstone;
        }
        if (sendUpdatePacket) {
            tile.sendUpdatePacket();
        }
    }

    public void open(Player player) {
        this.playersUsing.add(player);
    }

    public void close(Player player) {
        this.playersUsing.remove(player);
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        for (ITileComponent component : this.components) {
            component.invalidate();
        }
        if (this.isRemote() && this.hasSound()) {
            this.updateSound();
        }
    }

    @Override
    public void blockRemoved() {
        super.blockRemoved();
        for (ITileComponent component : this.components) {
            component.removed();
        }
        if (!this.isRemote() && RadiationManager.isGlobalRadiationEnabled() && this.shouldDumpRadiation()) {
            IRadiationManager.INSTANCE.dumpRadiation(this.getWorldNN(), this.worldPosition, this.getChemicalTanks(null), false);
        }
    }

    protected void onUpdateClient() {
    }

    protected boolean onUpdateServer() {
        return false;
    }

    public void resyncMasterToBounding() {
        if (this.hasBounding) {
            this.syncMasterToBounding = true;
        }
    }

    @Deprecated
    public void setBlockState(@NotNull BlockState newState) {
        Direction newDirection;
        super.setBlockState(newState);
        if (this.isDirectional() && this.cachedDirection != (newDirection = Attribute.getFacing(newState))) {
            this.invalidateDirectionCaches(newDirection);
        }
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        NBTUtils.setBooleanIfPresent(nbt, "redstone", value -> {
            this.redstone = value;
        });
        for (ITileComponent iTileComponent : this.components) {
            iTileComponent.read(nbt, provider);
        }
        this.readSustainedData(provider, nbt);
        for (ContainerType containerType : ContainerType.TYPES) {
            if (!containerType.canHandle(this) || !this.persists(containerType)) continue;
            containerType.readFrom(provider, nbt, this);
        }
        if (this.isActivatable()) {
            NBTUtils.setBooleanIfPresent(nbt, "active_state", value -> {
                this.currentActive = value;
            });
            NBTUtils.setIntIfPresent(nbt, "update_delay", value -> {
                this.updateDelay = value;
            });
        }
        if (this.supportsComparator()) {
            NBTUtils.setIntIfPresent(nbt, "current_redstone", value -> {
                this.currentRedstoneLevel = value;
            });
        }
        if (this.isNameable()) {
            NBTUtils.setStringIfPresent(nbt, "CustomName", value -> {
                this.customName = Component.Serializer.fromJson((String)value, (HolderLookup.Provider)provider);
            });
        }
    }

    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putBoolean("redstone", this.redstone);
        for (ITileComponent iTileComponent : this.components) {
            iTileComponent.write(nbtTags, provider);
        }
        this.writeSustainedData(provider, nbtTags);
        for (ContainerType containerType : ContainerType.TYPES) {
            if (!containerType.canHandle(this) || !this.persists(containerType)) continue;
            containerType.saveTo(provider, nbtTags, this);
        }
        if (this.isActivatable()) {
            nbtTags.putBoolean("active_state", this.currentActive);
            nbtTags.putInt("update_delay", this.updateDelay);
        }
        if (this.supportsComparator()) {
            nbtTags.putInt("current_redstone", this.currentRedstoneLevel);
        }
        if (this.customName != null && this.isNameable()) {
            nbtTags.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
    }

    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag data) {
        if (this.supportsRedstone()) {
            NBTUtils.writeEnum(data, "control_type", this.controlType);
        }
    }

    public void readSustainedData(HolderLookup.Provider provider, CompoundTag data) {
        if (this.supportsRedstone()) {
            NBTUtils.setEnumIfPresent(data, "control_type", IRedstoneControl.RedstoneControl.BY_ID, type -> {
                this.controlType = this.supportedOrNextType((IRedstoneControl.RedstoneControl)type);
            });
        }
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        if (this.isNameable()) {
            this.setCustomName((Component)input.get(DataComponents.CUSTOM_NAME));
        }
        for (ITileComponent iTileComponent : this.components) {
            iTileComponent.applyImplicitComponents(input);
        }
        if (this.supportsUpgrades()) {
            for (Upgrade upgrade : this.getSupportedUpgrade()) {
                this.recalculateUpgrades(upgrade);
            }
        }
        for (ContainerType containerType : ContainerType.TYPES) {
            if (!this.persistsToItem(containerType)) continue;
            containerType.copyToTile(this, input);
        }
        TileEntityMekanism tileEntityMekanism = this;
        if (tileEntityMekanism instanceof ITileFilterHolder) {
            ITileFilterHolder filterHolder = (ITileFilterHolder)((Object)tileEntityMekanism);
            FilterAware filterAware = (FilterAware)input.get(MekanismDataComponents.FILTER_AWARE);
            if (filterAware != null) {
                filterHolder.getFilterManager().trySetFilters(filterAware.filters());
            }
        }
        if (this.supportsRedstone()) {
            this.setControlType((IRedstoneControl.RedstoneControl)input.getOrDefault(MekanismDataComponents.REDSTONE_CONTROL, (Object)this.getControlType()));
        }
    }

    @Override
    public List<DataComponentType<?>> getRemapEntries() {
        List<DataComponentType<?>> remapEntries = super.getRemapEntries();
        for (ITileComponent iTileComponent : this.components) {
            iTileComponent.addRemapEntries(remapEntries);
        }
        for (ContainerType containerType : ContainerType.TYPES) {
            if (!this.persistsToItem(containerType) || remapEntries.contains(containerType.getComponentType().get())) continue;
            remapEntries.add((DataComponentType)containerType.getComponentType().get());
        }
        if (this instanceof ITileFilterHolder && !remapEntries.contains(MekanismDataComponents.FILTER_AWARE.get())) {
            remapEntries.add((DataComponentType)MekanismDataComponents.FILTER_AWARE.get());
        }
        return remapEntries;
    }

    @Deprecated
    public void removeComponentsFromTag(@NotNull CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        for (ITileComponent component : this.components) {
            tag.remove(component.getComponentKey());
        }
        tag.remove("redstone");
        if (this.supportsComparator()) {
            tag.remove("current_redstone");
        }
        if (this.isActivatable()) {
            tag.remove("active_state");
            tag.remove("update_delay");
        }
        if (this.supportsRedstone()) {
            tag.remove("control_type");
        }
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        ITileFilterHolder filterHolder;
        FilterManager filterManager;
        super.collectImplicitComponents(builder);
        for (ITileComponent iTileComponent : this.components) {
            iTileComponent.collectImplicitComponents(builder);
        }
        for (ContainerType containerType : ContainerType.TYPES) {
            if (!this.persistsToItem(containerType)) continue;
            containerType.copyFromTile(this, builder);
        }
        TileEntityMekanism tileEntityMekanism = this;
        if (tileEntityMekanism instanceof ITileFilterHolder && !(filterManager = (filterHolder = (ITileFilterHolder)((Object)tileEntityMekanism)).getFilterManager()).getFilters().isEmpty()) {
            builder.set(MekanismDataComponents.FILTER_AWARE, (Object)new FilterAware(List.copyOf(filterManager.getFilters())));
        }
        if (this.supportsRedstone()) {
            builder.set(MekanismDataComponents.REDSTONE_CONTROL, (Object)this.controlType);
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        block12: {
            SyncMapper.INSTANCE.setup(container, this.getClass(), () -> this);
            for (ITileComponent component : this.components) {
                component.trackForMainContainer(container);
            }
            if (this.supportsRedstone()) {
                container.track(SyncableEnum.create(IRedstoneControl.RedstoneControl.BY_ID, IRedstoneControl.RedstoneControl.DISABLED, () -> this.controlType, value -> {
                    this.controlType = value;
                }));
                container.track(SyncableBoolean.create(this::isPowered, value -> {
                    this.redstone = value;
                }));
                container.track(SyncableBoolean.create(this::wasPowered, value -> {
                    this.redstoneLastTick = value;
                }));
            }
            boolean isClient = this.isRemote();
            if (this.canHandleChemicals() && this.syncs(ContainerType.CHEMICAL)) {
                List<IChemicalTank> chemicalTanks = this.getChemicalTanks(null);
                for (IChemicalTank chemicalTank : chemicalTanks) {
                    container.track(SyncableChemicalStack.create(chemicalTank, isClient));
                }
            }
            if (this.canHandleFluid() && this.syncs(ContainerType.FLUID)) {
                List<IExtendedFluidTank> fluidTanks = this.getFluidTanks(null);
                for (IExtendedFluidTank fluidTank : fluidTanks) {
                    container.track(SyncableFluidStack.create(fluidTank, isClient));
                }
            }
            if (this.canHandleHeat() && this.syncs(ContainerType.HEAT)) {
                List<IHeatCapacitor> heatCapacitors = this.getHeatCapacitors(null);
                for (IHeatCapacitor capacitor : heatCapacitors) {
                    container.track(SyncableDouble.create(capacitor::getHeat, capacitor::setHeat));
                    if (!(capacitor instanceof BasicHeatCapacitor)) continue;
                    BasicHeatCapacitor heatCapacitor = (BasicHeatCapacitor)capacitor;
                    container.track(SyncableDouble.create(capacitor::getHeatCapacity, capacity -> heatCapacitor.setHeatCapacity(capacity, false)));
                }
            }
            if (!this.canHandleEnergy() || !this.syncs(ContainerType.ENERGY)) break block12;
            this.trackLastEnergy(container);
            List<IEnergyContainer> energyContainers = this.getEnergyContainers(null);
            for (IEnergyContainer energyContainer : energyContainers) {
                block13: {
                    MachineEnergyContainer machineEnergy;
                    block14: {
                        if (!(energyContainer instanceof MachineEnergyContainer)) break block13;
                        machineEnergy = (MachineEnergyContainer)energyContainer;
                        if (this.supportsUpgrades()) break block14;
                        if (!machineEnergy.adjustableRates()) break block13;
                    }
                    container.track(SyncableLong.create(machineEnergy::getMaxEnergy, machineEnergy::setMaxEnergy));
                    container.track(SyncableLong.create(machineEnergy::getEnergyPerTick, machineEnergy::setEnergyPerTick));
                }
                container.track(SyncableLong.create(energyContainer::getEnergy, energyContainer::setEnergy));
            }
        }
    }

    protected void trackLastEnergy(MekanismContainer container) {
        container.track(SyncableLong.create(this.lastEnergyTracker::getLastEnergyReceived, this.lastEnergyTracker::setLastEnergyReceived));
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        for (ITileComponent component : this.components) {
            component.addToUpdateTag(updateTag);
        }
        updateTag.putFloat("radiation", this.radiationScale);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        for (ITileComponent component : this.components) {
            component.readFromUpdateTag(tag);
        }
        this.radiationScale = tag.getFloat("radiation");
    }

    public void onNeighborChange(Block block, BlockPos neighborPos) {
        if (!this.isRemote()) {
            this.updatePower();
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.updatePower();
        if (this.getClientActive()) {
            this.currentActive = true;
        }
    }

    @Override
    public TileComponentFrequency getFrequencyComponent() {
        return this.frequencyComponent;
    }

    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData data) {
        Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
    }

    @Override
    @NotNull
    @ComputerMethod(restriction=MethodRestriction.DIRECTIONAL)
    public final Direction getDirection() {
        if (this.isDirectional()) {
            if (this.cachedDirection != null) {
                return this.cachedDirection;
            }
            BlockState state = this.getBlockState();
            this.cachedDirection = Attribute.getFacing(state);
            if (this.cachedDirection != null) {
                return this.cachedDirection;
            }
            if (!this.getType().isValid(state)) {
                Mekanism.logger.warn("Error invalid block for tile {} at {} in {}. Unable to get direction, falling back to north, things will probably not work correctly. This is almost certainly due to another mod incorrectly trying to move this tile and not properly updating the position.", new Object[]{Util.getRegisteredName((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (Object)this.getType()), this.worldPosition, this.level});
            }
        }
        return Direction.NORTH;
    }

    protected void invalidateDirectionCaches(Direction newDirection) {
        this.cachedDirection = newDirection;
    }

    @Override
    public void setFacing(@NotNull Direction direction) {
        this.setFacing(direction, true);
    }

    public void setFacing(@NotNull Direction direction, boolean notifyCaps) {
        if (this.isDirectional() && direction != this.cachedDirection && this.level != null) {
            this.invalidateDirectionCaches(direction);
            BlockState state = Attribute.setFacing(this.getBlockState(), direction);
            if (state != null) {
                this.level.setBlockAndUpdate(this.worldPosition, state);
                if (notifyCaps) {
                    this.invalidateCapabilitiesFull();
                }
            }
        }
    }

    @Override
    @ComputerMethod(nameOverride="getRedstoneMode", restriction=MethodRestriction.REDSTONE_CONTROL)
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(@NotNull IRedstoneControl.RedstoneControl type) {
        if (this.supportsRedstone() && (type = this.supportedOrNextType(type)) != this.controlType) {
            this.controlType = type;
            this.markForSave();
        }
    }

    private IRedstoneControl.RedstoneControl supportedOrNextType(@NotNull IRedstoneControl.RedstoneControl type) {
        Objects.requireNonNull(type);
        if (!this.supportsMode(type)) {
            type = type.getNext(this::supportsMode);
        }
        return type;
    }

    @Override
    public boolean isPowered() {
        return this.supportsRedstone() && this.redstone;
    }

    @Override
    public final boolean wasPowered() {
        return this.supportsRedstone() && this.redstoneLastTick;
    }

    public final void updatePower() {
        boolean power;
        if (this.supportsRedstone() && this.redstone != (power = this.level.hasNeighborSignal(this.getBlockPos()))) {
            this.redstone = power;
            this.onPowerChange();
        }
    }

    public final boolean isRedstoneActivated() {
        boolean bl;
        block10: {
            block9: {
                block8: {
                    if (!this.supportsRedstone()) break block8;
                    switch (this.controlType) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case DISABLED: {
                            break;
                        }
                        case HIGH: {
                            if (this.isPowered()) {
                                break;
                            }
                            break block9;
                        }
                        case LOW: {
                            if (!this.isPowered()) {
                                break;
                            }
                            break block9;
                        }
                        case PULSE: {
                            if (!this.isPowered() || this.redstoneLastTick) break block9;
                        }
                    }
                }
                bl = true;
                break block10;
            }
            bl = false;
        }
        return bl;
    }

    public boolean canFunction() {
        return this.isRedstoneActivated();
    }

    @Override
    public int getRedstoneLevel() {
        if (this.supportsComparator() && this.hasInventory()) {
            return MekanismUtils.redstoneLevelFromContents(this.getInventorySlots(null));
        }
        return 0;
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.ITEM;
    }

    protected final IContentsListener getListener(ContainerType<?, ?, ?> type, IContentsListener saveOnlyListener) {
        return !this.supportsComparator() || this.makesComparatorDirty(type) ? this : saveOnlyListener;
    }

    @Override
    @ComputerMethod(nameOverride="getComparatorLevel", restriction=MethodRestriction.COMPARATOR)
    public int getCurrentRedstoneLevel() {
        return this.currentRedstoneLevel;
    }

    @Override
    @NotNull
    public Set<Upgrade> getSupportedUpgrade() {
        if (this.supportsUpgrades()) {
            return Attribute.getOrThrow(this.getBlockHolder(), AttributeUpgradeSupport.class).supportedUpgrades();
        }
        return Collections.emptySet();
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        block3: {
            block2: {
                if (upgrade != Upgrade.SPEED) break block2;
                for (IEnergyContainer energyContainer : this.getEnergyContainers(null)) {
                    if (!(energyContainer instanceof MachineEnergyContainer)) continue;
                    MachineEnergyContainer machineEnergy = (MachineEnergyContainer)energyContainer;
                    machineEnergy.updateEnergyPerTick();
                }
                break block3;
            }
            if (upgrade != Upgrade.ENERGY) break block3;
            for (IEnergyContainer energyContainer : this.getEnergyContainers(null)) {
                if (!(energyContainer instanceof MachineEnergyContainer)) continue;
                MachineEnergyContainer machineEnergy = (MachineEnergyContainer)energyContainer;
                machineEnergy.updateMaxEnergy();
                machineEnergy.updateEnergyPerTick();
            }
        }
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        return null;
    }

    @Override
    @NotNull
    public final List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.itemHandlerManager != null ? this.itemHandlerManager.getContainers(side) : Collections.emptyList();
    }

    @Override
    public void onContentsChanged() {
        this.setChanged();
    }

    public void applyInventorySlots(BlockEntity.DataComponentInput input, List<IInventorySlot> slots, AttachedItems attachedItems) {
        List<ItemStack> stacks = attachedItems.containers();
        int size = stacks.size();
        if (size == slots.size()) {
            for (int i = 0; i < size; ++i) {
                ItemStack stack = stacks.get(i).copy();
                IInventorySlot slot = slots.get(i);
                if (slot instanceof BasicInventorySlot) {
                    BasicInventorySlot basicSlot = (BasicInventorySlot)slot;
                    basicSlot.setStackUnchecked(stack);
                    continue;
                }
                slot.setStack(stack);
            }
        }
    }

    @Nullable
    public AttachedItems collectInventorySlots(DataComponentMap.Builder builder, List<IInventorySlot> slots) {
        boolean hasNonEmpty = false;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(slots.size());
        for (IInventorySlot slot : slots) {
            stacks.add(slot.getStack().copy());
            if (slot.isEmpty()) continue;
            hasNonEmpty = true;
        }
        return hasNonEmpty ? new AttachedItems(stacks) : null;
    }

    public boolean shouldDumpRadiation() {
        return this.canHandleChemicals();
    }

    private boolean updateRadiationScale() {
        float scale;
        if (this.shouldDumpRadiation() && Math.abs((scale = ITileRadioactive.calculateRadiationScale(this.getChemicalTanks(null))) - this.radiationScale) > 0.05f) {
            this.radiationScale = scale;
            return true;
        }
        return false;
    }

    @Override
    public float getRadiationScale() {
        return RadiationManager.isGlobalRadiationEnabled() ? this.radiationScale : 0.0f;
    }

    @Nullable
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        return null;
    }

    @Override
    @NotNull
    public List<IChemicalTank> getChemicalTanks(@Nullable Direction side) {
        return this.chemicalHandlerManager == null ? Collections.emptyList() : this.chemicalHandlerManager.getContainers(side);
    }

    public void applyChemicalTanks(BlockEntity.DataComponentInput input, List<IChemicalTank> tanks, AttachedChemicals attachedChemicals) {
        List<ChemicalStack> stacks = attachedChemicals.containers();
        int size = stacks.size();
        if (size == tanks.size()) {
            for (int i = 0; i < size; ++i) {
                tanks.get(i).setStackUnchecked(stacks.get(i).copy());
            }
        }
    }

    @Nullable
    public AttachedChemicals collectChemicalTanks(DataComponentMap.Builder builder, List<IChemicalTank> tanks) {
        boolean hasNonEmpty = false;
        ArrayList<ChemicalStack> stacks = new ArrayList<ChemicalStack>(tanks.size());
        boolean skipRadioactive = RadiationManager.isGlobalRadiationEnabled() && this.shouldDumpRadiation();
        for (IChemicalTank tank : tanks) {
            if (tank.isEmpty() || skipRadioactive && tank.getStack().isRadioactive()) {
                stacks.add(ChemicalStack.EMPTY);
                continue;
            }
            hasNonEmpty = true;
            stacks.add(tank.getStack().copy());
        }
        return hasNonEmpty ? new AttachedChemicals(stacks) : null;
    }

    @Deprecated(forRemoval=true, since="10.7.0")
    public List<IChemicalTank> getLegacyGasTanks() {
        return this.getChemicalTanks(null);
    }

    @Deprecated(forRemoval=true, since="10.7.0")
    public List<IChemicalTank> getLegacyInfuseTanks() {
        return this.getChemicalTanks(null);
    }

    @Deprecated(forRemoval=true, since="10.7.0")
    public List<IChemicalTank> getLegacyPigmentTanks() {
        return this.getChemicalTanks(null);
    }

    @Deprecated(forRemoval=true, since="10.7.0")
    public List<IChemicalTank> getLegacySlurryTanks() {
        return this.getChemicalTanks(null);
    }

    @Nullable
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        return null;
    }

    @Override
    @NotNull
    public final List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidHandlerManager != null ? this.fluidHandlerManager.getContainers(side) : Collections.emptyList();
    }

    public void applyFluidTanks(BlockEntity.DataComponentInput input, List<IExtendedFluidTank> tanks, AttachedFluids attachedFluids) {
        List<FluidStack> stacks = attachedFluids.containers();
        int size = stacks.size();
        if (size == tanks.size()) {
            for (int i = 0; i < size; ++i) {
                tanks.get(i).setStackUnchecked(stacks.get(i).copy());
            }
        }
    }

    @Nullable
    public AttachedFluids collectFluidTanks(DataComponentMap.Builder builder, List<IExtendedFluidTank> tanks) {
        boolean hasNonEmpty = false;
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>(tanks.size());
        for (IExtendedFluidTank tank : tanks) {
            stacks.add(tank.getFluid().copy());
            if (tank.isEmpty()) continue;
            hasNonEmpty = true;
        }
        return hasNonEmpty ? new AttachedFluids(stacks) : null;
    }

    @Nullable
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        return null;
    }

    @Override
    @NotNull
    public final List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyHandlerManager != null ? this.energyHandlerManager.getContainers(side) : Collections.emptyList();
    }

    @Override
    public long insertEnergy(int container, long amount, @Nullable Direction side, @NotNull Action action) {
        return this.trackLastEnergy(amount, action, IMekanismStrictEnergyHandler.super.insertEnergy(container, amount, side, action));
    }

    @Override
    public long insertEnergy(long amount, @Nullable Direction side, @NotNull Action action) {
        return this.trackLastEnergy(amount, action, IMekanismStrictEnergyHandler.super.insertEnergy(amount, side, action));
    }

    private long trackLastEnergy(long amount, @NotNull Action action, long remainder) {
        if (action.execute()) {
            this.lastEnergyTracker.received(this.level == null ? 0L : this.level.getGameTime(), amount - remainder);
        }
        return remainder;
    }

    public final long getInputRate() {
        return this.lastEnergyTracker.getLastEnergyReceived();
    }

    public void applyEnergyContainers(BlockEntity.DataComponentInput input, List<IEnergyContainer> containers, AttachedEnergy attachedEnergy) {
        List<Long> stored = attachedEnergy.containers();
        int size = stored.size();
        if (size == containers.size()) {
            for (int i = 0; i < size; ++i) {
                containers.get(i).setEnergy(stored.get(i));
            }
        }
    }

    @Nullable
    public AttachedEnergy collectEnergyContainers(DataComponentMap.Builder builder, List<IEnergyContainer> containers) {
        boolean hasNonEmpty = false;
        ArrayList<Long> stored = new ArrayList<Long>(containers.size());
        for (IEnergyContainer container : containers) {
            stored.add(container.getEnergy());
            if (container.isEmpty()) continue;
            hasNonEmpty = true;
        }
        return hasNonEmpty ? new AttachedEnergy(stored) : null;
    }

    @Nullable
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        return null;
    }

    @Override
    public double getAmbientTemperature(@NotNull Direction side) {
        if (this.canHandleHeat() && this.ambientTemperature != null) {
            return this.ambientTemperature.getTemperature(side);
        }
        return ITileHeatHandler.super.getAmbientTemperature(side);
    }

    @Override
    @Nullable
    public IHeatHandler getAdjacent(@NotNull Direction side) {
        if (this.canHandleHeat() && this.getHeatCapacitorCount(side) > 0) {
            return this.getAdjacentUnchecked(side);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    protected IHeatHandler getAdjacentUnchecked(@NotNull Direction side) {
        @Nullable BlockCapabilityCache cache = this.adjacentHeatCaps.get(side);
        if (cache == null) {
            cache = BlockCapabilityCache.create(Capabilities.HEAT, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition.relative(side), (Object)side.getOpposite());
            this.adjacentHeatCaps.put(side, (BlockCapabilityCache<IHeatHandler, Direction>)cache);
        }
        return (IHeatHandler)cache.getCapability();
    }

    @Override
    @NotNull
    public final List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction side) {
        return this.heatHandlerManager != null ? this.heatHandlerManager.getContainers(side) : Collections.emptyList();
    }

    public void applyHeatCapacitors(BlockEntity.DataComponentInput input, List<IHeatCapacitor> capacitors, AttachedHeat attachedHeat) {
        List<HeatCapacitorData> stored = attachedHeat.containers();
        int size = stored.size();
        if (size == capacitors.size()) {
            for (int i = 0; i < size; ++i) {
                IHeatCapacitor capacitor = capacitors.get(i);
                HeatCapacitorData data = stored.get(i);
                if (data.heat().isPresent()) {
                    capacitor.setHeat(data.heat().getAsDouble());
                }
                if (!(capacitor instanceof BasicHeatCapacitor)) continue;
                BasicHeatCapacitor basic = (BasicHeatCapacitor)capacitor;
                basic.setHeatCapacity(data.capacity(), false);
            }
        }
    }

    @Nullable
    public AttachedHeat collectHeatCapacitors(DataComponentMap.Builder builder, List<IHeatCapacitor> capacitors) {
        ArrayList<HeatCapacitorData> stored = new ArrayList<HeatCapacitorData>(capacitors.size());
        for (IHeatCapacitor capacitor : capacitors) {
            if (capacitor.isAmbientTemperature()) {
                stored.add(new HeatCapacitorData(capacitor.getHeatCapacity()));
                continue;
            }
            stored.add(new HeatCapacitorData(capacitor.getHeat(), capacitor.getHeatCapacity()));
        }
        return new AttachedHeat(stored);
    }

    @Override
    public CompoundTag getConfigurationData(HolderLookup.Provider provider, Player player) {
        CompoundTag data = new CompoundTag();
        this.writeSustainedData(provider, data);
        this.getFrequencyComponent().writeConfiguredFrequencies(provider, data);
        return data;
    }

    @Override
    public void setConfigurationData(HolderLookup.Provider provider, Player player, CompoundTag data) {
        this.readSustainedData(provider, data);
        this.getFrequencyComponent().readConfiguredFrequencies(provider, player, data);
    }

    @Override
    public Block getConfigurationDataType() {
        return this.getBlockState().getBlock();
    }

    @Override
    public void configurationDataSet() {
        this.setChanged();
        this.invalidateCapabilitiesFull();
        this.sendUpdatePacket();
        WorldUtils.notifyLoadedNeighborsOfTileChange(this.getLevel(), this.getBlockPos());
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public void onSecurityChanged(@NotNull SecurityMode old, @NotNull SecurityMode mode) {
        if (!this.isRemote() && this.hasGui() && this.level != null) {
            BlockSecurityUtils.get().securityChanged(this.playersUsing, this.level, this.worldPosition, this, old, mode);
        }
    }

    @Override
    public boolean getActive() {
        return this.isRemote() ? this.getClientActive() : this.currentActive;
    }

    private boolean getClientActive() {
        return this.activeAttribute != null && this.activeAttribute.isActive(this.getBlockState());
    }

    @Override
    public void setActive(boolean active) {
        if (this.isActivatable() && active != this.currentActive) {
            BlockState state = this.getBlockState();
            if (this.activeAttribute != null) {
                this.currentActive = active;
                if (this.getClientActive() != active) {
                    if (active) {
                        this.level.setBlockAndUpdate(this.worldPosition, this.activeAttribute.setActive(state, true));
                    } else {
                        if (this.updateDelay == 0) {
                            this.level.setBlockAndUpdate(this.worldPosition, this.activeAttribute.setActive(state, this.currentActive));
                        }
                        this.updateDelay = this.delaySupplier.getAsInt();
                    }
                }
            }
        }
    }

    protected boolean canPlaySound() {
        return this.getActive();
    }

    private void updateSound() {
        if (!this.hasSound() || !MekanismConfig.client.enableMachineSounds.get() || this.soundEvent == null) {
            return;
        }
        if (this.canPlaySound() && !this.isRemoved()) {
            if (--this.playSoundCooldown > 0) {
                return;
            }
            SoundEvent sound = this.soundEvent.get();
            if (sound != this.lastSoundEvent) {
                if (this.activeSound != null) {
                    SoundHandler.stopTileSound(this.getSoundPos());
                    this.activeSound = null;
                }
                this.lastSoundEvent = sound;
            }
            if (!(this.isFullyMuffled() || this.activeSound != null && Minecraft.getInstance().getSoundManager().isActive(this.activeSound))) {
                this.activeSound = SoundHandler.startTileSound(this.lastSoundEvent, this.getSoundCategory(), this.getInitialVolume(), this.level.getRandom(), this.getSoundPos());
            }
            this.playSoundCooldown = 20;
        } else if (this.activeSound != null) {
            SoundHandler.stopTileSound(this.getSoundPos());
            this.activeSound = null;
            this.playSoundCooldown = 0;
        }
    }

    protected boolean isFullyMuffled() {
        if (this.hasSound() && this.supportsUpgrade(Upgrade.MUFFLING)) {
            return this.getComponent().getUpgrades(Upgrade.MUFFLING) >= Upgrade.MUFFLING.getMax();
        }
        return false;
    }

    @Override
    public String getComputerName() {
        if (this.hasComputerSupport()) {
            return Attribute.getOrThrow(this.getBlockHolder(), Attributes.AttributeComputerIntegration.class).name();
        }
        return "";
    }

    public void validateSecurityIsPublic() throws ComputerException {
        if (this.hasSecurity() && IBlockSecurityUtils.INSTANCE.getSecurityMode(this.getWorldNN(), this.worldPosition, this) != SecurityMode.PUBLIC) {
            throw new ComputerException("Setter not available due to machine security not being public.");
        }
    }

    @Override
    public void getComputerMethods(BoundMethodHolder holder) {
        IComputerTile.super.getComputerMethods(holder);
        for (ITileComponent component : this.components) {
            FactoryRegistry.bindTo(holder, component);
        }
    }

    @ComputerMethod(nameOverride="getEnergy", restriction=MethodRestriction.ENERGY)
    long getTotalEnergy() {
        return this.getTotalEnergy(IEnergyContainer::getEnergy);
    }

    @ComputerMethod(nameOverride="getMaxEnergy", restriction=MethodRestriction.ENERGY)
    long getTotalMaxEnergy() {
        return this.getTotalEnergy(IEnergyContainer::getMaxEnergy);
    }

    @ComputerMethod(nameOverride="getEnergyNeeded", restriction=MethodRestriction.ENERGY)
    long getTotalEnergyNeeded() {
        return this.getTotalEnergy(IEnergyContainer::getNeeded);
    }

    private long getTotalEnergy(ToLongFunction<IEnergyContainer> getter) {
        long total = 0L;
        List<IEnergyContainer> energyContainers = this.getEnergyContainers(null);
        for (IEnergyContainer energyContainer : energyContainers) {
            total = MathUtils.addClamped(total, getter.applyAsLong(energyContainer));
        }
        return total;
    }

    @ComputerMethod(nameOverride="getEnergyFilledPercentage", restriction=MethodRestriction.ENERGY)
    double getTotalEnergyFilledPercentage() {
        long stored = 0L;
        long max = 0L;
        List<IEnergyContainer> energyContainers = this.getEnergyContainers(null);
        for (IEnergyContainer energyContainer : energyContainers) {
            stored = MathUtils.addClamped(stored, energyContainer.getEnergy());
            max = MathUtils.addClamped(max, energyContainer.getMaxEnergy());
        }
        return MathUtils.divideToLevel(stored, max);
    }

    @ComputerMethod(restriction=MethodRestriction.REDSTONE_CONTROL, requiresPublicSecurity=true)
    void setRedstoneMode(IRedstoneControl.RedstoneControl type) throws ComputerException {
        this.validateSecurityIsPublic();
        if (!this.supportsMode(type)) {
            throw new ComputerException("Unsupported redstone control mode: %s", type);
        }
        this.setControlType(type);
    }
}

