/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityPersonalStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class TileEntityPersonalBarrel
extends TileEntityPersonalStorage {
    public TileEntityPersonalBarrel(BlockPos pos, BlockState state) {
        super((Holder<Block>)MekanismBlocks.PERSONAL_BARREL, pos, state);
    }

    @Override
    protected void onOpen(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        this.playSound(level, state, SoundEvents.BARREL_OPEN);
        level.setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void onClose(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        this.playSound(level, state, SoundEvents.BARREL_CLOSE);
        level.setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(false)));
    }

    private void playSound(@NotNull Level level, BlockState state, SoundEvent sound) {
        Vec3i vec3i = ((Direction)state.getValue((Property)BarrelBlock.FACING)).getNormal();
        double d0 = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double d1 = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        level.playSound(null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    protected ResourceLocation getStat() {
        return Stats.OPEN_BARREL;
    }
}

