/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.qio;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOCraftingTransferHelper;
import mekanism.common.content.qio.QIOServerCraftingTransferHandler;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public record PacketQIOFillCraftingWindow(ResourceLocation recipeID, boolean transferMultiple, boolean rejectToInventory, Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>> sources) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketQIOFillCraftingWindow> TYPE = new CustomPacketPayload.Type(Mekanism.rl("fill_qio"));
    public static final StreamCodec<ByteBuf, PacketQIOFillCraftingWindow> STREAM_CODEC = StreamCodec.ofMember(PacketQIOFillCraftingWindow::write, PacketQIOFillCraftingWindow::decode);

    @NotNull
    public CustomPacketPayload.Type<PacketQIOFillCraftingWindow> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof QIOItemViewerContainer) {
            QIOItemViewerContainer container = (QIOItemViewerContainer)abstractContainerMenu;
            byte selectedCraftingGrid = container.getSelectedCraftingGrid(player.getUUID());
            if (selectedCraftingGrid == -1) {
                Mekanism.logger.warn("Received transfer request from: {}, but they do not currently have a crafting window open.", (Object)player);
            } else {
                Optional<RecipeHolder<?>> optionalRecipe = MekanismRecipeType.byKey(player.level(), this.recipeID);
                if (optionalRecipe.isPresent()) {
                    Recipe recipe = optionalRecipe.get().value();
                    if (recipe instanceof CraftingRecipe) {
                        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
                        QIOServerCraftingTransferHandler.tryTransfer(container, selectedCraftingGrid, this.rejectToInventory, player, this.recipeID, craftingRecipe, this.sources);
                    } else {
                        Mekanism.logger.warn("Received transfer request from: {}, but the type ({}) of the specified recipe was not a crafting recipe.", (Object)player, (Object)recipe.getClass());
                    }
                } else {
                    Mekanism.logger.warn("Received transfer request from: {}, but could not find specified recipe.", (Object)player);
                }
            }
        }
    }

    private void write(@NotNull ByteBuf buffer) {
        ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)this.recipeID);
        buffer.writeBoolean(this.transferMultiple);
        buffer.writeBoolean(this.rejectToInventory);
        buffer.writeByte((int)((byte)this.sources.size()));
        ObjectIterator iterator = Byte2ObjectMaps.fastIterator(this.sources);
        while (iterator.hasNext()) {
            Byte2ObjectMap.Entry entry = (Byte2ObjectMap.Entry)iterator.next();
            buffer.writeByte((int)entry.getByteKey());
            List slotSources = (List)entry.getValue();
            if (this.transferMultiple) {
                ByteBufCodecs.VAR_INT.encode((Object)buffer, (Object)slotSources.size());
            }
            for (QIOCraftingTransferHelper.SingularHashedItemSource source : slotSources) {
                byte sourceSlot = source.getSlot();
                buffer.writeByte((int)sourceSlot);
                if (this.transferMultiple) {
                    ByteBufCodecs.VAR_INT.encode((Object)buffer, (Object)source.getUsed());
                }
                if (sourceSlot != -1) continue;
                UUID qioSource = source.getQioSource();
                if (qioSource == null) {
                    throw new IllegalStateException("Invalid QIO crafting window transfer source.");
                }
                UUIDUtil.STREAM_CODEC.encode((Object)buffer, (Object)qioSource);
            }
        }
    }

    private static PacketQIOFillCraftingWindow decode(ByteBuf buffer) {
        ResourceLocation recipeID = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
        boolean transferMultiple = buffer.readBoolean();
        boolean rejectToInventory = buffer.readBoolean();
        byte slotCount = buffer.readByte();
        Byte2ObjectArrayMap sources = new Byte2ObjectArrayMap((int)slotCount);
        for (byte slot = 0; slot < slotCount; slot = (byte)(slot + 1)) {
            byte targetSlot = buffer.readByte();
            int subSourceCount = transferMultiple ? (Integer)ByteBufCodecs.VAR_INT.decode((Object)buffer) : 1;
            ArrayList<QIOCraftingTransferHelper.SingularHashedItemSource> slotSources = new ArrayList<QIOCraftingTransferHelper.SingularHashedItemSource>(subSourceCount);
            sources.put(targetSlot, slotSources);
            for (int i = 0; i < subSourceCount; ++i) {
                int count;
                byte sourceSlot = buffer.readByte();
                int n = count = transferMultiple ? (Integer)ByteBufCodecs.VAR_INT.decode((Object)buffer) : 1;
                if (sourceSlot == -1) {
                    slotSources.add(new QIOCraftingTransferHelper.SingularHashedItemSource((UUID)UUIDUtil.STREAM_CODEC.decode((Object)buffer), count));
                    continue;
                }
                slotSources.add(new QIOCraftingTransferHelper.SingularHashedItemSource(sourceSlot, count));
            }
        }
        return new PacketQIOFillCraftingWindow(recipeID, transferMultiple, rejectToInventory, (Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>>)sources);
    }
}

