/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.lib.radiation.RadiationScale;
import mekanism.common.registries.MekanismParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;

public class ClientRadiation {
    private static RadiationScale clientRadiationScale = RadiationScale.NONE;
    private static double clientEnvironmentalRadiation = RadiationManager.get().baselineRadiation();
    private static double clientMaxMagnitude = RadiationManager.get().baselineRadiation();

    public static void setClientEnvironmentalRadiation(double radiation, double maxMagnitude) {
        clientEnvironmentalRadiation = radiation;
        clientMaxMagnitude = maxMagnitude;
        clientRadiationScale = RadiationScale.get(clientEnvironmentalRadiation);
    }

    public static double getClientEnvironmentalRadiation() {
        return RadiationManager.isGlobalRadiationEnabled() ? clientEnvironmentalRadiation : RadiationManager.get().baselineRadiation();
    }

    public static double getClientMaxMagnitude() {
        return RadiationManager.isGlobalRadiationEnabled() ? clientMaxMagnitude : RadiationManager.get().baselineRadiation();
    }

    public static RadiationScale getClientScale() {
        return RadiationManager.isGlobalRadiationEnabled() ? clientRadiationScale : RadiationScale.NONE;
    }

    public static void tickClient(Player player) {
        if (!RadiationManager.isGlobalRadiationEnabled()) {
            return;
        }
        RandomSource randomSource = player.level().getRandom();
        if (clientRadiationScale != RadiationScale.NONE && MekanismConfig.client.radiationParticleCount.get() != 0 && randomSource.nextInt(2) == 0) {
            int count = randomSource.nextInt(clientRadiationScale.ordinal() * MekanismConfig.client.radiationParticleCount.get());
            int radius = MekanismConfig.client.radiationParticleRadius.get();
            for (int i = 0; i < count; ++i) {
                double x = player.getX() + randomSource.nextDouble() * (double)radius * 2.0 - (double)radius;
                double y = player.getY() + randomSource.nextDouble() * (double)radius * 2.0 - (double)radius;
                double z = player.getZ() + randomSource.nextDouble() * (double)radius * 2.0 - (double)radius;
                player.level().addParticle((ParticleOptions)MekanismParticleTypes.RADIATION.get(), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void resetClient() {
        ClientRadiation.setClientEnvironmentalRadiation(RadiationManager.get().baselineRadiation(), RadiationManager.get().baselineRadiation());
    }
}

