/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib;

import net.neoforged.fml.ModContainer;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public record Version(int major, int minor, int build) implements Comparable<Version>
{
    public Version(ArtifactVersion artifactVersion) {
        this(artifactVersion.getMajorVersion(), artifactVersion.getMinorVersion(), artifactVersion.getIncrementalVersion());
    }

    public Version(ModContainer container) {
        this(container.getModInfo().getVersion());
    }

    public static Version get(String s) {
        String[] split = s.replace('.', ':').split(":");
        if (split.length != 3) {
            return null;
        }
        int[] digits = new int[3];
        for (int i = 0; i < digits.length; ++i) {
            try {
                digits[i] = Integer.parseInt(split[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return new Version(digits[0], digits[1], digits[2]);
    }

    @Override
    public int compareTo(Version version) {
        if (version.major > this.major) {
            return -1;
        }
        if (version.major == this.major) {
            if (version.minor > this.minor) {
                return -1;
            }
            if (version.minor == this.minor) {
                return Integer.compare(this.build, version.build);
            }
        }
        return 1;
    }

    @Override
    public String toString() {
        return this.major + "." + this.minor + "." + this.build;
    }
}

