/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.IFluidHandlerSlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class HybridInventorySlot
extends BasicInventorySlot
implements IFluidHandlerSlot {
    private boolean isDraining;
    private boolean isFilling;
    private final MergedTank mergedTank;

    public static HybridInventorySlot inputOrDrain(MergedTank mergedTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(mergedTank, "Merged tank cannot be null");
        Predicate<@NotNull ItemStack> fluidInsertPredicate = FluidInventorySlot.getInputPredicate(mergedTank.getFluidTank());
        Predicate<@NotNull ItemStack> chemicalInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(mergedTank.getChemicalTank());
        BiPredicate<@NotNull ItemStack, @NotNull AutomationType> insertPredicate = (stack, automationType) -> switch (mergedTank.getCurrentType()) {
            default -> throw new MatchException(null, null);
            case MergedTank.CurrentType.FLUID -> fluidInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.CHEMICAL -> chemicalInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.EMPTY -> fluidInsertPredicate.test((ItemStack)stack) || chemicalInsertPredicate.test((ItemStack)stack);
        };
        return new HybridInventorySlot(mergedTank, (stack, automationType) -> automationType == AutomationType.MANUAL || !insertPredicate.test((ItemStack)stack, (AutomationType)((Object)automationType)), insertPredicate, listener, x, y);
    }

    public static HybridInventorySlot outputOrFill(MergedTank mergedTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(mergedTank, "Merged tank cannot be null");
        Predicate<@NotNull ItemStack> chemicalExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(mergedTank.getChemicalTank());
        Predicate<@NotNull ItemStack> chemicalInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(mergedTank.getChemicalTank(), stack);
        return new HybridInventorySlot(mergedTank, (stack, automationType) -> {
            if (automationType == AutomationType.MANUAL) {
                return true;
            }
            return switch (mergedTank.getCurrentType()) {
                default -> throw new MatchException(null, null);
                case MergedTank.CurrentType.FLUID -> true;
                case MergedTank.CurrentType.CHEMICAL -> chemicalExtractPredicate.test((ItemStack)stack);
                case MergedTank.CurrentType.EMPTY -> chemicalExtractPredicate.test((ItemStack)stack);
            };
        }, (stack, automationType) -> switch (mergedTank.getCurrentType()) {
            default -> throw new MatchException(null, null);
            case MergedTank.CurrentType.FLUID -> {
                if (automationType == AutomationType.INTERNAL) {
                    yield true;
                }
                yield false;
            }
            case MergedTank.CurrentType.CHEMICAL -> chemicalInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.EMPTY -> automationType == AutomationType.INTERNAL && Capabilities.FLUID.hasCapability((ItemStack)stack) ? true : chemicalInsertPredicate.test((ItemStack)stack);
        }, listener, x, y);
    }

    private HybridInventorySlot(MergedTank mergedTank, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert, @Nullable IContentsListener listener, int x, int y) {
        super(canExtract, canInsert, ConstantPredicates.alwaysTrue(), listener, x, y);
        this.mergedTank = mergedTank;
    }

    @Override
    public IExtendedFluidTank getFluidTank() {
        return this.mergedTank.getFluidTank();
    }

    @Override
    public boolean isDraining() {
        return this.isDraining;
    }

    @Override
    public boolean isFilling() {
        return this.isFilling;
    }

    @Override
    public void setDraining(boolean draining) {
        this.isDraining = draining;
    }

    @Override
    public void setFilling(boolean filling) {
        this.isFilling = filling;
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = super.serializeNBT(provider);
        if (this.isDraining) {
            nbt.putBoolean("draining", true);
        }
        if (this.isFilling) {
            nbt.putBoolean("filling", true);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        this.isDraining = nbt.getBoolean("draining");
        this.isFilling = nbt.getBoolean("filling");
        super.deserializeNBT(provider, nbt);
    }

    public void drainChemicalTank() {
        ChemicalInventorySlot.drainChemicalTank(this, this.mergedTank.getChemicalTank(), (IChemicalHandler)Capabilities.CHEMICAL.getCapability(this.current));
    }

    public void fillChemicalTank() {
        ChemicalInventorySlot.fillChemicalTank(this, this.mergedTank.getChemicalTank(), (IChemicalHandler)Capabilities.CHEMICAL.getCapability(this.current));
    }
}

