/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

public class TransporterManager {
    private static final Map<GlobalPos, Set<TransporterStack>> flowingStacks = new Object2ObjectOpenHashMap();

    private TransporterManager() {
    }

    public static void reset() {
        flowingStacks.clear();
    }

    public static void add(Level world, TransporterStack stack) {
        flowingStacks.computeIfAbsent(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)BlockPos.of((long)stack.getDest())), k -> new HashSet()).add(stack);
    }

    public static void remove(Level world, TransporterStack stack) {
        GlobalPos pos;
        Set<TransporterStack> transporterStacks;
        if (stack.hasPath() && stack.getPathType().hasTarget() && (transporterStacks = flowingStacks.get(pos = GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)BlockPos.of((long)stack.getDest())))) != null && transporterStacks.remove(stack) && transporterStacks.isEmpty()) {
            flowingStacks.remove(pos);
        }
    }

    public static boolean didEmit(ItemStack stack, ItemStack returned) {
        return returned.isEmpty() || returned.getCount() < stack.getCount();
    }

    public static ItemStack getToUse(ItemStack stack, ItemStack returned) {
        return returned.isEmpty() ? stack : StackUtils.size(stack, stack.getCount() - returned.getCount());
    }

    private static int simulateInsert(IItemHandler handler, InventoryInfo inventoryInfo, ItemStack stack, int count, boolean inFlight) {
        int maxStackSize = stack.getMaxStackSize();
        for (int slot = 0; slot < inventoryInfo.slots && count != 0; ++slot) {
            int max = inventoryInfo.getSlotLimit(handler, slot);
            if (max == 0 || !handler.isItemValid(slot, stack)) continue;
            int destCount = inventoryInfo.stackSizes[slot];
            int mergedCount = count + destCount;
            int toAccept = count;
            boolean needsSimulation = false;
            if (destCount > 0) {
                if (destCount >= max || !InventoryUtils.areItemsStackable(inventoryInfo.inventory[slot], stack)) continue;
                if (max > maxStackSize && mergedCount > maxStackSize) {
                    needsSimulation = true;
                    if (count <= maxStackSize) {
                        if (stack.getCount() <= maxStackSize) {
                            stack = stack.copyWithCount(maxStackSize + 1);
                        }
                        toAccept = stack.getCount();
                    } else if (stack.getCount() <= maxStackSize) {
                        stack = stack.copyWithCount(count);
                    }
                } else if (!inFlight) {
                    needsSimulation = true;
                }
            } else {
                needsSimulation = true;
            }
            if (needsSimulation) {
                ItemStack simulatedRemainder = handler.insertItem(slot, stack, true);
                int accepted = stack.getCount() - simulatedRemainder.getCount();
                if (accepted == 0) continue;
                if (accepted < toAccept) {
                    max = inventoryInfo.actualStackSizes[slot] + accepted;
                }
                if (destCount == 0) {
                    inventoryInfo.inventory[slot] = stack;
                }
            }
            if (mergedCount > max) {
                inventoryInfo.stackSizes[slot] = max;
                count = mergedCount - max;
                continue;
            }
            inventoryInfo.stackSizes[slot] = mergedCount;
            return 0;
        }
        return count;
    }

    public static TransitRequest.TransitResponse getPredictedInsert(GlobalPos position, Direction side, IItemHandler handler, TransitRequest request, Map<GlobalPos, Set<TransporterStack>> additionalFlowingStacks) {
        InventoryInfo inventoryInfo = new InventoryInfo(handler);
        if (!TransporterManager.predictFlowing(position, side, handler, inventoryInfo, flowingStacks) || !TransporterManager.predictFlowing(position, side, handler, inventoryInfo, additionalFlowingStacks)) {
            return request.getEmptyResponse();
        }
        return TransporterManager.getPredictedInsert(inventoryInfo, handler, request);
    }

    private static boolean predictFlowing(GlobalPos position, Direction side, IItemHandler handler, InventoryInfo inventoryInfo, Map<GlobalPos, Set<TransporterStack>> flowingStacks) {
        Set<TransporterStack> transporterStacks = flowingStacks.get(position);
        if (transporterStacks != null) {
            for (TransporterStack stack : transporterStacks) {
                int numLeftOver;
                if (stack == null || !stack.getPathType().hasTarget() || (numLeftOver = TransporterManager.simulateInsert(handler, inventoryInfo, stack.itemStack, stack.itemStack.getCount(), true)) <= 0 || numLeftOver == stack.itemStack.getCount() && side != stack.getSideOfDest()) continue;
                return false;
            }
        }
        return true;
    }

    private static TransitRequest.TransitResponse getPredictedInsert(InventoryInfo inventoryInfo, IItemHandler handler, TransitRequest request) {
        for (TransitRequest.ItemData data : request) {
            int numToSend;
            ItemStack stack = data.getStack();
            int numLeftOver = TransporterManager.simulateInsert(handler, inventoryInfo, stack, numToSend = data.getTotalCount(), false);
            if (numLeftOver == numToSend) continue;
            return request.createResponse(StackUtils.size(stack, numToSend - numLeftOver), data);
        }
        return request.getEmptyResponse();
    }

    public static TransitRequest.TransitResponse getPredictedInsert(IItemHandler handler, TransitRequest request) {
        return TransporterManager.getPredictedInsert(new InventoryInfo(handler), handler, request);
    }

    private static class InventoryInfo {
        private final ItemStack[] inventory;
        private final int[] stackSizes;
        private final int[] actualStackSizes;
        private final int[] slotLimits;
        private final int slots;

        public InventoryInfo(IItemHandler handler) {
            this.slots = handler.getSlots();
            this.inventory = new ItemStack[this.slots];
            this.stackSizes = new int[this.slots];
            this.actualStackSizes = new int[this.slots];
            this.slotLimits = new int[this.slots];
            Arrays.fill(this.slotLimits, -1);
            for (int i = 0; i < this.slots; ++i) {
                ItemStack stack;
                this.inventory[i] = stack = handler.getStackInSlot(i);
                this.actualStackSizes[i] = this.stackSizes[i] = stack.getCount();
            }
        }

        public int getSlotLimit(IItemHandler handler, int slot) {
            int limit = this.slotLimits[slot];
            if (limit == -1) {
                this.slotLimits[slot] = handler.getSlotLimit(slot);
                return this.slotLimits[slot];
            }
            return limit;
        }
    }
}

