/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.interfaces.ITypeBlock;
import mekanism.common.tile.base.TileEntityUpdateable;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Attribute {
    default public void adjustProperties(BlockBehaviour.Properties props) {
    }

    public static boolean has(BlockState state, Class<? extends Attribute> type) {
        return Attribute.has((Holder<Block>)state.getBlockHolder(), type);
    }

    public static boolean has(Holder<Block> block, Class<? extends Attribute> type) {
        return Attribute.has((Block)block.value(), type);
    }

    public static boolean has(Block block, Class<? extends Attribute> type) {
        ITypeBlock typeBlock;
        return block instanceof ITypeBlock && (typeBlock = (ITypeBlock)block).getType().has(type);
    }

    @Nullable
    public static <ATTRIBUTE extends Attribute> ATTRIBUTE get(BlockState state, Class<ATTRIBUTE> type) {
        return Attribute.get((Holder<Block>)state.getBlockHolder(), type);
    }

    @Nullable
    public static <ATTRIBUTE extends Attribute> ATTRIBUTE get(Holder<Block> block, Class<ATTRIBUTE> type) {
        return Attribute.get((Block)block.value(), type);
    }

    @Nullable
    public static <ATTRIBUTE extends Attribute> ATTRIBUTE get(Block block, Class<ATTRIBUTE> type) {
        ATTRIBUTE ATTRIBUTE;
        if (block instanceof ITypeBlock) {
            ITypeBlock typeBlock = (ITypeBlock)block;
            ATTRIBUTE = typeBlock.getType().get(type);
        } else {
            ATTRIBUTE = null;
        }
        return ATTRIBUTE;
    }

    public static <ATTRIBUTE extends Attribute> ATTRIBUTE getOrThrow(BlockState state, Class<ATTRIBUTE> type) {
        return Attribute.getOrThrow((Holder<Block>)state.getBlockHolder(), type);
    }

    public static <ATTRIBUTE extends Attribute> ATTRIBUTE getOrThrow(Holder<Block> block, Class<ATTRIBUTE> type) {
        ATTRIBUTE attribute = Attribute.get(block, type);
        if (attribute == null) {
            throw new IllegalStateException("Expected " + String.valueOf(block.value()) + " to have an attribute of type " + type.getSimpleName());
        }
        return attribute;
    }

    public static Collection<Attribute> getAll(Holder<Block> block) {
        Collection<Attribute> collection;
        Object object = block.value();
        if (object instanceof ITypeBlock) {
            ITypeBlock typeBlock = (ITypeBlock)object;
            collection = typeBlock.getType().getAll();
        } else {
            collection = Collections.emptyList();
        }
        return collection;
    }

    public static <ATTRIBUTE extends Attribute> boolean matches(Holder<Block> block, Class<ATTRIBUTE> type, Predicate<? super ATTRIBUTE> checker) {
        return Attribute.matches((Block)block.value(), type, checker);
    }

    public static <ATTRIBUTE extends Attribute> boolean matches(Block block, Class<ATTRIBUTE> type, Predicate<? super ATTRIBUTE> checker) {
        ATTRIBUTE attribute = Attribute.get(block, type);
        return attribute != null && checker.test(attribute);
    }

    public static <ATTRIBUTE extends Attribute> void ifPresent(Holder<Block> block, Class<ATTRIBUTE> type, Consumer<? super ATTRIBUTE> action) {
        ATTRIBUTE attribute = Attribute.get(block, type);
        if (attribute != null) {
            action.accept(attribute);
        }
    }

    @Nullable
    public static Direction getFacing(BlockState state) {
        AttributeStateFacing attr = Attribute.get(state, AttributeStateFacing.class);
        return attr == null ? null : attr.getDirection(state);
    }

    @Nullable
    public static BlockState setFacing(BlockState state, Direction facing) {
        AttributeStateFacing attr = Attribute.get(state, AttributeStateFacing.class);
        return attr == null ? null : attr.setDirection(state, facing);
    }

    public static boolean isActive(BlockState state) {
        AttributeStateActive attr = Attribute.get(state, AttributeStateActive.class);
        return attr != null && attr.isActive(state);
    }

    @NotNull
    public static BlockState setActive(BlockState state, boolean active) {
        AttributeStateActive attr = Attribute.get(state, AttributeStateActive.class);
        return attr == null ? state : attr.setActive(state, active);
    }

    @Nullable
    public static <TIER extends ITier> TIER getTier(Holder<Block> block, Class<TIER> tierClass) {
        return Attribute.getTier((Block)block.value(), tierClass);
    }

    @Nullable
    public static <TIER extends ITier> TIER getTier(Block block, Class<TIER> tierClass) {
        AttributeTier attr = Attribute.get(block, AttributeTier.class);
        return (TIER)(attr == null ? null : (ITier)tierClass.cast(attr.tier()));
    }

    @Nullable
    public static BaseTier getBaseTier(Holder<Block> block) {
        AttributeTier attr = Attribute.get(block, AttributeTier.class);
        return attr == null ? null : attr.tier().getBaseTier();
    }

    public static interface TileAttribute<TILE extends TileEntityUpdateable>
    extends Attribute {
    }
}

