/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import java.lang.ref.WeakReference;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.custom.GuiQIOCrystallizerScreen;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiChemicalGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.tile.machine.TileEntityChemicalCrystallizer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiChemicalCrystallizer
extends GuiConfigurableTile<TileEntityChemicalCrystallizer, MekanismTileContainer<TileEntityChemicalCrystallizer>> {
    private final GuiQIOCrystallizerScreen.IOreInfo oreInfo = new OreInfo();
    private GuiElement inputGauge;

    public GuiChemicalCrystallizer(MekanismTileContainer<TileEntityChemicalCrystallizer> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.titleLabelY = 4;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityChemicalCrystallizer)this.tile).getEnergyContainer(), 157, 23)).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, ((TileEntityChemicalCrystallizer)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY));
        this.addRenderableWidget(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityChemicalCrystallizer)this.tile).getEnergyContainer(), ((TileEntityChemicalCrystallizer)this.tile)::getActive));
        this.inputGauge = this.addRenderableWidget(new GuiChemicalGauge(() -> ((TileEntityChemicalCrystallizer)this.tile).inputTank, () -> ((TileEntityChemicalCrystallizer)this.tile).getChemicalTanks(null), GaugeType.STANDARD, this, 7, 4)).warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, ((TileEntityChemicalCrystallizer)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT));
        this.addRenderableWidget((GuiProgress)new GuiProgress(((TileEntityChemicalCrystallizer)this.tile)::getScaledProgress, ProgressType.LARGE_RIGHT, (IGuiWrapper)this, 53, 61).recipeViewerCategory((IRecipeLookupHandler)((Object)this.tile))).warning(WarningTracker.WarningType.INPUT_DOESNT_PRODUCE_OUTPUT, ((TileEntityChemicalCrystallizer)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT));
        this.addRenderableWidget(new GuiQIOCrystallizerScreen((IGuiWrapper)this, 31, 13, 115, 42, this.oreInfo));
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleTextWithOffset(guiGraphics, this.inputGauge.getRelativeRight(), ((TileEntityChemicalCrystallizer)this.tile).getEnergySlotX());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    private class OreInfo
    implements GuiQIOCrystallizerScreen.IOreInfo {
        private WeakReference<ChemicalCrystallizerRecipe> cachedRecipe;

        private OreInfo() {
        }

        @Override
        @NotNull
        public ChemicalStack getInputChemical() {
            return ((TileEntityChemicalCrystallizer)((GuiChemicalCrystallizer)GuiChemicalCrystallizer.this).tile).inputTank.getStack();
        }

        @Override
        @Nullable
        public ChemicalCrystallizerRecipe getRecipe() {
            ChemicalCrystallizerRecipe recipe;
            ChemicalStack input = this.getInputChemical();
            if (input.isEmpty()) {
                return null;
            }
            if (this.cachedRecipe == null) {
                recipe = this.getRecipeAndCache();
            } else {
                recipe = (ChemicalCrystallizerRecipe)this.cachedRecipe.get();
                if (recipe == null || !recipe.testType(input)) {
                    recipe = this.getRecipeAndCache();
                }
            }
            return recipe;
        }

        private ChemicalCrystallizerRecipe getRecipeAndCache() {
            ChemicalCrystallizerRecipe recipe = ((TileEntityChemicalCrystallizer)GuiChemicalCrystallizer.this.tile).getRecipe(0);
            this.cachedRecipe = recipe == null ? null : new WeakReference<ChemicalCrystallizerRecipe>(recipe);
            return recipe;
        }
    }
}

