/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom.module;

import java.util.function.Consumer;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.ModuleColorConfig;
import mekanism.api.gear.config.ModuleConfig;
import mekanism.client.gui.GuiModuleTweaker;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.element.custom.module.GuiModuleScreen;
import mekanism.client.gui.element.custom.module.MiniElement;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.GuiColorWindow;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.shared.ModuleColorModulationUnit;
import mekanism.common.lib.Color;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

class ColorSelection
extends MiniElement<Integer> {
    private static final int OFFSET_Y = 1;
    private final int OFFSET_X;
    private final boolean supportsAlpha;
    @Nullable
    private final GuiModuleTweaker.ArmorPreview armorPreview;

    ColorSelection(GuiModuleScreen parent, ModuleColorConfig data, Component description, int xPos, int yPos, @Nullable GuiModuleTweaker.ArmorPreview armorPreview) {
        super(parent, data, description, xPos, yPos);
        this.armorPreview = armorPreview;
        this.supportsAlpha = data.supportsAlpha();
        this.OFFSET_X = this.parent.getScreenWidth() - 26;
    }

    private Color getColor() {
        return Color.argb((Integer)this.data.get());
    }

    @Override
    protected int getNeededHeight() {
        return 20;
    }

    @Override
    protected void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int xTarget = this.getRelativeX() + this.OFFSET_X;
        int yTarget = this.getRelativeY() + 1;
        GuiUtils.drawOutline(guiGraphics, xTarget, yTarget, 18, 18, GuiTextField.SCREEN_COLOR.getAsInt());
        guiGraphics.blit(GuiColorWindow.TRANSPARENCY_GRID, xTarget + 1, yTarget + 1, 0, 0, 16, 16);
        GuiUtils.fill(guiGraphics, xTarget + 1, yTarget + 1, 16, 16, (Integer)this.data.get());
    }

    @Override
    protected void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int textColor = this.parent.screenTextColor();
        this.parent.drawScaledScrollingString(guiGraphics, this.description, this.xPos, this.yPos, IFancyFontRenderer.TextAlignment.LEFT, textColor, this.OFFSET_X, 3, false, 0.8f);
        String hex = this.supportsAlpha ? TextUtils.hex(false, 4, ((Integer)this.data.get()).intValue()) : TextUtils.hex(false, 3, this.getColor().rgb());
        this.parent.drawScrollingString(guiGraphics, (Component)MekanismLang.GENERIC_HEX.translate(hex), this.xPos, this.yPos + 11, IFancyFontRenderer.TextAlignment.LEFT, textColor, this.OFFSET_X, 3, false);
    }

    @Override
    protected void click(double mouseX, double mouseY) {
        if (this.mouseOver(mouseX, mouseY, this.OFFSET_X, 1, 18, 18)) {
            ItemStack stack;
            Item item;
            Consumer<Color> updatePreviewColor = null;
            Runnable previewReset = null;
            IModule<?> currentModule = this.parent.getCurrentModule();
            if (this.armorPreview != null && this.data.name().equals((Object)ModuleColorModulationUnit.COLOR) && currentModule != null && (item = (stack = this.parent.getContainerStack().copy()).getItem()) instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                this.armorPreview.get();
                EquipmentSlot slot = armorItem.getEquipmentSlot();
                this.armorPreview.updatePreview(slot, stack);
                updatePreviewColor = c -> {
                    IModuleContainer moduleContainer = IModuleHelper.INSTANCE.getModuleContainer(stack);
                    if (moduleContainer != null) {
                        moduleContainer.replaceModuleConfig((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), stack, (Holder<ModuleData<?>>)MekanismModules.COLOR_MODULATION_UNIT, (ModuleConfig<?>)this.data.with(c.argb()));
                    }
                };
                previewReset = () -> this.armorPreview.resetToDefault(slot);
            }
            this.parent.gui().addWindow(new GuiColorWindow(this.parent.gui(), (this.parent.getGuiWidth() - 160) / 2, (this.parent.getGuiHeight() - 120) / 2, this.supportsAlpha, this.getColor(), color -> this.setData(color.argb()), this.armorPreview, updatePreviewColor, previewReset));
        }
    }
}

