/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.inventory;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IInventorySlot
extends INBTSerializable<CompoundTag>,
IContentsListener {
    public ItemStack getStack();

    public void setStack(ItemStack var1);

    default public ItemStack insertItem(ItemStack stack, Action action, AutomationType automationType) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int needed = this.getLimit(stack) - this.getCount();
        if (needed <= 0 || !this.isItemValid(stack)) {
            return stack;
        }
        boolean sameType = false;
        if (this.isEmpty() || (sameType = ItemStack.isSameItemSameComponents((ItemStack)this.getStack(), (ItemStack)stack))) {
            int toAdd = Math.min(stack.getCount(), needed);
            if (action.execute()) {
                if (sameType) {
                    this.growStack(toAdd, action);
                } else {
                    this.setStack(stack.copyWithCount(toAdd));
                }
            }
            return stack.copyWithCount(stack.getCount() - toAdd);
        }
        return stack;
    }

    default public ItemStack extractItem(int amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount < 1) {
            return ItemStack.EMPTY;
        }
        ItemStack current = this.getStack();
        int currentAmount = Math.min(current.getCount(), current.getMaxStackSize());
        if (currentAmount < amount) {
            amount = currentAmount;
        }
        ItemStack toReturn = current.copyWithCount(amount);
        if (action.execute()) {
            this.shrinkStack(amount, action);
        }
        return toReturn;
    }

    public int getLimit(ItemStack var1);

    public boolean isItemValid(ItemStack var1);

    @Nullable
    default public Slot createContainerSlot() {
        return null;
    }

    default public int setStackSize(int amount, Action action) {
        if (this.isEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (action.execute()) {
                this.setEmpty();
            }
            return 0;
        }
        ItemStack stack = this.getStack();
        int maxStackSize = this.getLimit(stack);
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (stack.getCount() == amount || action.simulate()) {
            return amount;
        }
        this.setStack(stack.copyWithCount(amount));
        return amount;
    }

    default public int growStack(int amount, Action action) {
        int current = this.getCount();
        if (current == 0) {
            return 0;
        }
        if (amount > 0) {
            amount = Math.min(amount, this.getLimit(this.getStack()));
        }
        int newSize = this.setStackSize(current + amount, action);
        return newSize - current;
    }

    default public int shrinkStack(int amount, Action action) {
        return -this.growStack(-amount, action);
    }

    default public boolean isEmpty() {
        return this.getStack().isEmpty();
    }

    default public void setEmpty() {
        this.setStack(ItemStack.EMPTY);
    }

    default public int getCount() {
        return this.getStack().getCount();
    }

    default public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (!this.isEmpty()) {
            nbt.put("item", SerializerHelper.saveOversized(provider, this.getStack()));
        }
        return nbt;
    }
}

