/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public record CountableIngredient(Ingredient ingredient, int count) implements Predicate<ItemStack>
{
    public static final CountableIngredient EMPTY = new CountableIngredient(Ingredient.EMPTY, 0);
    public static final Codec<CountableIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(CountableIngredient::ingredient), (App)Codec.INT.fieldOf("count").forGetter(CountableIngredient::count)).apply((Applicative)instance, CountableIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CountableIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, CountableIngredient::ingredient, (StreamCodec)ByteBufCodecs.INT, CountableIngredient::count, CountableIngredient::new);

    public static CountableIngredient of(Ingredient ingredient, int count) {
        return new CountableIngredient(ingredient, count);
    }

    public static CountableIngredient of(ItemStack itemStack) {
        return new CountableIngredient(Ingredient.of((ItemStack[])new ItemStack[]{itemStack}), itemStack.getCount());
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.ingredient.test(itemStack) && itemStack.getCount() >= this.count;
    }

    public ItemStack asItemStack() {
        return new ItemStack((ItemLike)Arrays.stream(this.ingredient.getItems()).findFirst().get().getItem(), this.count);
    }
}

