/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.oierbravo.mechanicals.foundation.gui.MechanicalGUITextures;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ToggleIconButton
extends AbstractSimiWidget {
    protected ScreenElement[] icons;
    protected MutableComponent[] labels;
    private int currentIndex;

    public ToggleIconButton(int x, int y, ScreenElement[] icons, MutableComponent[] labels) {
        this(x, y, 18, 18, icons, labels, 0);
    }

    public ToggleIconButton(int x, int y, ScreenElement[] icons, MutableComponent[] labels, int currentIndex) {
        this(x, y, 18, 18, icons, labels, currentIndex);
    }

    public ToggleIconButton(int x, int y, int w, int h, ScreenElement[] icons, MutableComponent[] labels) {
        this(x, y, w, h, icons, labels, 0);
    }

    public ToggleIconButton(int x, int y, int w, int h, ScreenElement[] icons, MutableComponent[] labels, int currentIndex) {
        super(x, y, w, h);
        this.icons = icons;
        this.labels = labels;
        this.currentIndex = currentIndex;
    }

    public void doRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            boolean bl = this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            MechanicalGUITextures button = !this.active ? MechanicalGUITextures.BUTTON_DOWN : (this.isMouseOver(mouseX, mouseY) ? MechanicalGUITextures.BUTTON_HOVER : MechanicalGUITextures.BUTTON);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawBg(graphics, button);
            this.icons[this.currentIndex].render(graphics, this.getX() + 1, this.getY() + 1);
            this.setToolTip((Component)this.getLabel(this.currentIndex));
        }
    }

    protected void drawBg(GuiGraphics graphics, MechanicalGUITextures button) {
        graphics.blit(button.location, this.getX(), this.getY(), button.startX, button.startY, button.width, button.height);
    }

    public void setToolTip(Component text) {
        this.toolTip.clear();
        this.toolTip.add(text);
    }

    public void setCurrentIndex(int pIndex) {
        this.currentIndex = pIndex;
    }

    public void setIcons(ScreenElement[] icon) {
        this.icons = this.icons;
    }

    public void setLabels(MutableComponent[] labels) {
        this.labels = labels;
    }

    public MutableComponent getLabel(int pIndex) {
        return this.labels[pIndex];
    }
}

