/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.blockEntity.behaviour;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class CycleBehavior
extends BlockEntityBehaviour {
    private final int cycleTime;
    private boolean actuateHalfcycle;
    public static final BehaviourType<CycleBehavior> TYPE = new BehaviourType();
    public CycleBehaviourSpecifics specifics;
    private int prevRunningTicks;
    private int runningTicks;
    private boolean running;
    private boolean finished;
    private int cycleDivider;
    private int numCycles;
    private int currentCycle;
    private int actuatedTimes;
    private boolean actuatedInCurrentCycle;

    public <T extends SmartBlockEntity> CycleBehavior(T te, int pCycle, boolean pActuateHalfCycle) {
        super(te);
        this.specifics = (CycleBehaviourSpecifics)te;
        this.cycleTime = pCycle;
        this.actuateHalfcycle = pActuateHalfCycle;
        this.numCycles = 0;
        this.cycleDivider = this.actuateHalfcycle ? 2 : 1;
        this.currentCycle = 0;
        this.actuatedTimes = 0;
        this.actuatedInCurrentCycle = false;
    }

    public void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.running = compound.getBoolean("Running");
        this.finished = compound.getBoolean("Finished");
        this.prevRunningTicks = this.runningTicks = compound.getInt("Ticks");
        this.currentCycle = compound.getInt("CurrentCycle");
        this.numCycles = compound.getInt("NumCycles");
        this.actuatedTimes = compound.getInt("ActuatedTimes");
        this.actuatedInCurrentCycle = compound.getBoolean("Actuated");
        super.read(compound, registries, clientPacket);
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putBoolean("Running", this.running);
        compound.putBoolean("Finished", this.finished);
        compound.putInt("Ticks", this.runningTicks);
        compound.putInt("CurrentCycle", this.currentCycle);
        compound.putInt("NumCycles", this.numCycles);
        compound.putInt("ActuatedTimes", this.actuatedTimes);
        compound.putBoolean("Actuated", this.actuatedInCurrentCycle);
        super.write(compound, registries, clientPacket);
    }

    public void start() {
        this.running = true;
        this.finished = false;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.currentCycle = 0;
        this.actuatedTimes = 0;
        this.actuatedInCurrentCycle = false;
        this.numCycles = this.specifics.getCycles();
        this.blockEntity.sendData();
    }

    public void stop() {
        this.running = false;
        this.finished = false;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.currentCycle = 0;
        this.actuatedTimes = 0;
        this.actuatedInCurrentCycle = false;
        this.numCycles = this.specifics.getCycles();
        this.blockEntity.sendData();
    }

    public void restartCycle() {
        this.running = true;
        this.finished = false;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.actuatedInCurrentCycle = false;
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void tick() {
        super.tick();
        Level level = this.getWorld();
        if (!this.running || level == null) {
            if (level != null && !level.isClientSide) {
                if (this.specifics.getKineticSpeed() == 0.0f) {
                    return;
                }
                if (this.specifics.tryProcess(true)) {
                    this.start();
                }
            }
            return;
        }
        if (level.isClientSide && this.runningTicks == -this.cycleTime) {
            this.prevRunningTicks = this.cycleTime;
            return;
        }
        if (this.runningTicks >= this.cycleTime / this.cycleDivider && this.specifics.getKineticSpeed() != 0.0f && !this.actuatedInCurrentCycle) {
            ++this.actuatedTimes;
            this.apply();
            if (!level.isClientSide) {
                this.blockEntity.sendData();
                this.specifics.playActuateSound();
            }
            this.actuatedInCurrentCycle = true;
        }
        if (!level.isClientSide && this.runningTicks >= this.cycleTime) {
            this.specifics.onCycleCompleted();
            ++this.currentCycle;
            if (this.currentCycle == this.numCycles) {
                this.finished = true;
                this.running = false;
                this.specifics.onOperationCompletd();
                this.specifics.playCompletionSound();
            } else {
                if (!this.specifics.tryProcess(true)) {
                    this.stop();
                    return;
                }
                this.restartCycle();
            }
            this.blockEntity.sendData();
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        this.runningTicks += this.getRunningTickSpeed();
        if (level.isClientSide) {
            this.specifics.playRunningSound();
            this.specifics.showParticles();
        }
        if (this.prevRunningTicks < this.cycleTime && this.runningTicks >= this.cycleTime) {
            this.runningTicks = this.cycleTime;
            if (level.isClientSide && !this.blockEntity.isVirtual()) {
                this.runningTicks = -this.cycleTime;
            }
        }
    }

    public float getProgress(float partialTicks) {
        if (!this.running) {
            return 0.0f;
        }
        int runningTicks = Math.abs(this.runningTicks);
        float ticks = Mth.lerp((float)partialTicks, (float)this.prevRunningTicks, (float)runningTicks);
        return ticks / (float)this.cycleTime * 100.0f;
    }

    protected void apply() {
        Level level = this.getWorld();
        if (this.actuatedTimes != this.numCycles) {
            return;
        }
        if (level.isClientSide) {
            return;
        }
        if (this.specifics.tryProcess(false)) {
            this.blockEntity.sendData();
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getKineticSpeed();
        if (speed == 0.0f) {
            return 0;
        }
        return (int)Mth.lerp((float)Mth.clamp((float)(Math.abs(speed) / 512.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)60.0f);
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getTotalProgressPercent() {
        return Mth.clamp((int)(this.prevRunningTicks * 100 / (this.cycleTime / this.cycleDivider) * this.numCycles), (int)0, (int)100);
    }

    public int getCycleProgressPercent() {
        return Mth.clamp((int)(this.prevRunningTicks * 100 / (this.cycleTime / this.cycleDivider)), (int)0, (int)100);
    }

    public int getCycleTime() {
        return this.cycleTime;
    }

    public int getCurrentCycle() {
        return this.currentCycle;
    }

    public int getActuatedTimes() {
        return this.actuatedTimes;
    }

    public int getCycles() {
        return this.numCycles;
    }

    public int getPrevRunningTicks() {
        return this.prevRunningTicks;
    }

    public int getRunningTicks() {
        return this.runningTicks;
    }

    public static interface CycleBehaviourSpecifics {
        default public void onCycleCompleted() {
        }

        default public void onOperationCompletd() {
        }

        default public void playActuateSound() {
        }

        default public void playRunningSound() {
        }

        default public void showParticles() {
        }

        default public void playCompletionSound() {
        }

        public int getCycles();

        public float getKineticSpeed();

        public boolean tryProcess(boolean var1);
    }
}

