/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.InputConstants;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.AbstractPlatform;
import com.refinedmods.refinedstorage.common.Config;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.FluidOperationResult;
import com.refinedmods.refinedstorage.common.support.containermenu.TransferManager;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.CustomBlockPlaceContext;
import com.refinedmods.refinedstorage.neoforge.ConfigImpl;
import com.refinedmods.refinedstorage.neoforge.api.RefinedStorageNeoForgeApi;
import com.refinedmods.refinedstorage.neoforge.grid.strategy.ItemGridInsertionStrategy;
import com.refinedmods.refinedstorage.neoforge.support.containermenu.ContainerTransferDestination;
import com.refinedmods.refinedstorage.neoforge.support.containermenu.MenuOpenerImpl;
import com.refinedmods.refinedstorage.neoforge.support.energy.EnergyStorageAdapter;
import com.refinedmods.refinedstorage.neoforge.support.render.FluidStackFluidRenderer;
import com.refinedmods.refinedstorage.neoforge.support.resource.VariantUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.PacketDistributor;

public final class PlatformImpl
extends AbstractPlatform {
    private final ConfigImpl config = new ConfigImpl();

    public PlatformImpl(ModContainer modContainer) {
        super(new MenuOpenerImpl(), new FluidStackFluidRenderer(), ItemGridInsertionStrategy::new);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.config.getSpec());
    }

    @Override
    public long getBucketAmount() {
        return 1000L;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public boolean canEditBoxLoseFocus(EditBox editBox) {
        return editBox.canLoseFocus;
    }

    @Override
    public boolean isKeyDown(KeyMapping keyMapping) {
        return !keyMapping.isUnbound() && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keyMapping.getKey().getValue());
    }

    @Override
    public Optional<FluidOperationResult> drainContainer(ItemStack container) {
        FluidTank tank = new FluidTank(Integer.MAX_VALUE);
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)container, (IFluidHandler)tank, (int)Integer.MAX_VALUE, null, (boolean)true);
        if (!result.isSuccess() || tank.isEmpty()) {
            return Optional.empty();
        }
        FluidResource fluidResource = VariantUtil.ofFluidStack(tank.getFluid());
        return Optional.of(new FluidOperationResult(result.getResult(), fluidResource, tank.getFluidAmount()));
    }

    @Override
    public Optional<FluidOperationResult> fillContainer(ItemStack container, ResourceAmount resourceAmount) {
        ResourceKey resourceKey = resourceAmount.resource();
        if (!(resourceKey instanceof FluidResource)) {
            return Optional.empty();
        }
        FluidResource fluidResource = (FluidResource)resourceKey;
        return FluidUtil.getFluidHandler((ItemStack)container.copy()).map(handler -> {
            FluidStack fluidStack = VariantUtil.toFluidStack(fluidResource, resourceAmount.amount());
            long filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            return new FluidOperationResult(handler.getContainer(), fluidResource, filled);
        });
    }

    @Override
    public TransferManager createTransferManager(AbstractContainerMenu containerMenu) {
        return new TransferManager(containerMenu, ContainerTransferDestination::new);
    }

    @Override
    public long insertIntoContainer(Container container, ItemResource itemResource, long amount, Action action) {
        InvWrapper wrapper = new InvWrapper(container);
        ItemStack stack = itemResource.toItemStack(amount);
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)wrapper, (ItemStack)stack, (action == Action.SIMULATE ? 1 : 0) != 0);
        return amount - (long)remainder.getCount();
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, Level level, BlockHitResult hitResult, Player player) {
        return state.getCloneItemStack((HitResult)hitResult, (LevelReader)level, hitResult.getBlockPos(), player);
    }

    @Override
    public NonNullList<ItemStack> getRemainingCraftingItems(Player player, CraftingRecipe craftingRecipe, CraftingInput input) {
        CommonHooks.setCraftingPlayer((Player)player);
        NonNullList remainingItems = craftingRecipe.getRemainingItems((RecipeInput)input);
        CommonHooks.setCraftingPlayer(null);
        return remainingItems;
    }

    @Override
    public void onItemCrafted(Player player, ItemStack craftedStack, CraftingContainer container) {
        EventHooks.firePlayerCraftingEvent((Player)player, (ItemStack)craftedStack, (Container)container);
    }

    @Override
    public Player getFakePlayer(ServerLevel level, @Nullable UUID playerId) {
        return (Player)Optional.ofNullable(playerId).flatMap(id -> level.getServer().getProfileCache().get(id)).map(profile -> FakePlayerFactory.get((ServerLevel)level, (GameProfile)profile)).orElseGet(() -> FakePlayerFactory.getMinecraft((ServerLevel)level));
    }

    @Override
    public boolean canBreakBlock(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(level, pos, state, player);
        return !((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)e)).isCanceled();
    }

    @Override
    public boolean placeBlock(Level level, BlockPos pos, Direction direction, Player player, ItemStack stack) {
        CustomBlockPlaceContext ctx = new CustomBlockPlaceContext(level, player, InteractionHand.MAIN_HAND, stack, new BlockHitResult(Vec3.ZERO, direction, pos, false));
        InteractionResult result = CommonHooks.onPlaceItemIntoWorld((UseOnContext)ctx);
        return result.consumesAction();
    }

    @Override
    public boolean placeFluid(Level level, BlockPos pos, Direction direction, Player player, FluidResource fluidResource) {
        if (level.getBlockState(pos).getFluidState().isSource()) {
            return false;
        }
        FluidStack stack = VariantUtil.toFluidStack(fluidResource, 1000L);
        FluidTank tank = new FluidTank(1000);
        tank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        return FluidUtil.tryPlaceFluid((Player)player, (Level)level, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (IFluidHandler)tank, (FluidStack)VariantUtil.toFluidStack(fluidResource, 1000L));
    }

    @Override
    public ItemStack getBlockAsItemStack(Block block, BlockState state, Direction direction, LevelReader level, BlockPos position, Player player) {
        return block.getCloneItemStack(state, (HitResult)new BlockHitResult(Vec3.ZERO, direction, position, false), level, position, player);
    }

    @Override
    public Optional<SoundEvent> getBucketPickupSound(LiquidBlock liquidBlock, BlockState state) {
        return liquidBlock.getPickupSound(state);
    }

    @Override
    public List<ClientTooltipComponent> processTooltipComponents(ItemStack stack, GuiGraphics graphics, int mouseX, Optional<TooltipComponent> imageComponent, List<Component> components) {
        return new ArrayList<ClientTooltipComponent>(ClientHooks.gatherTooltipComponents((ItemStack)stack, components, imageComponent, (int)mouseX, (int)graphics.guiWidth(), (int)graphics.guiHeight(), (Font)Minecraft.getInstance().font));
    }

    @Override
    public void renderTooltip(GuiGraphics graphics, List<ClientTooltipComponent> components, int x, int y) {
        graphics.renderTooltipInternal(Minecraft.getInstance().font, components, x, y, DefaultTooltipPositioner.INSTANCE);
    }

    @Override
    public Optional<EnergyStorage> getEnergyStorage(ItemStack stack) {
        return Optional.ofNullable((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)).filter(EnergyStorageAdapter.class::isInstance).map(EnergyStorageAdapter.class::cast).map(EnergyStorageAdapter::energyStorage);
    }

    @Override
    public <T extends CustomPacketPayload> void sendPacketToServer(T packet) {
        PacketDistributor.sendToServer(packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <T extends CustomPacketPayload> void sendPacketToClient(ServerPlayer player, T packet) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void saveSavedData(SavedData savedData, File file, HolderLookup.Provider provider, BiConsumer<File, HolderLookup.Provider> defaultSaveFunction) {
        defaultSaveFunction.accept(file, provider);
    }

    @Override
    @Nullable
    public NetworkNodeContainerProvider getContainerProvider(Level level, BlockPos pos, @Nullable Direction direction) {
        return (NetworkNodeContainerProvider)level.getCapability(RefinedStorageNeoForgeApi.INSTANCE.getNetworkNodeContainerProviderCapability(), pos, (Object)direction);
    }

    @Override
    @Nullable
    public NetworkNodeContainerProvider getContainerProviderSafely(Level level, BlockPos pos, @Nullable Direction direction) {
        if (!level.isLoaded(pos)) {
            return null;
        }
        BlockEntity safeBlockEntity = level.getChunkAt(pos).getBlockEntity(pos, LevelChunk.EntityCreationType.CHECK);
        if (safeBlockEntity == null) {
            return null;
        }
        return (NetworkNodeContainerProvider)level.getCapability(RefinedStorageNeoForgeApi.INSTANCE.getNetworkNodeContainerProviderCapability(), pos, null, safeBlockEntity, (Object)direction);
    }

    @Override
    public void setSlotY(Slot slot, int y) {
        slot.y = y;
    }

    @Override
    public void requestModelDataUpdateOnClient(BlockEntity blockEntity, boolean updateChunk) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        if (!level.isClientSide()) {
            throw new IllegalArgumentException("Cannot request model data update on server");
        }
        blockEntity.requestModelDataUpdate();
        if (updateChunk) {
            level.sendBlockUpdated(blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
        }
    }
}

