/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.energy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.energy.EnergyItemHelper;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class EnergyItemHelperImpl
implements EnergyItemHelper {
    @Override
    public void addTooltip(ItemStack stack, List<Component> lines) {
        RefinedStorageApi.INSTANCE.getEnergyStorage(stack).ifPresent(energyStorage -> {
            long stored = energyStorage.getStored();
            long capacity = energyStorage.getCapacity();
            double pct = (double)stored / (double)capacity;
            lines.add((Component)IdentifierUtil.createStoredWithCapacityTranslation(stored, capacity, pct).withStyle(ChatFormatting.GRAY));
        });
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return RefinedStorageApi.INSTANCE.getEnergyStorage(stack).isPresent();
    }

    @Override
    public int getBarWidth(ItemStack stack) {
        return RefinedStorageApi.INSTANCE.getEnergyStorage(stack).map(energyStorage -> (int)Math.round((double)energyStorage.getStored() / (double)energyStorage.getCapacity() * 13.0)).orElse(0);
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return RefinedStorageApi.INSTANCE.getEnergyStorage(stack).map(energyStorage -> Mth.hsvToRgb((float)(Math.max(0.0f, (float)energyStorage.getStored() / (float)energyStorage.getCapacity()) / 3.0f), (float)1.0f, (float)1.0f)).orElse(0);
    }

    @Override
    public ItemStack createAtEnergyCapacity(Item item) {
        ItemStack stack = item.getDefaultInstance();
        RefinedStorageApi.INSTANCE.getEnergyStorage(stack).ifPresent(energyStorage -> energyStorage.receive(energyStorage.getCapacity(), Action.EXECUTE));
        return stack;
    }
}

