/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.networking.CableConnections;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractCableLikeBlockEntity<T extends AbstractNetworkNode>
extends AbstractBaseNetworkNodeContainerBlockEntity<T> {
    protected CableConnections connections = CableConnections.NONE;

    protected AbstractCableLikeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, T networkNode) {
        super(type, pos, state, networkNode);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.connections.writeToTag(tag);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.connections = CableConnections.fromTag(tag);
        if (this.level != null && this.level.isClientSide()) {
            Platform.INSTANCE.requestModelDataUpdateOnClient(this, true);
        }
    }

    public final void updateConnections() {
        this.connections = AbstractCableLikeBlockEntity.computeConnections(this.level, this.getBlockState(), this.worldPosition);
        this.setChanged();
    }

    @Override
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.connections.writeToTag(super.getUpdateTag(provider));
    }

    public CableConnections getConnections() {
        return this.connections;
    }

    private static CableConnections computeConnections(@Nullable Level level, BlockState state, BlockPos pos) {
        if (level == null) {
            return CableConnections.NONE;
        }
        Direction myDirection = AbstractDirectionalBlock.tryExtractDirection(state);
        boolean north = AbstractCableLikeBlockEntity.hasVisualConnection(state, level, pos, Direction.NORTH, myDirection);
        boolean east = AbstractCableLikeBlockEntity.hasVisualConnection(state, level, pos, Direction.EAST, myDirection);
        boolean south = AbstractCableLikeBlockEntity.hasVisualConnection(state, level, pos, Direction.SOUTH, myDirection);
        boolean west = AbstractCableLikeBlockEntity.hasVisualConnection(state, level, pos, Direction.WEST, myDirection);
        boolean up = AbstractCableLikeBlockEntity.hasVisualConnection(state, level, pos, Direction.UP, myDirection);
        boolean down = AbstractCableLikeBlockEntity.hasVisualConnection(state, level, pos, Direction.DOWN, myDirection);
        return new CableConnections(north, east, south, west, up, down);
    }

    private static boolean hasVisualConnection(BlockState blockState, Level level, BlockPos pos, Direction direction, @Nullable Direction blacklistedDirection) {
        if (direction == blacklistedDirection) {
            return false;
        }
        BlockPos offsetPos = pos.relative(direction);
        NetworkNodeContainerProvider neighbor = Platform.INSTANCE.getContainerProvider(level, offsetPos, direction.getOpposite());
        if (neighbor == null) {
            return false;
        }
        return neighbor.getContainers().stream().anyMatch(container -> container.canAcceptIncomingConnection(direction.getOpposite(), blockState));
    }

    @Override
    public void setBlockState(BlockState newBlockState) {
        super.setBlockState(newBlockState);
        if (this.level != null && !this.level.isClientSide()) {
            this.updateConnections();
            PlatformUtil.sendBlockUpdateToClient(this.level, this.getBlockPos());
        }
    }
}

